/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block;

import de.cristelknight.doapi.common.block.LineConnectingBlock;
import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TableBlock
extends LineConnectingBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape[] LEG_SHAPES = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)13.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)13.0, (double)15.0)};

    public TableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        GeneralUtil.LineConnectingType type = (GeneralUtil.LineConnectingType)((Object)state.m_61143_((Property)TYPE));
        if (type == GeneralUtil.LineConnectingType.MIDDLE) {
            return TOP_SHAPE;
        }
        if (direction == Direction.NORTH && type == GeneralUtil.LineConnectingType.LEFT || direction == Direction.SOUTH && type == GeneralUtil.LineConnectingType.RIGHT) {
            return Shapes.m_83124_((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[0], LEG_SHAPES[3]});
        }
        if (direction == Direction.NORTH && type == GeneralUtil.LineConnectingType.RIGHT || direction == Direction.SOUTH && type == GeneralUtil.LineConnectingType.LEFT) {
            return Shapes.m_83124_((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[1], LEG_SHAPES[2]});
        }
        if (direction == Direction.EAST && type == GeneralUtil.LineConnectingType.LEFT || direction == Direction.WEST && type == GeneralUtil.LineConnectingType.RIGHT) {
            return Shapes.m_83124_((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[0], LEG_SHAPES[1]});
        }
        if (direction == Direction.EAST && type == GeneralUtil.LineConnectingType.RIGHT || direction == Direction.WEST && type == GeneralUtil.LineConnectingType.LEFT) {
            return Shapes.m_83124_((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[2], LEG_SHAPES[3]});
        }
        return Shapes.m_83124_((VoxelShape)TOP_SHAPE, (VoxelShape[])LEG_SHAPES);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos clickedPos;
        Level world;
        return (BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf((world = context.m_43725_()).m_6425_(clickedPos = context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

