/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.cristelknight.doapi.common.block.FacingBlock;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.item.CalendarItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CalendarBlock
extends FacingBlock {
    private static final Map<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0)));
    public static final IntegerProperty MONTH = IntegerProperty.m_61631_((String)"month", (int)0, (int)11);

    public CalendarBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MONTH, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return CalendarBlock.getBoundingShape(state);
    }

    public static VoxelShape getBoundingShape(BlockState state) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)f_54117_));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        for (Direction direction : ctx.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)direction.m_122424_())).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_20163_()) {
            return InteractionResult.PASS;
        }
        player.m_21120_(hand);
        if (world.f_46443_ && this.switchPages((LevelAccessor)world, pos, state, player).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        return this.switchPages((LevelAccessor)world, pos, state, player);
    }

    private InteractionResult switchPages(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        world.m_5594_(null, pos, SoundEvents.f_11713_, SoundSource.PLAYERS, 0.5f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        int currentMonth = (Integer)state.m_61143_((Property)MONTH);
        world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
        int newMonth = currentMonth % 11 + 1;
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)MONTH, (Comparable)Integer.valueOf(newMonth)), 3);
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MONTH});
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122424_() == state.m_61143_((Property)f_54117_) && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        if (world instanceof Level) {
            Level level = (Level)world;
            tooltip.add(CalendarItem.getTime(level));
        }
    }
}

