/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.mixin;

import de.cristelknight.doapi.common.util.GeneralUtil;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.satisfy.vinery.config.VineryConfig;
import net.satisfy.vinery.item.WinemakerBootsItem;
import net.satisfy.vinery.item.WinemakerChestItem;
import net.satisfy.vinery.item.WinemakerHatItem;
import net.satisfy.vinery.item.WinemakerLegsItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BoneMealItem.class})
public abstract class BoneMealItemMixin {
    @Inject(method={"useOn"}, at={@At(value="RETURN")})
    public void useOnBlock(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Player player;
        VineryConfig config = (VineryConfig)VineryConfig.DEFAULT.getConfig();
        RandomSource random = context.m_43725_().m_213780_();
        if (config.enableWineMakerSetBonus() && random.m_188501_() < GeneralUtil.getInPercent((int)config.probabilityToKeepBoneMeal()) && cir.getReturnValue() == InteractionResult.CONSUME && (player = context.m_43723_()) != null) {
            ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
            ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
            ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
            ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
            if (helmet.m_41720_() instanceof WinemakerHatItem && chestplate.m_41720_() instanceof WinemakerChestItem && leggings.m_41720_() instanceof WinemakerLegsItem && boots.m_41720_() instanceof WinemakerBootsItem) {
                if (random.m_188501_() < GeneralUtil.getInPercent((int)config.probabilityForDamage())) {
                    int damage = config.damagePerUse();
                    helmet.m_41622_(damage, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.HEAD));
                    chestplate.m_41622_(damage, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.CHEST));
                    leggings.m_41622_(damage, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.LEGS));
                    boots.m_41622_(damage, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.FEET));
                }
                context.m_43722_().m_41769_(1);
            }
        }
    }
}

