/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats;

import com.github.alexthe666.rats.ConfigHolder;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatVariantRegistry;
import com.github.alexthe666.rats.registry.RatlantisBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsAdvancementsRegistry;
import com.github.alexthe666.rats.registry.RatsBannerPatternRegistry;
import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsCapabilityRegistry;
import com.github.alexthe666.rats.registry.RatsCauldronRegistry;
import com.github.alexthe666.rats.registry.RatsCreativeTabRegistry;
import com.github.alexthe666.rats.registry.RatsDataSerializerRegistry;
import com.github.alexthe666.rats.registry.RatsDispenserRegistry;
import com.github.alexthe666.rats.registry.RatsEffectRegistry;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsLootRegistry;
import com.github.alexthe666.rats.registry.RatsMenuRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.registry.RatsRecipeRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.registry.RatsUpgradeConflictRegistry;
import com.github.alexthe666.rats.registry.RatsVillagerRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisFeatureRegistry;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="rats")
public class RatsMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "rats";
    public static final Rarity RATLANTIS_SPECIAL = Rarity.create((String)"RATS_RATLANTIS_SPECIAL", (ChatFormatting)ChatFormatting.GREEN);
    public static final MobCategory RATS = MobCategory.create((String)"RATS_RATS", (String)"rats", (int)25, (boolean)true, (boolean)false, (int)128);
    public static final BlockSetType PIRAT_WOOD_SET = BlockSetType.m_272115_((BlockSetType)new BlockSetType(new ResourceLocation("rats", "pirat").toString(), true, SoundType.f_244244_, SoundEvents.f_243719_, SoundEvents.f_244275_, SoundEvents.f_244033_, SoundEvents.f_244318_, SoundEvents.f_243893_, SoundEvents.f_244210_, SoundEvents.f_244344_, SoundEvents.f_244414_));
    public static final WoodType PIRAT_WOOD_TYPE = WoodType.m_61844_((WoodType)new WoodType(new ResourceLocation("rats", "pirat").toString(), PIRAT_WOOD_SET, SoundType.f_244244_, SoundType.f_256908_, SoundEvents.f_244593_, SoundEvents.f_244579_));
    public static final GameRules.Key<GameRules.BooleanValue> SPAWN_RATS = GameRules.m_46189_((String)"doRatSpawning", (GameRules.Category)GameRules.Category.SPAWNING, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final GameRules.Key<GameRules.BooleanValue> SPAWN_PIPERS = GameRules.m_46189_((String)"doPiperSpawning", (GameRules.Category)GameRules.Category.SPAWNING, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final GameRules.Key<GameRules.BooleanValue> SPAWN_PLAGUE_DOCTORS = GameRules.m_46189_((String)"doPlagueDoctorSpawning", (GameRules.Category)GameRules.Category.SPAWNING, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static boolean ICEANDFIRE_LOADED;
    public static boolean RATLANTIS_DATAPACK_ENABLED;
    public static boolean HEART_OVERLAY_MOD_INSTALLED;
    public static final List<Item> RATLANTIS_ITEMS;
    private static final List<Pair<String, Component>> MOB_CACHE;

    public RatsMod() {
        ICEANDFIRE_LOADED = ModList.get().isLoaded("iceandfire");
        HEART_OVERLAY_MOD_INSTALLED = ModList.get().isLoaded("mantle") || ModList.get().isLoaded("armorpointspp") || ModList.get().isLoaded("colorfulhearts");
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHolder.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHolder.SERVER_SPEC);
        ForgeMod.enableMilkFluid();
        RatVariantRegistry.RAT_VARIANTS.register(bus);
        RatsBannerPatternRegistry.PATTERNS.register(bus);
        RatsBlockRegistry.BLOCKS.register(bus);
        RatsBlockEntityRegistry.BLOCK_ENTITIES.register(bus);
        RatsEntityRegistry.ENTITIES.register(bus);
        RatsItemRegistry.ITEMS.register(bus);
        RatsDataSerializerRegistry.DATA_SERIALIZERS.register(bus);
        RatsEffectRegistry.MOB_EFFECTS.register(bus);
        RatsLootRegistry.CONDITIONS.register(bus);
        RatsLootRegistry.LOOT_MODIFIERS.register(bus);
        RatsMenuRegistry.MENUS.register(bus);
        RatsParticleRegistry.PARTICLES.register(bus);
        RatsVillagerRegistry.POIS.register(bus);
        RatsVillagerRegistry.PROFESSIONS.register(bus);
        RatsRecipeRegistry.RECIPES.register(bus);
        RatsRecipeRegistry.SERIALIZERS.register(bus);
        RatsSoundRegistry.SOUNDS.register(bus);
        RatsCreativeTabRegistry.TABS.register(bus);
        RatlantisBlockRegistry.BLOCKS.register(bus);
        RatlantisBlockEntityRegistry.BLOCK_ENTITIES.register(bus);
        RatlantisFeatureRegistry.CARVERS.register(bus);
        RatlantisEntityRegistry.ENTITIES.register(bus);
        RatlantisFeatureRegistry.FEATURES.register(bus);
        RatlantisItemRegistry.ITEMS.register(bus);
        RatlantisFeatureRegistry.PROCESSORS.register(bus);
        RatlantisFeatureRegistry.TRUNK_PLACERS.register(bus);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, RatsCapabilityRegistry::attachCap);
        bus.addListener(RatsCapabilityRegistry::registerCapabilities);
        bus.addListener(this::reloadConfigs);
        bus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::addPetShops);
        bus.addListener(this::addRatlantisDatapack);
    }

    public void addRatlantisDatapack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"data", "minecraft", "datapacks", "ratlantis"});
            Pack pack = Pack.m_245429_((String)"ratlantis", (Component)Component.m_237113_((String)"Ratlantis"), (boolean)RatConfig.ratlantisEnabledByDefault, name -> new PathPackResources(name, resourcePath, true), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_244201_);
            event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
        }
    }

    public void reloadConfigs(ModConfigEvent event) {
        if (event.getConfig().getSpec() == ConfigHolder.SERVER_SPEC) {
            RatConfig.bakeServer();
            LOGGER.debug("Reloading Rats Server Config!");
        }
        if (event.getConfig().getSpec() == ConfigHolder.CLIENT_SPEC) {
            RatConfig.bakeClient();
            LOGGER.debug("Reloading Rats Client Config!");
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        RatsAdvancementsRegistry.init();
        RatsNetworkHandler.init();
        RatsUpgradeConflictRegistry.init();
        event.enqueueWork(() -> {
            RatsCauldronRegistry.init();
            RatsDispenserRegistry.init();
            Raid.RaiderType.create((String)"RATS_PIPER", (EntityType)((EntityType)RatsEntityRegistry.PIED_PIPER.get()), (int[])new int[]{0, 0, 1, 0, 0, 1, 1, 2});
            GiveGiftToHero.f_147550_.put((VillagerProfession)RatsVillagerRegistry.PET_SHOP_OWNER.get(), RatsLootRegistry.PET_SHOP_HOTV);
            CauldronInteraction.f_175607_.put((Item)RatsItemRegistry.PARTY_HAT.get(), CauldronInteraction.f_175615_);
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.f_50276_;
            pot.addPlant(RatlantisBlockRegistry.RATGLOVE_FLOWER.getId(), RatlantisBlockRegistry.POTTED_RATGLOVE_FLOWER);
            pot.addPlant(RatlantisBlockRegistry.PIRAT_SAPLING.getId(), RatlantisBlockRegistry.POTTED_PIRAT_SAPLING);
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)RatsItemRegistry.RAT_NUGGET.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)RatlantisBlockRegistry.PIRAT_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)RatlantisBlockRegistry.PIRAT_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)RatsItemRegistry.CONTAMINATED_FOOD.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)RatlantisBlockRegistry.RATGLOVE_FLOWER.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)RatlantisItemRegistry.RATGLOVE_PETALS.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)RatsItemRegistry.POTATO_PANCAKE.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)RatsItemRegistry.HERB_BUNDLE.get()));
            ComposterBlock.m_51920_((float)1.0f, (ItemLike)((ItemLike)RatsItemRegistry.CONFIT_BYALDI.get()));
            ComposterBlock.m_51920_((float)1.0f, (ItemLike)((ItemLike)RatsItemRegistry.POTATO_KNISHES.get()));
            AxeItem.f_150683_ = Maps.newHashMap((Map)AxeItem.f_150683_);
            AxeItem.f_150683_.put((Block)RatlantisBlockRegistry.PIRAT_LOG.get(), (Block)RatlantisBlockRegistry.STRIPPED_PIRAT_LOG.get());
            AxeItem.f_150683_.put((Block)RatlantisBlockRegistry.PIRAT_WOOD.get(), (Block)RatlantisBlockRegistry.STRIPPED_PIRAT_WOOD.get());
        });
        if (RATLANTIS_ITEMS.isEmpty()) {
            RatlantisItemRegistry.ITEMS.getEntries().forEach(item -> RATLANTIS_ITEMS.add((Item)item.get()));
        }
    }

    public void addPetShops(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_257011_).orElseThrow();
        if (RatConfig.villagePetShops) {
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/plains/houses"), "rats:pet_shops/plains", RatConfig.villagePetShopWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127204_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/snowy/houses"), "rats:pet_shops/snowy", RatConfig.villagePetShopWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127198_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/savanna/houses"), "rats:pet_shops/savanna", RatConfig.villagePetShopWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127198_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/taiga/houses"), "rats:pet_shops/taiga", RatConfig.villagePetShopWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127204_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/desert/houses"), "rats:pet_shops/desert", RatConfig.villagePetShopWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127198_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/plains/zombie/houses"), "rats:pet_shops/zombie_plains", RatConfig.zombieVillagePetShopWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127199_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/snowy/zombie/houses"), "rats:pet_shops/zombie_snowy", RatConfig.zombieVillagePetShopWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127201_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/savanna/zombie/houses"), "rats:pet_shops/zombie_savanna", RatConfig.zombieVillagePetShopWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127200_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/taiga/zombie/houses"), "rats:pet_shops/zombie_taiga", RatConfig.zombieVillagePetShopWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127202_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/desert/zombie/houses"), "rats:pet_shops/zombie_desert", RatConfig.zombieVillagePetShopWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127203_);
        }
        if (RatConfig.villageGarbageHeaps) {
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/plains/houses"), "rats:garbage_heaps/plains", RatConfig.villageGarbageHeapWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127204_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/snowy/houses"), "rats:garbage_heaps/snowy", RatConfig.villageGarbageHeapWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127198_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/savanna/houses"), "rats:garbage_heaps/savanna", RatConfig.villageGarbageHeapWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127198_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/taiga/houses"), "rats:garbage_heaps/taiga", RatConfig.villageGarbageHeapWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127204_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/desert/houses"), "rats:garbage_heaps/desert", RatConfig.villageGarbageHeapWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127198_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/plains/zombie/houses"), "rats:garbage_heaps/plains", RatConfig.zombieVillageGarbageHeapWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127199_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/snowy/zombie/houses"), "rats:garbage_heaps/snowy", RatConfig.zombieVillageGarbageHeapWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127201_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/savanna/zombie/houses"), "rats:garbage_heaps/savanna", RatConfig.zombieVillageGarbageHeapWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127200_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/taiga/zombie/houses"), "rats:garbage_heaps/taiga", RatConfig.zombieVillageGarbageHeapWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127202_);
            this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/desert/zombie/houses"), "rats:garbage_heaps/desert", RatConfig.zombieVillageGarbageHeapWeight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127203_);
        }
    }

    private void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight, ResourceKey<StructureProcessorList> processor) {
        Holder.Reference emptyProcessorList = processorListRegistry.m_246971_(processor);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
        LOGGER.debug("Rats: Successfully added {} to village pool {}", (Object)nbtPieceRL, (Object)poolRL.toString());
    }

    public static List<Pair<String, Component>> getCachedMobList(@Nullable Level level) {
        if (level != null && MOB_CACHE.isEmpty()) {
            ArrayList<Pair> unsortedCache = new ArrayList<Pair>();
            for (Map.Entry entry : ForgeRegistries.ENTITY_TYPES.getEntries()) {
                try {
                    Entity entity = ((EntityType)entry.getValue()).m_20615_(level);
                    if (entry.getValue() != EntityType.f_20532_ && !(entity instanceof Mob)) continue;
                    unsortedCache.add(Pair.of((Object)((ResourceKey)entry.getKey()).m_135782_().toString(), (Object)((EntityType)entry.getValue()).m_20676_()));
                }
                catch (NullPointerException e) {
                    LOGGER.error("Couldnt cache an instance of the mob {}", (Object)((ResourceKey)entry.getKey()).m_135782_(), (Object)e);
                }
            }
            MOB_CACHE.addAll(unsortedCache.stream().sorted(Comparator.comparing(o -> ((Component)o.getSecond()).getString())).toList());
            LOGGER.debug("Cached {} mob ids for later use.", (Object)MOB_CACHE.size());
        }
        return MOB_CACHE;
    }

    static {
        RATLANTIS_DATAPACK_ENABLED = false;
        RATLANTIS_ITEMS = new ArrayList<Item>();
        MOB_CACHE = new ArrayList<Pair<String, Component>>();
    }
}

