/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.events;

import com.github.alexthe666.rats.client.gui.AutoCurdlerScreen;
import com.github.alexthe666.rats.client.gui.CheeseStaffScreen;
import com.github.alexthe666.rats.client.gui.JuryRiggedRatUpgradeScreen;
import com.github.alexthe666.rats.client.gui.MobFilterScreen;
import com.github.alexthe666.rats.client.gui.RatCraftingTableScreen;
import com.github.alexthe666.rats.client.gui.RatScreen;
import com.github.alexthe666.rats.client.gui.RatUpgradeScreen;
import com.github.alexthe666.rats.client.gui.UpgradeCombinerScreen;
import com.github.alexthe666.rats.client.model.CubeModel;
import com.github.alexthe666.rats.client.model.RatsModelLayers;
import com.github.alexthe666.rats.client.model.deco.RatHammockModel;
import com.github.alexthe666.rats.client.model.deco.RatIglooModel;
import com.github.alexthe666.rats.client.model.deco.RatSeedBowlModel;
import com.github.alexthe666.rats.client.model.deco.RatWaterBottleModel;
import com.github.alexthe666.rats.client.model.entity.BlackDeathModel;
import com.github.alexthe666.rats.client.model.entity.PiedPiperModel;
import com.github.alexthe666.rats.client.model.entity.PiratBoatModel;
import com.github.alexthe666.rats.client.model.entity.PlagueDoctorModel;
import com.github.alexthe666.rats.client.model.entity.RatStriderMountModel;
import com.github.alexthe666.rats.client.model.hats.ArcheologistHatModel;
import com.github.alexthe666.rats.client.model.hats.AviatorHatModel;
import com.github.alexthe666.rats.client.model.hats.ChefToqueModel;
import com.github.alexthe666.rats.client.model.hats.CrownModel;
import com.github.alexthe666.rats.client.model.hats.ExterminatorHatModel;
import com.github.alexthe666.rats.client.model.hats.FarmerHatModel;
import com.github.alexthe666.rats.client.model.hats.HaloHatModel;
import com.github.alexthe666.rats.client.model.hats.MilitaryHatModel;
import com.github.alexthe666.rats.client.model.hats.PartyHatModel;
import com.github.alexthe666.rats.client.model.hats.PiperHatModel;
import com.github.alexthe666.rats.client.model.hats.PiratHatModel;
import com.github.alexthe666.rats.client.model.hats.PlagueDoctorMaskModel;
import com.github.alexthe666.rats.client.model.hats.RatFezModel;
import com.github.alexthe666.rats.client.model.hats.RatlantisArmorModel;
import com.github.alexthe666.rats.client.model.hats.SantaHatModel;
import com.github.alexthe666.rats.client.model.hats.TopHatModel;
import com.github.alexthe666.rats.client.particle.BlackDeathParticle;
import com.github.alexthe666.rats.client.particle.DutchratSmokeParticle;
import com.github.alexthe666.rats.client.particle.FleaParticle;
import com.github.alexthe666.rats.client.particle.FlyParticle;
import com.github.alexthe666.rats.client.particle.LightningParticle;
import com.github.alexthe666.rats.client.particle.MilkBubbleParticle;
import com.github.alexthe666.rats.client.particle.PiratGhostParticle;
import com.github.alexthe666.rats.client.particle.RatGhostParticle;
import com.github.alexthe666.rats.client.particle.RatKingSmokeParticle;
import com.github.alexthe666.rats.client.particle.RunningRatParticle;
import com.github.alexthe666.rats.client.particle.SalivaParticle;
import com.github.alexthe666.rats.client.particle.UpgradeCombinerParticle;
import com.github.alexthe666.rats.client.render.NuggetColorRegister;
import com.github.alexthe666.rats.client.render.RatsRenderType;
import com.github.alexthe666.rats.client.render.block.AutoCurdlerRenderer;
import com.github.alexthe666.rats.client.render.block.DecoratedRatCageRenderer;
import com.github.alexthe666.rats.client.render.block.DutchratBellRenderer;
import com.github.alexthe666.rats.client.render.block.PiratHangingSignRenderer;
import com.github.alexthe666.rats.client.render.block.PiratSignRenderer;
import com.github.alexthe666.rats.client.render.block.RatHoleRenderer;
import com.github.alexthe666.rats.client.render.block.RatTrapRenderer;
import com.github.alexthe666.rats.client.render.block.RatlanteanAutomatonHeadRenderer;
import com.github.alexthe666.rats.client.render.block.RatlantisPortalRenderer;
import com.github.alexthe666.rats.client.render.block.RatlantisTokenRenderer;
import com.github.alexthe666.rats.client.render.block.TrashCanRenderer;
import com.github.alexthe666.rats.client.render.block.UpgradeCombinerRenderer;
import com.github.alexthe666.rats.client.render.block.UpgradeSeparatorRenderer;
import com.github.alexthe666.rats.client.render.entity.BlackDeathRenderer;
import com.github.alexthe666.rats.client.render.entity.DemonRatRenderer;
import com.github.alexthe666.rats.client.render.entity.DutchratRenderer;
import com.github.alexthe666.rats.client.render.entity.DutchratSwordRenderer;
import com.github.alexthe666.rats.client.render.entity.FeralRatlanteanRenderer;
import com.github.alexthe666.rats.client.render.entity.GhostPiratRenderer;
import com.github.alexthe666.rats.client.render.entity.GolemBeamRenderer;
import com.github.alexthe666.rats.client.render.entity.LaserBeamRenderer;
import com.github.alexthe666.rats.client.render.entity.LaserPortalRenderer;
import com.github.alexthe666.rats.client.render.entity.NeoRatlanteanRenderer;
import com.github.alexthe666.rats.client.render.entity.NothingRenderer;
import com.github.alexthe666.rats.client.render.entity.PiedPiperRenderer;
import com.github.alexthe666.rats.client.render.entity.PiratBoatRenderer;
import com.github.alexthe666.rats.client.render.entity.PiratRenderer;
import com.github.alexthe666.rats.client.render.entity.PiratWoodBoatRenderer;
import com.github.alexthe666.rats.client.render.entity.PlagueBeastRenderer;
import com.github.alexthe666.rats.client.render.entity.PlagueDoctorRenderer;
import com.github.alexthe666.rats.client.render.entity.PlagueShotRenderer;
import com.github.alexthe666.rats.client.render.entity.RatArrowRenderer;
import com.github.alexthe666.rats.client.render.entity.RatAutomatonMountRenderer;
import com.github.alexthe666.rats.client.render.entity.RatBaronPlaneRenderer;
import com.github.alexthe666.rats.client.render.entity.RatBaronRenderer;
import com.github.alexthe666.rats.client.render.entity.RatBeastMountRenderer;
import com.github.alexthe666.rats.client.render.entity.RatBiplaneMountRenderer;
import com.github.alexthe666.rats.client.render.entity.RatChickenMountRenderer;
import com.github.alexthe666.rats.client.render.entity.RatGolemMountRenderer;
import com.github.alexthe666.rats.client.render.entity.RatKingRenderer;
import com.github.alexthe666.rats.client.render.entity.RatProtectorRenderer;
import com.github.alexthe666.rats.client.render.entity.RatRenderer;
import com.github.alexthe666.rats.client.render.entity.RatShotRenderer;
import com.github.alexthe666.rats.client.render.entity.RatStriderMountRenderer;
import com.github.alexthe666.rats.client.render.entity.RatfishRenderer;
import com.github.alexthe666.rats.client.render.entity.RatlanteanAutomatonRenderer;
import com.github.alexthe666.rats.client.render.entity.RatlanteanRatbotRenderer;
import com.github.alexthe666.rats.client.render.entity.RatlantisArrowRenderer;
import com.github.alexthe666.rats.client.render.entity.RatlateanSpiritRenderer;
import com.github.alexthe666.rats.client.render.entity.RattlingGunBulletRenderer;
import com.github.alexthe666.rats.client.render.entity.RattlingGunRenderer;
import com.github.alexthe666.rats.client.render.entity.SmallArrowRenderer;
import com.github.alexthe666.rats.client.render.entity.TamedRatRenderer;
import com.github.alexthe666.rats.client.render.entity.ThrownBlockRenderer;
import com.github.alexthe666.rats.client.render.entity.layer.PartyHatLayer;
import com.github.alexthe666.rats.client.render.entity.layer.PlagueLayer;
import com.github.alexthe666.rats.registry.RatlantisBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsMenuRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.server.block.entity.RatTubeBlockEntity;
import com.github.alexthe666.rats.server.entity.misc.PiratWoodBoat;
import com.github.alexthe666.rats.server.items.PartyHatItem;
import com.github.alexthe666.rats.server.items.RatHammockItem;
import com.github.alexthe666.rats.server.items.RatIglooItem;
import com.github.alexthe666.rats.server.items.RatSackItem;
import com.github.alexthe666.rats.server.items.RatTubeItem;
import com.github.alexthe666.rats.server.items.upgrades.DemonRatUpgradeItem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="rats", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModClientEvents {
    private static ShaderInstance rendertypeRatlantisPortalShader;
    private static Field field_EntityRenderersEvent$AddLayers_renderers;

    public static boolean shouldRenderNameplates() {
        return Minecraft.m_91087_().f_91080_ == null || !(Minecraft.m_91087_().f_91080_ instanceof RatScreen) && !(Minecraft.m_91087_().f_91080_ instanceof CheeseStaffScreen);
    }

    @Nullable
    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static void openMobFilterScreen(ItemStack upgrade) {
        Minecraft.m_91087_().m_91152_((Screen)new MobFilterScreen(upgrade));
    }

    @SubscribeEvent
    public static void setupShaders(RegisterShadersEvent event) throws IOException {
        ResourceProvider provider = event.getResourceProvider();
        event.registerShader(new ShaderInstance(provider, new ResourceLocation("rats", "rendertype_ratlantis_portal"), DefaultVertexFormat.f_85815_), instance -> {
            rendertypeRatlantisPortalShader = instance;
        });
    }

    public static ShaderInstance getRendertypeRatlantisPortalShader() {
        return rendertypeRatlantisPortalShader;
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)RatsItemRegistry.RAT_SACK.get()), (ResourceLocation)new ResourceLocation("rat_count"), (stack, level, entity, i) -> Math.min(3, RatSackItem.getRatsInSack(stack)));
            ItemProperties.register((Item)((Item)RatlantisItemRegistry.RATLANTIS_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, level, living, i) -> {
                if (living == null) {
                    return 0.0f;
                }
                return living.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - living.m_21212_()) / 10.0f;
            });
            ItemProperties.register((Item)((Item)RatlantisItemRegistry.RATLANTIS_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (stack, level, living, i) -> living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)RatsItemRegistry.RATBOW_ESSENCE.get()), (ResourceLocation)new ResourceLocation("rats", "special"), (stack, level, entity, i) -> {
                if (stack.m_41788_()) {
                    RatsRenderType.GlintType type = RatsRenderType.GlintType.getGlintBasedOnKeyword(stack.m_41786_().getString());
                    return type != null && type.changesItemTexture() ? (float)(type.ordinal() + 1) : 0.0f;
                }
                return 0.0f;
            });
            ItemProperties.register((Item)((Item)RatsItemRegistry.RAT_UPGRADE_DEMON.get()), (ResourceLocation)new ResourceLocation("rats", "soul"), (stack, level, living, i) -> DemonRatUpgradeItem.isSoulVersion(stack) ? 1.0f : 0.0f);
        });
        MenuScreens.m_96206_((MenuType)((MenuType)RatsMenuRegistry.RAT_CRAFTING_TABLE_CONTAINER.get()), RatCraftingTableScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RatsMenuRegistry.RAT_UPGRADE_CONTAINER.get()), RatUpgradeScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RatsMenuRegistry.RAT_UPGRADE_JR_CONTAINER.get()), JuryRiggedRatUpgradeScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RatsMenuRegistry.UPGRADE_COMBINER_CONTAINER.get()), UpgradeCombinerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RatsMenuRegistry.AUTO_CURDLER_CONTAINER.get()), AutoCurdlerScreen::new);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (PiratWoodBoat.Type boatType : PiratWoodBoat.Type.values()) {
            event.registerLayerDefinition(PiratWoodBoatRenderer.createBoatModelName(boatType), BoatModel::m_246613_);
            event.registerLayerDefinition(PiratWoodBoatRenderer.createChestBoatModelName(boatType), ChestBoatModel::m_247175_);
        }
        event.registerLayerDefinition(RatsModelLayers.BLACK_DEATH, BlackDeathModel::create);
        event.registerLayerDefinition(RatsModelLayers.PIPER, PiedPiperModel::create);
        event.registerLayerDefinition(RatsModelLayers.PIRAT_BOAT, PiratBoatModel::create);
        event.registerLayerDefinition(RatsModelLayers.PLAGUE_DOCTOR, PlagueDoctorModel::create);
        event.registerLayerDefinition(RatsModelLayers.RAT_STRIDER_MOUNT, RatStriderMountModel::create);
        event.registerLayerDefinition(RatsModelLayers.THROWN_BLOCK, CubeModel::create);
        event.registerLayerDefinition(RatsModelLayers.HAMMOCK, RatHammockModel::create);
        event.registerLayerDefinition(RatsModelLayers.IGLOO, RatIglooModel::create);
        event.registerLayerDefinition(RatsModelLayers.SEED_BOWL, RatSeedBowlModel::create);
        event.registerLayerDefinition(RatsModelLayers.WATER_BOTTLE, RatWaterBottleModel::create);
        event.registerLayerDefinition(RatsModelLayers.CHEF_TOQUE, ChefToqueModel::create);
        event.registerLayerDefinition(RatsModelLayers.PIPER_HAT, PiperHatModel::create);
        event.registerLayerDefinition(RatsModelLayers.ARCHEOLOGIST_HAT, ArcheologistHatModel::create);
        event.registerLayerDefinition(RatsModelLayers.FARMER_HAT, FarmerHatModel::create);
        event.registerLayerDefinition(RatsModelLayers.FEZ, RatFezModel::create);
        event.registerLayerDefinition(RatsModelLayers.TOP_HAT, TopHatModel::create);
        event.registerLayerDefinition(RatsModelLayers.SANTA_HAT, SantaHatModel::create);
        event.registerLayerDefinition(RatsModelLayers.HALO, HaloHatModel::create);
        event.registerLayerDefinition(RatsModelLayers.PARTY_HAT, PartyHatModel::create);
        event.registerLayerDefinition(RatsModelLayers.PIRATE_HAT, PiratHatModel::create);
        event.registerLayerDefinition(RatsModelLayers.CROWN, CrownModel::create);
        event.registerLayerDefinition(RatsModelLayers.PLAGUE_DOCTOR_MASK, PlagueDoctorMaskModel::create);
        event.registerLayerDefinition(RatsModelLayers.EXTERMINATOR_HAT, ExterminatorHatModel::create);
        event.registerLayerDefinition(RatsModelLayers.AVIATOR_HAT, AviatorHatModel::create);
        event.registerLayerDefinition(RatsModelLayers.OFFICER_HAT, MilitaryHatModel::create);
        event.registerLayerDefinition(RatsModelLayers.RATLANTIS_ARMOR_OUTER, () -> RatlantisArmorModel.create(LayerDefinitions.f_171106_));
        event.registerLayerDefinition(RatsModelLayers.RATLANTIS_ARMOR_INNER, () -> RatlantisArmorModel.create(LayerDefinitions.f_171107_));
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.RAT.get(), RatRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.TAMED_RAT.get(), TamedRatRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.PIED_PIPER.get(), PiedPiperRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.THROWN_BLOCK.get(), ThrownBlockRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.PLAGUE_DOCTOR.get(), PlagueDoctorRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.PURIFYING_LIQUID.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.BLACK_DEATH.get(), BlackDeathRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.PLAGUE_CLOUD.get(), context -> new RatlateanSpiritRenderer(context, true));
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.PLAGUE_BEAST.get(), PlagueBeastRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.PLAGUE_SHOT.get(), PlagueShotRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.RAT_CAPTURE_NET.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.RAT_DRAGON_FIRE.get(), NothingRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.RAT_ARROW.get(), RatArrowRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.RAT_MOUNT_GOLEM.get(), RatGolemMountRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.RAT_MOUNT_CHICKEN.get(), RatChickenMountRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.RAT_MOUNT_BEAST.get(), RatBeastMountRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.RAT_KING.get(), RatKingRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.RAT_SHOT.get(), RatShotRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.DEMON_RAT.get(), DemonRatRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.RAT_STRIDER_MOUNT.get(), RatStriderMountRenderer::new);
        event.registerEntityRenderer((EntityType)RatsEntityRegistry.SMALL_ARROW.get(), SmallArrowRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatsBlockEntityRegistry.RAT_HOLE.get(), RatHoleRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatsBlockEntityRegistry.RAT_TRAP.get(), RatTrapRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatsBlockEntityRegistry.AUTO_CURDLER.get(), AutoCurdlerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatsBlockEntityRegistry.RAT_CAGE_DECORATED.get(), DecoratedRatCageRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatsBlockEntityRegistry.RAT_CAGE_BREEDING_LANTERN.get(), DecoratedRatCageRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatsBlockEntityRegistry.RAT_CAGE_WHEEL.get(), DecoratedRatCageRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatsBlockEntityRegistry.UPGRADE_COMBINER.get(), UpgradeCombinerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatsBlockEntityRegistry.UPGRADE_SEPERATOR.get(), UpgradeSeparatorRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatsBlockEntityRegistry.TRASH_CAN.get(), TrashCanRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.DUTCHRAT.get(), DutchratRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.DUTCHRAT_SWORD.get(), DutchratSwordRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RATFISH.get(), RatfishRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RATTLING_GUN.get(), RattlingGunRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RATTLING_GUN_BULLET.get(), RattlingGunBulletRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RATLANTEAN_RATBOT.get(), RatlanteanRatbotRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.PIRAT.get(), PiratRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RAT_MOUNT_AUTOMATON.get(), RatAutomatonMountRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.GHOST_PIRAT.get(), GhostPiratRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RAT_BARON.get(), RatBaronRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RAT_BARON_PLANE.get(), RatBaronPlaneRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RAT_MOUNT_BIPLANE.get(), RatBiplaneMountRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RAT_PROTECTOR.get(), RatProtectorRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RATLANTIS_ARROW.get(), RatlantisArrowRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RATLANTEAN_SPIRIT.get(), context -> new RatlateanSpiritRenderer(context, false));
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RATLANTEAN_FLAME.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RATLANTEAN_AUTOMATON.get(), RatlanteanAutomatonRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.RATLANTEAN_AUTOMATON_BEAM.get(), GolemBeamRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.FERAL_RATLANTEAN.get(), FeralRatlanteanRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.NEO_RATLANTEAN.get(), NeoRatlanteanRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.LASER_BEAM.get(), LaserBeamRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.LASER_PORTAL.get(), LaserPortalRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.VIAL_OF_SENTIENCE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.PIRAT_BOAT.get(), context -> new PiratBoatRenderer(context, new PiratBoatModel(context.m_174023_(RatsModelLayers.PIRAT_BOAT))));
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.CHEESE_CANNONBALL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.BOAT.get(), context -> new PiratWoodBoatRenderer(context, false));
        event.registerEntityRenderer((EntityType)RatlantisEntityRegistry.CHEST_BOAT.get(), context -> new PiratWoodBoatRenderer(context, true));
        event.registerBlockEntityRenderer((BlockEntityType)RatlantisBlockEntityRegistry.RATLANTIS_PORTAL.get(), RatlantisPortalRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatlantisBlockEntityRegistry.DUTCHRAT_BELL.get(), DutchratBellRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatlantisBlockEntityRegistry.AUTOMATON_HEAD.get(), RatlanteanAutomatonHeadRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatlantisBlockEntityRegistry.TOKEN.get(), RatlantisTokenRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatlantisBlockEntityRegistry.PIRAT_SIGN.get(), PiratSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RatlantisBlockEntityRegistry.PIRAT_HANGING_SIGN.get(), PiratHangingSignRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)RatsParticleRegistry.BLACK_DEATH.get(), BlackDeathParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RatsParticleRegistry.DUTCHRAT_SMOKE.get(), DutchratSmokeParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RatsParticleRegistry.FLEA.get(), FleaParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RatsParticleRegistry.FLY.get(), FlyParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RatsParticleRegistry.LIGHTNING.get(), LightningParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RatsParticleRegistry.MILK_BUBBLE.get(), MilkBubbleParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RatsParticleRegistry.PIRAT_GHOST.get(), PiratGhostParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RatsParticleRegistry.RAT_GHOST.get(), RatGhostParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RatsParticleRegistry.RAT_KING_SMOKE.get(), RatKingSmokeParticle.Provider::new);
        event.registerSpecial((ParticleType)RatsParticleRegistry.RUNNING_RAT.get(), (ParticleProvider)new RunningRatParticle.Provider());
        event.registerSpriteSet((ParticleType)RatsParticleRegistry.SALIVA.get(), SalivaParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RatsParticleRegistry.UPGRADE_COMBINER.get(), UpgradeCombinerParticle.Provider::new);
    }

    @SubscribeEvent
    public static void onBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tint) -> {
            BlockEntity patt18124$temp;
            int meta = 0;
            if (level != null && pos != null && (patt18124$temp = level.m_7702_(pos)) instanceof RatTubeBlockEntity) {
                RatTubeBlockEntity tube = (RatTubeBlockEntity)patt18124$temp;
                meta = tube.getColor();
            }
            DyeColor color = DyeColor.m_41053_((int)meta);
            return color.m_41070_();
        }, new Block[]{(Block)RatsBlockRegistry.RAT_TUBE_COLOR.get()});
        event.register((state, level, pos, tint) -> level != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.m_46107_((double)0.5, (double)1.0), new Block[]{(Block)RatlantisBlockRegistry.MARBLED_CHEESE_GRASS.get()});
    }

    @SubscribeEvent
    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tint) -> FoliageColor.m_46107_((double)0.5, (double)1.0), new ItemLike[]{((Block)RatlantisBlockRegistry.MARBLED_CHEESE_GRASS.get()).m_5456_()});
        for (RegistryObject<Item> item : RatsItemRegistry.RAT_TUBES) {
            event.register((stack, tint) -> ((RatTubeItem)((Object)((Object)item.get()))).color.m_41070_(), new ItemLike[]{(ItemLike)item.get()});
        }
        for (RegistryObject<Item> item : RatsItemRegistry.RAT_IGLOOS) {
            event.register((stack, tint) -> ((RatIglooItem)item.get()).color.m_41070_(), new ItemLike[]{(ItemLike)item.get()});
        }
        for (RegistryObject<Item> item : RatsItemRegistry.RAT_HAMMOCKS) {
            event.register((stack, tint) -> ((RatHammockItem)item.get()).color.m_41070_(), new ItemLike[]{(ItemLike)item.get()});
        }
        event.register((stack, tint) -> {
            if (tint == 1) {
                return NuggetColorRegister.getNuggetColor(stack);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)RatsItemRegistry.RAT_NUGGET_ORE.get()});
        event.register((stack, tintIndex) -> {
            int colorToUse;
            if (tintIndex == 0) {
                int n;
                Item patt19614$temp = stack.m_41720_();
                if (patt19614$temp instanceof PartyHatItem) {
                    PartyHatItem hat = (PartyHatItem)patt19614$temp;
                    n = hat.m_41121_(stack);
                } else {
                    n = 2476519;
                }
                colorToUse = n;
            } else {
                int n;
                Item patt19745$temp = stack.m_41720_();
                if (patt19745$temp instanceof PartyHatItem) {
                    PartyHatItem hat = (PartyHatItem)patt19745$temp;
                    n = ModClientEvents.invertColor(hat.m_41121_(stack));
                } else {
                    n = ModClientEvents.invertColor(2476519);
                }
                colorToUse = n;
            }
            return colorToUse;
        }, new ItemLike[]{(ItemLike)RatsItemRegistry.PARTY_HAT.get()});
    }

    private static int invertColor(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = 255 - r;
        g = 255 - g;
        b = 255 - b;
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    @SubscribeEvent
    public static void attachRenderLayers(EntityRenderersEvent.AddLayers event) {
        if (field_EntityRenderersEvent$AddLayers_renderers == null) {
            try {
                field_EntityRenderersEvent$AddLayers_renderers = EntityRenderersEvent.AddLayers.class.getDeclaredField("renderers");
                field_EntityRenderersEvent$AddLayers_renderers.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (field_EntityRenderersEvent$AddLayers_renderers != null) {
            event.getSkins().forEach(renderer -> {
                LivingEntityRenderer skin = event.getSkin(renderer);
                ModClientEvents.attachRenderLayers(Objects.requireNonNull(skin));
            });
            try {
                ((Map)field_EntityRenderersEvent$AddLayers_renderers.get(event)).values().stream().filter(LivingEntityRenderer.class::isInstance).map(LivingEntityRenderer.class::cast).forEach(ModClientEvents::attachRenderLayers);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static <T extends LivingEntity, M extends EntityModel<T>> void attachRenderLayers(LivingEntityRenderer<T, M> renderer) {
        renderer.m_115326_(new PlagueLayer<T, M>(renderer));
        if (renderer.m_7200_() instanceof HumanoidModel) {
            renderer.m_115326_(new PartyHatLayer<T, M, HumanoidModel>(renderer, new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171165_))));
        }
    }
}

