/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.model.deco;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe666.rats.server.block.entity.RatCageWheelBlockEntity;
import com.google.common.collect.ImmutableList;
import net.minecraft.world.entity.Entity;

public class RatWheelModel<T extends Entity>
extends AdvancedEntityModel<T> {
    public final AdvancedModelBox axle;
    public final AdvancedModelBox groundBaseL;
    public final AdvancedModelBox groundBaseR;
    public final AdvancedModelBox wheel1;
    public final AdvancedModelBox wheel2;

    public RatWheelModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.wheel2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 24);
        this.wheel2.setPos(0.0f, 4.5f, -5.0f);
        this.wheel2.addBox(-5.5f, 0.0f, -7.0f, 11.0f, 10.0f, 14.0f, 0.0f);
        this.setRotateAngle(this.wheel2, 1.5707964f, 0.0f, 0.0f);
        this.groundBaseL = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.groundBaseL.mirror = true;
        this.groundBaseL.setPos(0.0f, 20.5f, 0.0f);
        this.groundBaseL.addBox(6.5f, -5.5f, -1.5f, 1.0f, 8.0f, 3.0f, 0.0f);
        this.wheel1 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.wheel1.setPos(0.0f, -4.5f, 0.0f);
        this.wheel1.addBox(-5.5f, 0.0f, -7.0f, 11.0f, 10.0f, 14.0f, 0.0f);
        this.axle = new AdvancedModelBox((AdvancedEntityModel)this, 0, 50);
        this.axle.setPos(0.0f, 15.0f, 0.0f);
        this.axle.addBox(-8.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, 0.0f);
        this.groundBaseR = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.groundBaseR.setPos(0.0f, 20.5f, 0.0f);
        this.groundBaseR.addBox(-7.5f, -5.5f, -1.5f, 1.0f, 8.0f, 3.0f, 0.0f);
        this.wheel1.addChild((BasicModelPart)this.wheel2);
        this.axle.addChild((BasicModelPart)this.wheel1);
        this.updateDefaultPose();
    }

    public void animate(RatCageWheelBlockEntity wheel, float partialTicks) {
        this.resetToDefaultPose();
        float rot = wheel.prevWheelRot + (wheel.wheelRot - wheel.prevWheelRot) * partialTicks;
        this.axle.rotateAngleX = (float)Math.toRadians(rot);
        this.wheel1.setScale(0.9f, 0.9f, 0.9f);
        this.wheel1.setShouldScaleChildren(true);
    }

    public void m_6973_(T t, float v, float v1, float v2, float v3, float v4) {
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.axle, (Object)this.groundBaseL, (Object)this.groundBaseR);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.axle, (Object)this.groundBaseL, (Object)this.groundBaseR, (Object)this.wheel1, (Object)this.wheel2);
    }

    public void setRotateAngle(AdvancedModelBox box, float x, float y, float z) {
        box.rotateAngleX = x;
        box.rotateAngleY = y;
        box.rotateAngleZ = z;
    }
}

