/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.model.entity;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe666.rats.server.entity.monster.FeralRatlantean;
import com.google.common.collect.ImmutableList;
import net.minecraft.world.entity.Mob;

public class FeralRatlanteanModel<T extends Mob>
extends AdvancedEntityModel<T> {
    public final AdvancedModelBox lowerbody;
    public final AdvancedModelBox midBody;
    public final AdvancedModelBox backLeftThigh;
    public final AdvancedModelBox backRightThigh;
    public final AdvancedModelBox tail1;
    public final AdvancedModelBox tatters3;
    public final AdvancedModelBox frontBody;
    public final AdvancedModelBox tatters1;
    public final AdvancedModelBox tatters2;
    public final AdvancedModelBox frontRightLeg;
    public final AdvancedModelBox frontLeftLeg;
    public final AdvancedModelBox neck;
    public final AdvancedModelBox frontRightHeel;
    public final AdvancedModelBox frontRightFoot;
    public final AdvancedModelBox frontLeftHeel;
    public final AdvancedModelBox frontLeftFoot;
    public final AdvancedModelBox head1;
    public final AdvancedModelBox tatters4;
    public final AdvancedModelBox snoutUpper;
    public final AdvancedModelBox mouth1;
    public final AdvancedModelBox ear1;
    public final AdvancedModelBox ear2;
    public final AdvancedModelBox nose;
    public final AdvancedModelBox teeth;
    public final AdvancedModelBox wisker1;
    public final AdvancedModelBox wisker2;
    public final AdvancedModelBox backLeftLeg;
    public final AdvancedModelBox backLeftHeel;
    public final AdvancedModelBox backLeftFoot;
    public final AdvancedModelBox backRightLeg;
    public final AdvancedModelBox backRightHeel;
    public final AdvancedModelBox backRightFoot;
    public final AdvancedModelBox tail2;
    public final AdvancedModelBox tail3;
    public final AdvancedModelBox tail4;
    public final ModelAnimator animator;

    public FeralRatlanteanModel() {
        this.texWidth = 128;
        this.texHeight = 64;
        this.tail2 = new AdvancedModelBox((AdvancedEntityModel)this, "tail2");
        this.tail2.setTextureOffset(15, 50);
        this.tail2.setRotationPoint(0.0f, 0.1f, 7.5f);
        this.tail2.addBox(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 8.0f, 0.0f);
        this.setRotateAngle(this.tail2, 0.2617994f, 0.0f, 0.0f);
        this.frontLeftHeel = new AdvancedModelBox((AdvancedEntityModel)this, "front_left_heel");
        this.frontLeftHeel.setTextureOffset(34, 0);
        this.frontLeftHeel.setRotationPoint(1.0f, 4.7f, 1.0f);
        this.frontLeftHeel.addBox(-0.5f, 0.0f, -2.0f, 1.0f, 6.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.frontLeftHeel, -0.9599311f, 0.0f, 0.0f);
        this.frontRightHeel = new AdvancedModelBox((AdvancedEntityModel)this, "front_right_heel");
        this.frontRightHeel.setTextureOffset(34, 0);
        this.frontRightHeel.setRotationPoint(-1.0f, 4.7f, 1.0f);
        this.frontRightHeel.addBox(-0.5f, 0.0f, -2.0f, 1.0f, 6.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.frontRightHeel, -0.9599311f, 0.0f, 0.0f);
        this.nose = new AdvancedModelBox((AdvancedEntityModel)this, "nose");
        this.nose.setTextureOffset(36, 27);
        this.nose.setRotationPoint(0.0f, 0.5f, -4.0f);
        this.nose.addBox(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.nose, 0.31869712f, 0.0f, 0.0f);
        this.teeth = new AdvancedModelBox((AdvancedEntityModel)this, "teeth");
        this.teeth.setTextureOffset(24, 43);
        this.teeth.setRotationPoint(0.0f, 3.0f, 0.0f);
        this.teeth.addBox(-2.0f, -0.1f, -5.0f, 4.0f, 2.0f, 5.0f, 0.0f);
        this.tail4 = new AdvancedModelBox((AdvancedEntityModel)this, "tail4");
        this.tail4.setTextureOffset(0, 53);
        this.tail4.setRotationPoint(0.0f, 0.0f, 7.5f);
        this.tail4.addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 8.0f, 0.0f);
        this.setRotateAngle(this.tail4, 0.2617994f, 0.0f, 0.0f);
        this.lowerbody = new AdvancedModelBox((AdvancedEntityModel)this, "lower_body");
        this.lowerbody.setTextureOffset(0, 0);
        this.lowerbody.setRotationPoint(0.0f, 12.3f, 4.0f);
        this.lowerbody.addBox(-3.5f, -4.0f, -1.0f, 7.0f, 8.0f, 10.0f, 0.0f);
        this.setRotateAngle(this.lowerbody, -0.08726646f, 0.0f, 0.0f);
        this.tatters4 = new AdvancedModelBox((AdvancedEntityModel)this, "tatters4");
        this.tatters4.setTextureOffset(89, 0);
        this.tatters4.setRotationPoint(-2.0f, -1.0f, -1.0f);
        this.tatters4.addBox(0.0f, 0.0f, -3.0f, 0.0f, 9.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.tatters4, 0.0f, 0.0f, 0.2617994f);
        this.frontBody = new AdvancedModelBox((AdvancedEntityModel)this, "front_body");
        this.frontBody.setTextureOffset(15, 27);
        this.frontBody.setRotationPoint(0.0f, 0.0f, -6.0f);
        this.frontBody.addBox(-3.5f, -3.5f, -7.0f, 7.0f, 7.0f, 7.0f, 0.0f);
        this.setRotateAngle(this.frontBody, 0.2617994f, 0.0f, 0.0f);
        this.frontLeftFoot = new AdvancedModelBox((AdvancedEntityModel)this, "front_left_foot");
        this.frontLeftFoot.setTextureOffset(0, 29);
        this.frontLeftFoot.setRotationPoint(0.0f, 5.1f, -0.7f);
        this.frontLeftFoot.addBox(-1.0f, 0.0f, -5.0f, 2.0f, 1.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.frontLeftFoot, 0.08726646f, 0.0f, 0.0f);
        this.mouth1 = new AdvancedModelBox((AdvancedEntityModel)this, "mouth1");
        this.mouth1.setTextureOffset(13, 41);
        this.mouth1.setRotationPoint(0.0f, 1.5f, -5.0f);
        this.mouth1.addBox(-1.5f, 0.0f, -5.7f, 3.0f, 1.0f, 5.0f, 0.0f);
        this.backLeftHeel = new AdvancedModelBox((AdvancedEntityModel)this, "back_left_heel");
        this.backLeftHeel.setTextureOffset(0, 44);
        this.backLeftHeel.setRotationPoint(0.0f, 6.0f, 0.2f);
        this.backLeftHeel.addBox(-0.5f, 0.0f, -2.0f, 1.0f, 6.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.backLeftHeel, -2.0071287f, 0.0f, 0.0f);
        this.backRightFoot = new AdvancedModelBox((AdvancedEntityModel)this, "back_right_foot");
        this.backRightFoot.setTextureOffset(1, 47);
        this.backRightFoot.setRotationPoint(0.0f, 5.1f, -0.7f);
        this.backRightFoot.addBox(-1.0f, 0.0f, -5.0f, 2.0f, 1.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.backRightFoot, 0.61086524f, 0.0f, 0.0f);
        this.tail3 = new AdvancedModelBox((AdvancedEntityModel)this, "tail3");
        this.tail3.setTextureOffset(0, 53);
        this.tail3.setRotationPoint(0.0f, 0.0f, 7.5f);
        this.tail3.addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 8.0f, 0.0f);
        this.setRotateAngle(this.tail3, 0.2617994f, 0.0f, 0.0f);
        this.tatters3 = new AdvancedModelBox((AdvancedEntityModel)this, "tatters3");
        this.tatters3.setTextureOffset(102, 0);
        this.tatters3.setRotationPoint(3.5f, -4.0f, 7.0f);
        this.tatters3.addBox(0.0f, 0.0f, -3.0f, 0.0f, 9.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.tatters3, 0.0f, 0.0f, -0.91053826f);
        this.backLeftThigh = new AdvancedModelBox((AdvancedEntityModel)this, "back_left_thigh");
        this.backLeftThigh.setTextureOffset(30, 15);
        this.backLeftThigh.setRotationPoint(3.5f, 0.0f, 5.0f);
        this.backLeftThigh.addBox(0.0f, -1.0f, -2.0f, 3.0f, 8.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.backLeftThigh, -0.7853982f, 0.0f, 0.0f);
        this.ear1 = new AdvancedModelBox((AdvancedEntityModel)this, "left_ear");
        this.ear1.setTextureOffset(71, -3);
        this.ear1.setRotationPoint(2.5f, -2.0f, -2.0f);
        this.ear1.addBox(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.ear1, 0.7853982f, 0.7853982f, 0.0f);
        this.frontRightFoot = new AdvancedModelBox((AdvancedEntityModel)this, "front_left_foot");
        this.frontRightFoot.setTextureOffset(0, 29);
        this.frontRightFoot.setRotationPoint(0.0f, 5.1f, -0.7f);
        this.frontRightFoot.addBox(-1.0f, 0.0f, -5.0f, 2.0f, 1.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.frontRightFoot, 0.08726646f, 0.0f, 0.0f);
        this.tatters2 = new AdvancedModelBox((AdvancedEntityModel)this, "tatters2");
        this.tatters2.setTextureOffset(76, 0);
        this.tatters2.setRotationPoint(-3.0f, -3.0f, -6.0f);
        this.tatters2.addBox(0.0f, 0.0f, -3.0f, 0.0f, 8.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.tatters2, 0.0f, 0.0f, 0.5235988f);
        this.frontLeftLeg = new AdvancedModelBox((AdvancedEntityModel)this, "front_left_leg");
        this.frontLeftLeg.setTextureOffset(0, 0);
        this.frontLeftLeg.setRotationPoint(3.5f, 2.0f, -4.0f);
        this.frontLeftLeg.addBox(0.0f, -1.0f, -1.5f, 2.0f, 6.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.frontLeftLeg, 0.5235988f, 0.0f, 0.0f);
        this.neck = new AdvancedModelBox((AdvancedEntityModel)this, "neck");
        this.neck.setTextureOffset(43, 27);
        this.neck.setRotationPoint(0.0f, -0.5f, -7.0f);
        this.neck.addBox(-2.0f, -2.5f, -4.0f, 4.0f, 5.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.neck, -0.2617994f, 0.0f, 0.0f);
        this.tail1 = new AdvancedModelBox((AdvancedEntityModel)this, "tail1");
        this.tail1.setTextureOffset(0, 18);
        this.tail1.setRotationPoint(0.0f, -1.0f, 8.0f);
        this.tail1.addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 8.0f, 0.0f);
        this.setRotateAngle(this.tail1, -0.6981317f, 0.0f, 0.0f);
        this.frontRightLeg = new AdvancedModelBox((AdvancedEntityModel)this, "front_left_leg");
        this.frontLeftLeg.setTextureOffset(0, 0);
        this.frontRightLeg.setRotationPoint(-3.5f, 2.0f, -4.0f);
        this.frontRightLeg.addBox(-2.0f, -1.0f, -1.5f, 2.0f, 6.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.frontRightLeg, 0.5235988f, 0.0f, 0.0f);
        this.midBody = new AdvancedModelBox((AdvancedEntityModel)this, "mid_body");
        this.midBody.setTextureOffset(34, 0);
        this.midBody.setRotationPoint(0.0f, 0.0f, -1.0f);
        this.midBody.addBox(-3.0f, -3.0f, -7.0f, 6.0f, 7.0f, 8.0f, 0.0f);
        this.setRotateAngle(this.midBody, 0.17453292f, 0.0f, 0.0f);
        this.snoutUpper = new AdvancedModelBox((AdvancedEntityModel)this, "snout_upper");
        this.snoutUpper.setTextureOffset(0, 36);
        this.snoutUpper.setRotationPoint(0.0f, -1.3f, -6.0f);
        this.snoutUpper.addBox(-2.0f, 0.0f, -5.0f, 4.0f, 3.0f, 5.0f, 0.0f);
        this.ear2 = new AdvancedModelBox((AdvancedEntityModel)this, "right_ear");
        this.ear2.setTextureOffset(71, -3);
        this.ear2.setRotationPoint(-2.5f, -2.0f, -2.0f);
        this.ear2.addBox(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.ear2, 0.7853982f, -0.7853982f, 0.0f);
        this.wisker1 = new AdvancedModelBox((AdvancedEntityModel)this, "whisker1");
        this.wisker1.setTextureOffset(63, 0);
        this.wisker1.mirror = true;
        this.wisker1.setRotationPoint(2.0f, 1.0f, -4.0f);
        this.wisker1.addBox(0.0f, -2.0f, 0.0f, 4.0f, 4.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.wisker1, 0.0f, -0.87266463f, 0.0f);
        this.backLeftFoot = new AdvancedModelBox((AdvancedEntityModel)this, "back_left_foot");
        this.backLeftFoot.setTextureOffset(1, 47);
        this.backLeftFoot.mirror = true;
        this.backLeftFoot.setRotationPoint(0.0f, 5.1f, -0.7f);
        this.backLeftFoot.addBox(-1.0f, 0.0f, -5.0f, 2.0f, 1.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.backLeftFoot, 0.61086524f, 0.0f, 0.0f);
        this.backLeftLeg = new AdvancedModelBox((AdvancedEntityModel)this, "back_left_leg");
        this.backLeftLeg.setTextureOffset(0, 18);
        this.backLeftLeg.setRotationPoint(1.2f, 7.0f, 1.5f);
        this.backLeftLeg.addBox(-1.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.backLeftLeg, 2.268928f, 0.0f, 0.0f);
        this.tatters1 = new AdvancedModelBox((AdvancedEntityModel)this, "tatters1");
        this.tatters1.setTextureOffset(63, 0);
        this.tatters1.setRotationPoint(3.0f, -1.0f, -3.0f);
        this.tatters1.addBox(0.0f, 0.0f, -3.0f, 0.0f, 9.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.tatters1, 0.0f, 0.0f, -0.2617994f);
        this.head1 = new AdvancedModelBox((AdvancedEntityModel)this, "head");
        this.head1.setTextureOffset(37, 37);
        this.head1.setRotationPoint(0.0f, 0.0f, -2.5f);
        this.head1.addBox(-3.0f, -2.5f, -6.0f, 6.0f, 5.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.head1, -0.08726646f, 0.0f, 0.0f);
        this.backRightThigh = new AdvancedModelBox((AdvancedEntityModel)this, "back_right_thigh");
        this.backRightThigh.setTextureOffset(30, 15);
        this.backRightThigh.setRotationPoint(-3.5f, 0.0f, 5.0f);
        this.backRightThigh.addBox(-3.0f, -1.0f, -2.0f, 3.0f, 8.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.backRightThigh, -0.7853982f, 0.0f, 0.0f);
        this.backRightHeel = new AdvancedModelBox((AdvancedEntityModel)this, "back_right_heel");
        this.backRightHeel.setTextureOffset(0, 44);
        this.backRightHeel.setRotationPoint(0.0f, 6.0f, 0.2f);
        this.backRightHeel.addBox(-0.5f, 0.0f, -2.0f, 1.0f, 6.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.backRightHeel, -2.0071287f, 0.0f, 0.0f);
        this.wisker2 = new AdvancedModelBox((AdvancedEntityModel)this, "whisker2");
        this.wisker2.setTextureOffset(63, 0);
        this.wisker2.setRotationPoint(-2.0f, 1.0f, -4.0f);
        this.wisker2.addBox(-4.0f, -2.0f, 0.0f, 4.0f, 4.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.wisker2, 0.0f, 0.87266463f, 0.0f);
        this.backRightLeg = new AdvancedModelBox((AdvancedEntityModel)this, "back_right_leg");
        this.backRightLeg.setTextureOffset(0, 18);
        this.backRightLeg.setRotationPoint(-1.2f, 7.0f, 1.5f);
        this.backRightLeg.addBox(-1.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.backRightLeg, 2.268928f, 0.0f, 0.0f);
        this.tail1.addChild((BasicModelPart)this.tail2);
        this.frontLeftLeg.addChild((BasicModelPart)this.frontLeftHeel);
        this.frontRightLeg.addChild((BasicModelPart)this.frontRightHeel);
        this.snoutUpper.addChild((BasicModelPart)this.nose);
        this.snoutUpper.addChild((BasicModelPart)this.teeth);
        this.tail3.addChild((BasicModelPart)this.tail4);
        this.neck.addChild((BasicModelPart)this.tatters4);
        this.midBody.addChild((BasicModelPart)this.frontBody);
        this.frontLeftHeel.addChild((BasicModelPart)this.frontLeftFoot);
        this.head1.addChild((BasicModelPart)this.mouth1);
        this.backLeftLeg.addChild((BasicModelPart)this.backLeftHeel);
        this.backRightHeel.addChild((BasicModelPart)this.backRightFoot);
        this.tail2.addChild((BasicModelPart)this.tail3);
        this.lowerbody.addChild((BasicModelPart)this.tatters3);
        this.lowerbody.addChild((BasicModelPart)this.backLeftThigh);
        this.head1.addChild((BasicModelPart)this.ear1);
        this.frontRightHeel.addChild((BasicModelPart)this.frontRightFoot);
        this.midBody.addChild((BasicModelPart)this.tatters2);
        this.frontBody.addChild((BasicModelPart)this.frontLeftLeg);
        this.frontBody.addChild((BasicModelPart)this.neck);
        this.lowerbody.addChild((BasicModelPart)this.tail1);
        this.frontBody.addChild((BasicModelPart)this.frontRightLeg);
        this.lowerbody.addChild((BasicModelPart)this.midBody);
        this.head1.addChild((BasicModelPart)this.snoutUpper);
        this.head1.addChild((BasicModelPart)this.ear2);
        this.snoutUpper.addChild((BasicModelPart)this.wisker1);
        this.backLeftHeel.addChild((BasicModelPart)this.backLeftFoot);
        this.backLeftThigh.addChild((BasicModelPart)this.backLeftLeg);
        this.midBody.addChild((BasicModelPart)this.tatters1);
        this.neck.addChild((BasicModelPart)this.head1);
        this.lowerbody.addChild((BasicModelPart)this.backRightThigh);
        this.backRightLeg.addChild((BasicModelPart)this.backRightHeel);
        this.snoutUpper.addChild((BasicModelPart)this.wisker2);
        this.backRightThigh.addChild((BasicModelPart)this.backRightLeg);
        this.animator = ModelAnimator.create();
        this.teeth.setScale(0.99f, 0.99f, 0.99f);
        this.tail3.setScale(0.99f, 0.99f, 0.99f);
        this.tail4.setScale(0.98f, 0.98f, 0.98f);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.lowerbody);
    }

    public void animate(IAnimatedEntity entity) {
        this.resetToDefaultPose();
        this.animator.update(entity);
        this.animator.setAnimation(FeralRatlantean.ANIMATION_BITE);
        this.animator.startKeyframe(5);
        this.rotateFrom(this.lowerbody, 0.0f, 10.0f, 0.0f);
        this.rotateFrom(this.midBody, 0.0f, 10.0f, 0.0f);
        this.rotateFrom(this.frontBody, 0.0f, -30.0f, 0.0f);
        this.rotateFrom(this.neck, 0.0f, -30.0f, 0.0f);
        this.rotateFrom(this.head1, 0.0f, 60.0f, 0.0f);
        this.rotateFrom(this.frontRightFoot, 20.0f, 0.0f, 0.0f);
        this.rotateFrom(this.frontLeftFoot, 20.0f, 0.0f, 0.0f);
        this.animator.move(this.frontRightLeg, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.frontLeftLeg, 0.0f, 1.0f, 0.0f);
        this.animator.move(this.lowerbody, 0.0f, 0.0f, 2.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.lowerbody, 0.0f, 0.0f, -4.0f);
        this.rotateFrom(this.neck, -5.0f, -5.0f, 0.0f);
        this.rotateFrom(this.head1, -30.0f, 5.0f, 0.0f);
        this.rotateFrom(this.mouth1, 40.0f, 5.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(2);
        this.animator.move(this.lowerbody, 0.0f, 0.0f, -1.0f);
        this.rotateFrom(this.neck, -5.0f, -5.0f, 0.0f);
        this.rotateFrom(this.head1, -20.0f, 5.0f, 0.0f);
        this.rotateFrom(this.mouth1, -10.0f, 5.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(3);
        this.animator.setAnimation(FeralRatlantean.ANIMATION_SNIFF);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.lowerbody, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.midBody, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.frontBody, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(-5.0));
        this.animator.rotate(this.backLeftThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.backRightThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.rotateFrom(this.frontLeftFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.frontRightFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.tail1, 20.0f, 0.0f, 0.0f);
        this.rotateFrom(this.head1, 10.0f, 0.0f, 0.0f);
        this.animator.move(this.lowerbody, 0.0f, -3.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(2);
        this.animator.rotate(this.lowerbody, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.midBody, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.frontBody, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(5.0));
        this.animator.rotate(this.backLeftThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.backRightThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.rotateFrom(this.frontLeftFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.frontRightFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.tail1, 20.0f, 0.0f, 0.0f);
        this.rotateFrom(this.head1, -20.0f, 0.0f, 0.0f);
        this.animator.move(this.lowerbody, 0.0f, -3.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(2);
        this.animator.rotate(this.lowerbody, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.midBody, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.frontBody, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(-5.0));
        this.animator.rotate(this.backLeftThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.backRightThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.rotateFrom(this.frontLeftFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.frontRightFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.tail1, 20.0f, 0.0f, 0.0f);
        this.rotateFrom(this.head1, 20.0f, 0.0f, 0.0f);
        this.animator.move(this.lowerbody, 0.0f, -3.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(2);
        this.animator.rotate(this.lowerbody, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.midBody, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.frontBody, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(5.0));
        this.animator.rotate(this.backLeftThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.backRightThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.rotateFrom(this.frontLeftFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.frontRightFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.tail1, 20.0f, 0.0f, 0.0f);
        this.rotateFrom(this.head1, -20.0f, 0.0f, 0.0f);
        this.animator.move(this.lowerbody, 0.0f, -3.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(2);
        this.animator.rotate(this.lowerbody, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.midBody, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.frontBody, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(-5.0));
        this.animator.rotate(this.backLeftThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.backRightThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.rotateFrom(this.frontLeftFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.frontRightFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.tail1, 20.0f, 0.0f, 0.0f);
        this.rotateFrom(this.head1, 20.0f, 0.0f, 0.0f);
        this.animator.move(this.lowerbody, 0.0f, -3.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(2);
        this.animator.rotate(this.lowerbody, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.midBody, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.frontBody, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(5.0));
        this.animator.rotate(this.backLeftThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.backRightThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.rotateFrom(this.frontLeftFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.frontRightFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.tail1, 20.0f, 0.0f, 0.0f);
        this.rotateFrom(this.head1, -20.0f, 0.0f, 0.0f);
        this.animator.move(this.lowerbody, 0.0f, -3.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(FeralRatlantean.ANIMATION_SLASH);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.lowerbody, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.midBody, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.frontBody, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(-25.0));
        this.animator.rotate(this.backLeftThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.backRightThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.rotateFrom(this.frontLeftLeg, -5.0f, 0.0f, -75.0f);
        this.rotateFrom(this.frontLeftHeel, -30.0f, 0.0f, 0.0f);
        this.rotateFrom(this.frontRightLeg, 50.0f, 0.0f, 15.0f);
        this.animator.rotate(this.frontLeftFoot, (float)Math.toRadians(-10.0), (float)Math.toRadians(-45.0), (float)Math.toRadians(45.0));
        this.rotateFrom(this.frontRightFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.tail1, 20.0f, 0.0f, 0.0f);
        this.rotateFrom(this.head1, 60.0f, 0.0f, 10.0f);
        this.rotateFrom(this.mouth1, 30.0f, 0.0f, 0.0f);
        this.animator.move(this.lowerbody, 0.0f, -3.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.lowerbody, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.midBody, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.frontBody, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(25.0));
        this.animator.rotate(this.backLeftThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.backRightThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.rotateFrom(this.frontLeftLeg, -5.0f, 0.0f, 45.0f);
        this.rotateFrom(this.frontLeftHeel, -30.0f, 0.0f, 0.0f);
        this.rotateFrom(this.frontRightLeg, 50.0f, 0.0f, 15.0f);
        this.animator.rotate(this.frontLeftFoot, (float)Math.toRadians(-10.0), (float)Math.toRadians(-45.0), (float)Math.toRadians(45.0));
        this.rotateFrom(this.frontRightFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.tail1, 20.0f, 0.0f, 0.0f);
        this.rotateFrom(this.head1, 60.0f, 0.0f, -10.0f);
        this.rotateFrom(this.mouth1, 30.0f, 0.0f, 0.0f);
        this.animator.move(this.lowerbody, 0.0f, -3.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.lowerbody, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.midBody, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.frontBody, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(25.0));
        this.animator.rotate(this.backLeftThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.backRightThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.rotateFrom(this.frontRightLeg, -5.0f, 0.0f, 75.0f);
        this.rotateFrom(this.frontRightHeel, -30.0f, 0.0f, 0.0f);
        this.rotateFrom(this.frontLeftLeg, 50.0f, 0.0f, -15.0f);
        this.animator.rotate(this.frontRightFoot, (float)Math.toRadians(-10.0), (float)Math.toRadians(45.0), (float)Math.toRadians(-45.0));
        this.rotateFrom(this.frontLeftFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.tail1, 20.0f, 0.0f, 0.0f);
        this.rotateFrom(this.head1, 30.0f, 0.0f, -10.0f);
        this.rotateFrom(this.mouth1, 60.0f, 0.0f, 0.0f);
        this.animator.move(this.lowerbody, 0.0f, -3.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.lowerbody, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.midBody, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.frontBody, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(-25.0));
        this.animator.rotate(this.backLeftThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.backRightThigh, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.rotateFrom(this.frontRightLeg, -5.0f, 0.0f, -45.0f);
        this.rotateFrom(this.frontRightHeel, -30.0f, 0.0f, 0.0f);
        this.rotateFrom(this.frontLeftLeg, 50.0f, 0.0f, -15.0f);
        this.animator.rotate(this.frontRightFoot, (float)Math.toRadians(-10.0), (float)Math.toRadians(45.0), (float)Math.toRadians(-45.0));
        this.rotateFrom(this.frontLeftFoot, 150.0f, 0.0f, 0.0f);
        this.rotateFrom(this.tail1, 20.0f, 0.0f, 0.0f);
        this.rotateFrom(this.head1, 60.0f, 0.0f, 10.0f);
        this.rotateFrom(this.mouth1, 30.0f, 0.0f, 0.0f);
        this.animator.move(this.lowerbody, 0.0f, -3.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(9);
    }

    protected void rotateFrom(AdvancedModelBox renderer, float degX, float degY, float degZ) {
        this.animator.rotate(renderer, (float)Math.toRadians(degX) - renderer.defaultRotationX, (float)Math.toRadians(degY) - renderer.defaultRotationY, (float)Math.toRadians(degZ) - renderer.defaultRotationZ);
    }

    public void setupAnim(T rat, float f, float f1, float f2, float f3, float f4) {
        this.animate((IAnimatedEntity)rat);
        float idleSpeed = 0.3f;
        float idleDegree = 0.1f;
        float walkSpeed = 0.4f;
        float walkDegree = 0.3f;
        AdvancedModelBox[] tailParts = new AdvancedModelBox[]{this.tail1, this.tail2, this.tail3, this.tail4};
        this.bob(this.lowerbody, idleSpeed, idleDegree * 1.5f, false, f2, 1.0f);
        this.bob(this.backLeftThigh, idleSpeed, -idleDegree * 1.5f, false, f2, 1.0f);
        this.bob(this.backRightThigh, idleSpeed, -idleDegree * 1.5f, false, f2, 1.0f);
        this.bob(this.frontLeftLeg, idleSpeed, -idleDegree * 1.5f, false, f2, 1.0f);
        this.bob(this.frontRightLeg, idleSpeed, -idleDegree * 1.5f, false, f2, 1.0f);
        this.walk(this.backLeftThigh, idleSpeed, -idleDegree * 0.25f, false, 3.0f, 0.0f, f2, 1.0f);
        this.walk(this.backLeftLeg, idleSpeed, idleDegree * 0.15f, false, 3.0f, 0.0f, f2, 1.0f);
        this.walk(this.backLeftHeel, idleSpeed, idleDegree * 0.1f, false, 3.0f, 0.0f, f2, 1.0f);
        this.walk(this.backRightThigh, idleSpeed, -idleDegree * 0.25f, false, 3.0f, 0.0f, f2, 1.0f);
        this.walk(this.backRightLeg, idleSpeed, idleDegree * 0.15f, false, 3.0f, 0.0f, f2, 1.0f);
        this.walk(this.backRightHeel, idleSpeed, idleDegree * 0.1f, false, 3.0f, 0.0f, f2, 1.0f);
        this.walk(this.frontLeftLeg, idleSpeed, idleDegree * 0.15f, false, 3.0f, 0.0f, f2, 1.0f);
        this.walk(this.frontLeftHeel, idleSpeed, -idleDegree * 0.15f, false, 3.0f, 0.0f, f2, 1.0f);
        this.walk(this.frontRightLeg, idleSpeed, idleDegree * 0.15f, false, 3.0f, 0.0f, f2, 1.0f);
        this.walk(this.frontRightHeel, idleSpeed, -idleDegree * 0.15f, false, 3.0f, 0.0f, f2, 1.0f);
        this.walk(this.frontRightFoot, idleSpeed, idleDegree * 0.25f, false, 2.0f, 0.0f, f2, 1.0f);
        this.walk(this.frontLeftFoot, idleSpeed, idleDegree * 0.25f, false, 2.0f, 0.0f, f2, 1.0f);
        this.walk(this.frontBody, idleSpeed, -idleDegree * 0.25f, false, 2.0f, 0.0f, f2, 1.0f);
        this.walk(this.neck, idleSpeed, idleDegree * 0.15f, false, 2.0f, 0.0f, f2, 1.0f);
        this.chainSwing(tailParts, idleSpeed, idleDegree * 0.5f, 1.0, f2, 1.0f);
        this.swing(this.backLeftThigh, idleSpeed, -idleDegree * 0.95f, true, 1.0f, -0.1f, f2, 1.0f);
        this.swing(this.backRightThigh, idleSpeed, -idleDegree * 0.95f, false, 1.0f, 0.1f, f2, 1.0f);
        this.swing(this.frontLeftLeg, idleSpeed, -idleDegree * 0.95f, true, 1.0f, -0.1f, f2, 1.0f);
        this.swing(this.frontRightLeg, idleSpeed, -idleDegree * 0.95f, false, 1.0f, 0.1f, f2, 1.0f);
        this.swing(this.backLeftFoot, idleSpeed, idleDegree * 0.95f, true, 1.0f, -0.1f, f2, 1.0f);
        this.swing(this.backRightFoot, idleSpeed, idleDegree * 0.95f, false, 1.0f, 0.1f, f2, 1.0f);
        this.swing(this.frontLeftFoot, idleSpeed, idleDegree * 0.95f, true, 1.0f, -0.1f, f2, 1.0f);
        this.swing(this.frontRightFoot, idleSpeed, idleDegree * 0.95f, false, 1.0f, 0.1f, f2, 1.0f);
        float ulatingScale = 0.9f + (float)Math.sin(f2 * 0.75f) * 0.1f;
        this.swing(this.wisker2, idleSpeed, idleDegree, false, 0.0f, 0.0f, f2, 1.0f);
        this.swing(this.wisker1, idleSpeed, idleDegree, true, 0.0f, 0.0f, f2, 1.0f);
        this.flap(this.wisker2, idleSpeed, idleDegree, false, 1.0f, 0.0f, f2, 1.0f);
        this.flap(this.wisker1, idleSpeed, idleDegree, false, 1.0f, 0.0f, f2, 1.0f);
        this.walk(this.wisker2, idleSpeed, idleDegree, false, 2.0f, 0.0f, f2, 1.0f);
        this.walk(this.wisker1, idleSpeed, idleDegree, false, 2.0f, 0.0f, f2, 1.0f);
        this.nose.setScale(ulatingScale, ulatingScale, ulatingScale);
        this.walk(this.mouth1, idleSpeed * 0.75f, idleDegree, true, 4.0f, -0.1f, f2, 1.0f);
        this.flap(this.tatters1, idleSpeed * 0.25f, idleDegree, true, 3.0f, -0.1f, f2, 1.0f);
        this.flap(this.tatters2, idleSpeed * 0.25f, idleDegree, true, 3.0f, -0.1f, f2, 1.0f);
        this.flap(this.tatters3, idleSpeed * 0.5f, idleDegree, true, 3.0f, 0.1f, f2, 1.0f);
        this.flap(this.tatters4, idleSpeed * 0.5f, idleDegree, true, 3.0f, 0.1f, f2, 1.0f);
        this.bob(this.lowerbody, walkSpeed, walkDegree * 5.0f, false, f, f1);
        this.walk(this.midBody, walkSpeed, walkDegree, false, 0.0f, 0.0f, f, f1);
        this.walk(this.frontBody, walkSpeed, walkDegree * 0.5f, false, 1.0f, -0.1f, f, f1);
        this.walk(this.neck, walkSpeed, walkDegree * 0.5f, false, 2.0f, 0.0f, f, f1);
        this.walk(this.tail1, walkSpeed, walkDegree, false, -1.0f, 0.3f, f, f1);
        this.walk(this.tail2, walkSpeed, walkDegree * 0.5f, false, -2.0f, 0.1f, f, f1);
        this.walk(this.tail3, walkSpeed, walkDegree * 0.5f, false, -3.0f, 0.0f, f, f1);
        this.walk(this.tail4, walkSpeed, walkDegree * 0.5f, false, -4.0f, 0.1f, f, f1);
        this.walk(this.backLeftThigh, walkSpeed, walkDegree * 2.0f, true, 0.0f, 0.0f, f, f1);
        this.walk(this.backRightThigh, walkSpeed, walkDegree * 2.0f, true, 0.0f, 0.0f, f, f1);
        this.walk(this.backLeftLeg, walkSpeed, walkDegree * 2.0f, true, 0.0f, 0.0f, f, f1);
        this.walk(this.backRightLeg, walkSpeed, walkDegree * 2.0f, true, 0.0f, 0.0f, f, f1);
        this.walk(this.backLeftHeel, walkSpeed, walkDegree, true, 1.0f, 0.0f, f, f1);
        this.walk(this.backRightHeel, walkSpeed, walkDegree, true, 1.0f, 0.0f, f, f1);
        this.walk(this.backLeftFoot, walkSpeed, walkDegree * 6.0f, false, 0.7f, 0.4f, f, f1);
        this.walk(this.backRightFoot, walkSpeed, walkDegree * 6.0f, false, 0.7f, 0.4f, f, f1);
        this.walk(this.frontLeftLeg, walkSpeed, walkDegree * 2.0f, true, 2.0f, 0.1f, f, f1);
        this.walk(this.frontRightLeg, walkSpeed, walkDegree * 2.0f, true, 2.0f, 0.1f, f, f1);
        this.walk(this.frontLeftHeel, walkSpeed, walkDegree * 2.0f, true, 2.0f, -0.2f, f, f1);
        this.walk(this.frontRightHeel, walkSpeed, walkDegree * 2.0f, true, 2.0f, -0.2f, f, f1);
        this.walk(this.frontLeftFoot, walkSpeed, walkDegree * 4.0f, false, 2.6f, 0.01f, f, f1);
        this.walk(this.frontRightFoot, walkSpeed, walkDegree * 4.0f, false, 2.6f, 0.01f, f, f1);
        this.swing(this.frontLeftLeg, walkSpeed, -walkDegree, false, 1.5f, -0.25f, f, f1);
        this.swing(this.frontRightLeg, walkSpeed, -walkDegree, true, 1.5f, -0.25f, f, f1);
        this.swing(this.backLeftThigh, walkSpeed, -walkDegree * 1.25f, false, 0.0f, -0.25f, f, f1);
        this.swing(this.backRightThigh, walkSpeed, -walkDegree * 1.25f, true, 0.0f, -0.25f, f, f1);
        this.head1.rotateAngleX = f4 * ((float)Math.PI / 180);
        this.head1.rotateAngleY = f3 * ((float)Math.PI / 180);
    }

    public void setRotateAngle(AdvancedModelBox box, float x, float y, float z) {
        box.rotateAngleX = x;
        box.rotateAngleY = y;
        box.rotateAngleZ = z;
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.lowerbody, (Object)this.midBody, (Object)this.backLeftThigh, (Object)this.backRightThigh, (Object)this.tail1, (Object)this.tatters3, (Object)this.frontBody, (Object)this.tatters1, (Object)this.tatters2, (Object)this.frontRightLeg, (Object)this.frontLeftLeg, (Object)this.neck, (Object[])new AdvancedModelBox[]{this.frontRightHeel, this.frontRightFoot, this.frontLeftHeel, this.frontLeftFoot, this.head1, this.tatters4, this.snoutUpper, this.mouth1, this.ear1, this.ear2, this.nose, this.teeth, this.wisker1, this.wisker2, this.backLeftLeg, this.backLeftHeel, this.backLeftFoot, this.backRightLeg, this.backRightHeel, this.backRightFoot, this.tail2, this.tail3, this.tail4});
    }
}

