/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.model.entity;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe666.rats.server.entity.mount.RatGolemMount;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.Minecraft;

public class RatGolemMountModel<T extends RatGolemMount>
extends AdvancedEntityModel<T> {
    public final AdvancedModelBox chest;
    public final AdvancedModelBox waist;
    public final AdvancedModelBox leftArm;
    public final AdvancedModelBox rightArm;
    public final AdvancedModelBox rightLeg;
    public final AdvancedModelBox leftLeg;
    public final AdvancedModelBox dome;

    public RatGolemMountModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.leftLeg = new AdvancedModelBox((AdvancedEntityModel)this, 60, 0);
        this.leftLeg.mirror = true;
        this.leftLeg.setRotationPoint(5.0f, 11.0f, 0.0f);
        this.leftLeg.addBox(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, 0.0f);
        this.leftArm = new AdvancedModelBox((AdvancedEntityModel)this, 60, 58);
        this.leftArm.setRotationPoint(0.0f, -7.0f, 0.0f);
        this.leftArm.addBox(9.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, 0.0f);
        this.chest = new AdvancedModelBox((AdvancedEntityModel)this, 0, 40);
        this.chest.setRotationPoint(0.0f, -7.0f, 0.0f);
        this.chest.addBox(-9.0f, -2.0f, -6.0f, 18.0f, 12.0f, 11.0f, 0.0f);
        this.rightArm = new AdvancedModelBox((AdvancedEntityModel)this, 60, 21);
        this.rightArm.setRotationPoint(0.0f, -7.0f, 0.0f);
        this.rightArm.addBox(-13.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, 0.0f);
        this.rightLeg = new AdvancedModelBox((AdvancedEntityModel)this, 37, 0);
        this.rightLeg.setRotationPoint(-4.0f, 11.0f, 0.0f);
        this.rightLeg.addBox(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, 0.0f);
        this.dome = new AdvancedModelBox((AdvancedEntityModel)this, 0, 82);
        this.dome.setRotationPoint(0.0f, -9.0f, 0.0f);
        this.dome.addBox(-5.0f, -14.0f, -5.0f, 10.0f, 14.0f, 10.0f, 0.0f);
        this.waist = new AdvancedModelBox((AdvancedEntityModel)this, 0, 70);
        this.waist.setRotationPoint(0.0f, -7.0f, 0.0f);
        this.waist.addBox(-4.5f, 10.0f, -3.0f, 9.0f, 5.0f, 6.0f, 0.5f);
        this.updateDefaultPose();
    }

    public void setupAnim(T entity, float f, float f1, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.leftLeg.rotateAngleX = -1.5f * this.triangleWave(f, 13.0f) * f1;
        this.rightLeg.rotateAngleX = 1.5f * this.triangleWave(f, 13.0f) * f1;
        this.leftLeg.rotateAngleY = 0.0f;
        this.rightLeg.rotateAngleY = 0.0f;
        int i = ((RatGolemMount)entity).getAttackTimer();
        if (i > 0) {
            float partialTicks = Minecraft.m_91087_().getPartialTick();
            this.leftArm.rotateAngleX = -2.0f + 1.5f * this.triangleWave((float)i - partialTicks, 10.0f);
            this.rightArm.rotateAngleX = -2.0f + 1.5f * this.triangleWave((float)i - partialTicks, 10.0f);
        } else {
            this.leftArm.rotateAngleX = (-0.2f + 1.5f * this.triangleWave(f, 13.0f)) * f1;
            this.rightArm.rotateAngleX = (-0.2f - 1.5f * this.triangleWave(f, 13.0f)) * f1;
        }
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.chest, (Object)this.waist, (Object)this.dome, (Object)this.leftArm, (Object)this.leftLeg, (Object)this.rightArm, (Object)this.rightLeg);
    }

    private float triangleWave(float time, float interval) {
        return (Math.abs(time % interval - interval * 0.5f) - interval * 0.25f) / (interval * 0.25f);
    }

    public void setRotateAngle(AdvancedModelBox box, float x, float y, float z) {
        box.rotateAngleX = x;
        box.rotateAngleY = y;
        box.rotateAngleZ = z;
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.chest, (Object)this.waist, (Object)this.dome, (Object)this.leftArm, (Object)this.leftLeg, (Object)this.rightArm, (Object)this.rightLeg);
    }
}

