/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render;

import com.github.alexthe666.rats.client.events.ModClientEvents;
import com.github.alexthe666.rats.client.render.block.RatlantisPortalRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class RatsRenderType
extends RenderType {
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_RATLANTIS_PORTAL_SHADER = new RenderStateShard.ShaderStateShard(ModClientEvents::getRendertypeRatlantisPortalShader);
    private static final RenderType RATLANTIS_PORTAL = RatsRenderType.m_173215_((String)"ratlantis_portal", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_RATLANTIS_PORTAL_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.m_173127_().m_173132_(RatlantisPortalRenderer.PORTAL_BG, false, false).m_173132_(RatlantisPortalRenderer.PORTAL_FG, false, false).m_173131_()).m_110691_(false));
    protected static final RenderStateShard.TexturingStateShard RAINBOW_GLINT_TEXTURING = new RenderStateShard.TexturingStateShard("rainbow_glint_texturing", RatsRenderType::setupRainbowRendering, RenderSystem::resetTextureMatrix);
    private static final RenderType ACE_GLINT = RatsRenderType.m_173215_((String)"ace_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/ace_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType ARO_GLINT = RatsRenderType.m_173215_((String)"aro_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/aro_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType BI_GLINT = RatsRenderType.m_173215_((String)"bi_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/bi_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType ENBY_GLINT = RatsRenderType.m_173215_((String)"enby_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/enby_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType GAY_GLINT = RatsRenderType.m_173215_((String)"gay_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/gay_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType GENDERFLUID_GLINT = RatsRenderType.m_173215_((String)"genderfluid_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/genderfluid_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType LESBIAN_GLINT = RatsRenderType.m_173215_((String)"lesbian_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/lesbian_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType PAN_GLINT = RatsRenderType.m_173215_((String)"pan_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/pan_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType RAINBOW_GLINT = RatsRenderType.m_173215_((String)"rainbow_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/rainbow_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType TRANS_GLINT = RatsRenderType.m_173215_((String)"trans_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/trans_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType PISS_GLINT = RatsRenderType.m_173215_((String)"piss_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/piss_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType UNPLEASANT_GLINT = RatsRenderType.m_173215_((String)"unpleasant_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/special_dyes/unpleasant_glint.png"), true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(RAINBOW_GLINT_TEXTURING).m_110677_(f_110154_).m_110691_(true));
    private static final RenderType GREEN_ENTITY_GLINT = RatsRenderType.m_173215_((String)"green_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/green_glint.png"), true, false)).m_173292_(f_173083_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110151_).m_110691_(false));
    private static final RenderType YELLOW_ENTITY_GLINT = RatsRenderType.m_173215_((String)"yellow_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/yellow_glint.png"), true, false)).m_173292_(f_173083_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110151_).m_110691_(false));
    private static final RenderType WHITE_ENTITY_GLINT = RatsRenderType.m_173215_((String)"white_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/white_glint.png"), true, false)).m_173292_(f_173083_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110151_).m_110691_(false));
    private static final RenderType GOLD_ENTITY_GLINT = RatsRenderType.m_173215_((String)"gold_glint", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("rats", "textures/misc/gold_glint.png"), true, false)).m_173292_(f_173083_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110151_).m_110691_(false));

    public RatsRenderType(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumble, boolean sort, Runnable builder1, Runnable builder2) {
        super(name, format, mode, bufferSize, affectsCrumble, sort, builder1, builder2);
    }

    public static RenderType getYellowGlint() {
        return YELLOW_ENTITY_GLINT;
    }

    public static RenderType getGreenGlint() {
        return GREEN_ENTITY_GLINT;
    }

    public static RenderType getWhiteGlint() {
        return WHITE_ENTITY_GLINT;
    }

    public static RenderType getGoldGlint() {
        return GOLD_ENTITY_GLINT;
    }

    public static RenderType getRatlantisPortal() {
        return RATLANTIS_PORTAL;
    }

    public static RenderType getRainbowGlint() {
        return RAINBOW_GLINT;
    }

    public static RenderType getGlowingTranslucent(ResourceLocation location) {
        RenderStateShard.TextureStateShard texture = new RenderStateShard.TextureStateShard(location, false, true);
        return RatsRenderType.m_173215_((String)"glowing_translucent", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)texture).m_173292_(RenderStateShard.f_173074_).m_110685_(f_110139_).m_110675_(f_110125_).m_110687_(f_110114_).m_110691_(true));
    }

    private static void setupRainbowRendering() {
        long i = Util.m_137550_() * 8L;
        float f = (float)(i % 10000L) / 10000.0f;
        Matrix4f matrix4f = new Matrix4f().translation(0.0f, f, 0.0f);
        matrix4f.scale(0.16f);
        RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
    }

    public static enum GlintType {
        AROMANTIC(ARO_GLINT, true, "aromantic", "aro"),
        ASEXUAL(ACE_GLINT, true, "asexual", "ace"),
        BISEXUAL(BI_GLINT, true, "bisexual", "bi"),
        GAY(GAY_GLINT, true, "gay", "mlm"),
        GENDERFLUID(GENDERFLUID_GLINT, true, "genderfluid", "fluid"),
        NONBINARY(ENBY_GLINT, true, "non-binary", "nonbinary", "enby"),
        LESBIAN(LESBIAN_GLINT, true, "lesbian", "wlw"),
        PANSEXUAL(PAN_GLINT, true, "pansexual", "pan"),
        TRANSGENDER(TRANS_GLINT, true, "transgender", "trans"),
        PISS(PISS_GLINT, false, "piss"),
        UNPLEASANT(UNPLEASANT_GLINT, false, "unpleasant");

        private final RenderType type;
        private final boolean changesTexture;
        private final List<String> keywords;

        private GlintType(RenderType type, boolean changesItemTex, String ... matchingKeywords) {
            this.type = type;
            this.changesTexture = changesItemTex;
            this.keywords = Arrays.stream(matchingKeywords).toList();
        }

        public boolean changesItemTexture() {
            return this.changesTexture;
        }

        public RenderType getRenderType() {
            return this.type;
        }

        @Nullable
        public static RenderType getRenderTypeBasedOnKeyword(String word) {
            for (GlintType type : GlintType.values()) {
                for (String possibleWord : type.getKeywords()) {
                    if (!possibleWord.equalsIgnoreCase(word)) continue;
                    return type.getRenderType();
                }
            }
            return null;
        }

        @Nullable
        public static GlintType getGlintBasedOnKeyword(String word) {
            for (GlintType type : GlintType.values()) {
                for (String possibleWord : type.getKeywords()) {
                    if (!possibleWord.equalsIgnoreCase(word)) continue;
                    return type;
                }
            }
            return null;
        }

        public List<String> getKeywords() {
            return this.keywords;
        }
    }
}

