/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.entity.AbstractRatModel;
import com.github.alexthe666.rats.client.model.entity.BiplaneModel;
import com.github.alexthe666.rats.client.render.entity.RattlingGunRenderer;
import com.github.alexthe666.rats.client.render.entity.layer.PartyHatLayer;
import com.github.alexthe666.rats.client.render.entity.layer.RatHeldItemLayer;
import com.github.alexthe666.rats.client.render.entity.layer.RatHelmetLayer;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.misc.RattlingGun;
import com.github.alexthe666.rats.server.entity.monster.boss.RatBaronPlane;
import com.github.alexthe666.rats.server.entity.mount.RatBiplaneMount;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.items.HatItem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public abstract class AbstractRatRenderer<T extends AbstractRat, M extends AbstractRatModel<T>>
extends MobRenderer<T, M> {
    public AbstractRatRenderer(EntityRendererProvider.Context context, M model) {
        super(context, model, 0.15f);
        this.m_115326_(new RatHelmetLayer(this, (HumanoidModel<?>)new HumanoidModel(context.m_174023_(ModelLayers.f_171165_))));
        this.m_115326_(new RatHeldItemLayer(this));
        this.m_115326_(new PartyHatLayer(this, new HumanoidModel(context.m_174023_(ModelLayers.f_171165_))));
    }

    public boolean shouldRender(T rat, Frustum camera, double camX, double camY, double camZ) {
        LivingEntity living;
        Entity entity;
        if (rat.m_20159_() && rat.m_20202_() != null && rat.m_20202_().m_20197_().size() >= 1 && rat.m_20202_().m_20197_().get(0) == rat && (entity = rat.m_20202_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_6844_(EquipmentSlot.HEAD).m_150930_((Item)RatsItemRegistry.CHEF_TOQUE.get())) {
            return false;
        }
        return super.m_5523_(rat, camera, camX, camY, camZ);
    }

    protected void scale(T rat, PoseStack stack, float partialTicks) {
        stack.m_85841_(0.6f, 0.6f, 0.6f);
        if (rat.m_20159_() && rat.m_20202_() != null && rat.m_20202_().m_20197_().size() >= 1 && rat.m_20202_() != null) {
            EntityModel entityModel;
            LivingEntityRenderer renderer;
            EntityRenderer playerRender;
            Entity riding;
            Entity entity = rat.m_20202_();
            if (entity instanceof Player) {
                LivingEntityRenderer renderer2;
                EntityModel entityModel2;
                EntityRenderer playerRender2;
                Player player = (Player)entity;
                Entity riding2 = rat.m_20202_();
                if (riding2.m_20197_().get(0) != null && riding2.m_20197_().get(0) == rat && (playerRender2 = Minecraft.m_91087_().m_91290_().m_114382_(riding2)) instanceof LivingEntityRenderer && (entityModel2 = (renderer2 = (LivingEntityRenderer)playerRender2).m_7200_()) instanceof HumanoidModel) {
                    HumanoidModel human = (HumanoidModel)entityModel2;
                    human.m_5585_().m_104299_(stack);
                    stack.m_252880_(0.0f, -0.7f, 0.25f);
                    Item item = player.m_6844_(EquipmentSlot.HEAD).m_41720_();
                    if (item instanceof HatItem) {
                        HatItem hatItem = (HatItem)item;
                        stack.m_252880_(0.0f, hatItem.getRatOffsetOnHead(), 0.0f);
                    }
                }
            }
            if (rat.m_20202_() instanceof RattlingGun && (riding = rat.m_20202_()).m_20197_().get(0) != null && riding.m_20197_().get(0) == rat && (playerRender = Minecraft.m_91087_().m_91290_().m_114382_(riding)) instanceof LivingEntityRenderer && (renderer = (LivingEntityRenderer)playerRender).m_7200_() instanceof HumanoidModel) {
                RattlingGunRenderer.GUN_MODEL.pivot.translateRotate(stack);
            }
            if ((rat.m_20202_() instanceof RatBaronPlane || rat.m_20202_() instanceof RatBiplaneMount) && (riding = rat.m_20202_()).m_20197_().get(0) != null && riding.m_20197_().get(0) == rat && (playerRender = Minecraft.m_91087_().m_91290_().m_114382_(riding)) instanceof LivingEntityRenderer && (entityModel = (renderer = (LivingEntityRenderer)playerRender).m_7200_()) instanceof BiplaneModel) {
                BiplaneModel plane = (BiplaneModel)entityModel;
                stack.m_252880_(0.0f, -0.1f, 0.45f);
                plane.body1.translateRotate(stack);
            }
        }
    }

    protected float getFlipDegrees(T rat) {
        return ((AbstractRat)((Object)rat)).isDeadInTrap() ? 0.0f : 90.0f;
    }

    public ResourceLocation getTextureLocation(T rat) {
        return ((AbstractRat)((Object)rat)).getColorVariant().getTexture();
    }
}

