/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.events.ModClientEvents;
import com.github.alexthe666.rats.client.model.entity.AbstractRatModel;
import com.github.alexthe666.rats.client.model.entity.PinkieModel;
import com.github.alexthe666.rats.client.model.entity.RatModel;
import com.github.alexthe666.rats.client.render.entity.AbstractRatRenderer;
import com.github.alexthe666.rats.client.render.entity.layer.TamedRatEyesLayer;
import com.github.alexthe666.rats.client.render.entity.layer.TamedRatOverlayLayer;
import com.github.alexthe666.rats.registry.RatVariantRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesTextureUpgrade;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.github.alexthe666.rats.server.misc.RatVariant;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;

public class TamedRatRenderer
extends AbstractRatRenderer<TamedRat, AbstractRatModel<TamedRat>> {
    private static final RatModel<TamedRat> RAT_MODEL = new RatModel();
    private static final PinkieModel<TamedRat> PINKIE_MODEL = new PinkieModel();
    private static final ResourceLocation PINKIE_TEXTURE = new ResourceLocation("rats", "textures/entity/rat/baby.png");

    public TamedRatRenderer(EntityRendererProvider.Context context) {
        super(context, new RatModel());
        this.m_115326_(new TamedRatOverlayLayer((RenderLayerParent<TamedRat, AbstractRatModel<TamedRat>>)this));
        this.m_115326_(new TamedRatEyesLayer((RenderLayerParent<TamedRat, AbstractRatModel<TamedRat>>)this));
    }

    protected boolean shouldShowName(TamedRat entity) {
        return ModClientEvents.shouldRenderNameplates() && super.m_6512_((Mob)entity);
    }

    public void render(TamedRat entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        this.f_115290_ = entity.m_6162_() ? PINKIE_MODEL : RAT_MODEL;
        super.m_7392_((Mob)entity, entityYaw, partialTicks, stack, buffer, light);
    }

    @Override
    public ResourceLocation getTextureLocation(TamedRat entity) {
        if (entity.m_6162_()) {
            return PINKIE_TEXTURE;
        }
        AtomicReference<String> upgradeTex = new AtomicReference<String>("");
        RatUpgradeUtils.forEachUpgrade(entity, item -> item instanceof ChangesTextureUpgrade, (stack, slot) -> {
            if (entity.isSlotVisible((EquipmentSlot)slot)) {
                upgradeTex.set(((ChangesTextureUpgrade)stack.m_41720_()).getTexture().toString());
            }
        });
        if (!upgradeTex.get().equals("")) {
            return new ResourceLocation(upgradeTex.get());
        }
        if (entity.m_8077_()) {
            for (RatVariant variant : RatVariantRegistry.RAT_VARIANT_REGISTRY.get()) {
                if (!Objects.requireNonNull(entity.m_7770_()).getString().equalsIgnoreCase(variant.getName())) continue;
                return variant.getTexture();
            }
        }
        return super.getTextureLocation(entity);
    }
}

