/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.data;

import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsEffectRegistry;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.text.WordUtils;

public class RatsLangGenerator
extends LanguageProvider {
    public RatsLangGenerator(PackOutput output) {
        super(output, "rats", "en_us");
    }

    protected void addTranslations() {
        this.addAdvancement("root", "Rats", "Rat Patootie");
        this.addAdvancement("rat_trap", "An Effective Classic", "Craft a Rat Trap");
        this.addAdvancement("piper", "Pay the Piper", "Encounter a rat-controlling fiend");
        this.addAdvancement("milk_cauldron", "Curdling Time", "Pour milk into a cauldron and wait for it to turn to cheese");
        this.addAdvancement("cheese", "We've Forgotten the Crackers!", "Turn a Block of Cheese into four Cheese");
        this.addAdvancement("tame_rat", "An Unlikely Alliance", "Tame a Rat by dropping Cheese near it repeatedly until it is full");
        this.addAdvancement("rat_cage", "Despite All My Rage...", "Craft a Rat Cage, used for breeding rats");
        this.addAdvancement("cheese_stick", "Cheese Touch", "Craft a Cheese Staff, used for setting drop-off and pickup locations for tamed rats");
        this.addAdvancement("rat_upgrade_platter", "Carry Weight 64", "Craft Rat Upgrade: Platter, used to make rats transport an entire stack of items at a time");
        this.addAdvancement("rat_upgrade_basic", "Rat Specialization", "Craft Rat Upgrade: Basic, used to craft advanced rat upgrades");
        this.addAdvancement("rat_upgrade_strength", "Rat Karate", "Craft Rat Upgrade: Strength, making your rat pack a powerful punch");
        this.addAdvancement("rat_upgrade_warrior", "Rat Warrior Clan", "Craft Rat Upgrade: Warrior, making your rat stronger, have armor and higher health");
        this.addAdvancement("rat_upgrade_god", "Whats a Man to a King?", "Craft Rat Upgrade: God, turning your rat into an almost unstoppable killing machine");
        this.addAdvancement("rat_upgrade_crafting", "Crafty Rats!", "Craft Rat Upgrade: Crafting, the first step in rat auto-crafting");
        this.addAdvancement("rat_crafting_table", "Rat Auto-Crafting", "Craft a Rat Crafting Table");
        this.addAdvancement("rat_upgrade_chef", "The Rat is the Cook!", "Craft a Rat Upgrade: Chef, which makes rats cook held items");
        this.addAdvancement("rat_cooking", "Anyone Can Cook", "Obtain one of the rare gourmet foods prepared by a rat chef");
        this.addAdvancement("rat_upgrade_flight", "Essentially Pigeons", "Craft a Rat Upgrade: Flight, enabling rats to take to the skies");
        this.addAdvancement("rat_cage_decoration", "A Gilded Cage", "Place a rat cage decoration in a Rat Cage");
        this.addAdvancement("rat_music_disc", "Rat Tunes", "Get a music disc by killing a Pied Piper with a rat");
        this.addAdvancement("contaminated_food", "Stop that Health Inspector!", "Find disgusting contaminated food left behind by a rat");
        this.addAdvancement("plague", "Down with the Sickness!", "Catch the plague from a Plague Rat");
        this.addAdvancement("plague_doctor", "I AM THE CURE!", "Find a Plague Doctor in a village or out in the wild");
        this.addAdvancement("plague_cure", "The Medieval Treatment", "Find a possible cure for the plague");
        this.addAdvancement("black_death", "Dance Macabre!", "Encounter the Black Death, a possessed Plague Doctor summoned by a lightning strike");
        this.addAdvancement("defeat_black_death", "Do Not Go Quietly Into the Night", "Defeat the Black Death");
        this.addAdvancement("trash_can", "This Mod is Trash", "Craft a trash can from a cauldron, some iron ingots and an iron nugget. Use it to create garbage piles!");
        this.addAdvancement("garbage_pile", "Too Much Trash in Your Face? There's No Trash in Space!", "Obtain a garbage pile from putting blocks in a trash can. They can be used to build rat-exclusive mob farms!");
        this.addAdvancement("ball_of_filth", "Cleanliness is Close to Godliness!", "Craft a Ball of Filth from an ungodly amount of Garbage");
        this.addAdvancement("rat_king", "King of the World!", "Slay the Rat King");
        this.addAdvancement("ratbow_essence", "In Stunning Technicolor!", "Craft a Ratbow Essence, which can be used to dye a rat a constant shifting rainbow");
        this.addAdvancement("nether_cheese", "Spicy Pepper Jack", "Obtain nether cheese from a demon rat in the nether");
        this.addAdvancement("rat_upgrade_demon", "I Seen This Before...", "Craft a Rat Upgrade: Demon, a well rounded nether-proof rat upgrade");
        this.addAdvancement("rat_upgrade_idol", "False Prophet", "Craft a Rat Upgrade: Idol, an upgrade that enamors piglins");
        this.addAdvancement("rat_upgrade_pickpocket", "Talk of the Town", "Craft a Rat Upgrade: Pickpocket, turning your rat into a sneaky village thief");
        this.addAdvancement("rat_upgrade_sculked", "One with the Souls", "Craft a Rat Upgrade: Sculked, making your rat one with the lost souls of the sculk");
        this.addAdvancement("all_hats", "Grand Hat Collector", "Collect every hat the mod has to offer!");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.AUTO_CURDLER, "Curdling Station", "Automatic cheese production", "\u00a7o\"Milk goes in, cheese comes out\"");
        this.addBlock((Supplier)RatsBlockRegistry.BLOCK_OF_BLUE_CHEESE, "Block of Blue Cheese");
        this.addBlock((Supplier)RatsBlockRegistry.BLOCK_OF_CHEESE, "Block of Cheese");
        this.addBlock((Supplier)RatsBlockRegistry.BLOCK_OF_NETHER_CHEESE, "Block of Nether Cheese");
        this.addBlock((Supplier)RatsBlockRegistry.BLUE_CHEESE_CAULDRON, "Cauldron of Blue Cheese");
        this.addBlock((Supplier)RatsBlockRegistry.CHEESE_CAULDRON, "Cauldron of Cheese");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.COMPRESSED_GARBAGE, "Compressed Garbage", "Spawns double the amount of Rats than normal Garbage Piles");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.CURSED_GARBAGE, "Diseased Garbage", "Spawn Plague Rats on block");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.DYE_SPONGE, "Dye Sponge", "Removes dye from Rats or Sheep");
        this.addBlock((Supplier)RatsBlockRegistry.FISH_BARREL, "Barrel of Fish");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.GARBAGE_PILE, "Garbage Pile", "Spawn Rats on block");
        this.addBlock((Supplier)RatsBlockRegistry.JACK_O_RATERN, "Jack O' Ratern");
        this.addBlock((Supplier)RatsBlockRegistry.MANHOLE, "Manhole Cover");
        this.addBlock((Supplier)RatsBlockRegistry.MARBLED_CHEESE_RAW, "Raw Marbled Cheese");
        this.addBlock((Supplier)RatsBlockRegistry.MILK_CAULDRON, "Cauldron of Milk");
        this.addBlock((Supplier)RatsBlockRegistry.NETHER_CHEESE_CAULDRON, "Cauldron of Nether Cheese");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.PIED_GARBAGE, "Pied Garbage", "Spawn Pied Pipers on block");
        this.addBlock((Supplier)RatsBlockRegistry.PIED_WOOL, "Pied Wool");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.PURIFIED_GARBAGE, "Purified Garbage", "Spawn Rats without plague on block");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.RAT_ATTRACTOR, "Rat Attractor", "Attracts wild rats nearby when powered with redstone");
        this.addBlockWithBothDescs((Supplier<Block>)RatsBlockRegistry.RAT_CAGE, "Rat Cage", "While having a rat sitting on your head or shoulder (sneak + click a rat), click on the cage to deposit the rat inside. Click again to release the rat. Rat cages connect to each other, and two opposite gender rats in the same cage have a chance to breed.", "Interact with while having a rat on your shoulder to deposit it in the cage", "Interact again to release rats");
        this.addBlock((Supplier)RatsBlockRegistry.RAT_CAGE_BREEDING_LANTERN, "Rat Cage with Lantern");
        this.addBlock((Supplier)RatsBlockRegistry.RAT_CAGE_DECORATED, "Decorated Rat Cage");
        this.addBlock((Supplier)RatsBlockRegistry.RAT_CAGE_WHEEL, "Rat Cage with Wheel");
        this.addBlockWithJEIDesc((Supplier<Block>)RatsBlockRegistry.RAT_CRAFTING_TABLE, "Rat Crafting Table", "Used in autocrafting, a rat crafting table requires a rat with the Rat Upgrade: Crafting sitting above the table to function. Create a ghost recipe in the crafting grid and add the required materials below it to get it working. This process can be automated with rats transporting and gathering items or the use of hoppers and other modded pipes.");
        this.addBlock((Supplier)RatsBlockRegistry.RAT_HOLE, "Rat Hole");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.RAT_QUARRY, "Rat Quarry", "Rats will dig quarry immediately below block", "Set quarry rats to 'Harvest' then assign this block as their deposit position with a cheese staff");
        this.addBlock((Supplier)RatsBlockRegistry.RAT_QUARRY_PLATFORM, "Rat Quarry Platform");
        this.addBlockWithJEIDesc((Supplier<Block>)RatsBlockRegistry.RAT_TRAP, "Rat Trap", "Place any food item rats will eat in the rat trap to attract wild rats. When they die inside the trap, it needs to be reset. Right click the trap or power it with redstone to reset it.");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.RAT_TUBE_COLOR, "Rat Tube", "Right click to place Rat Tube", "Right click Rat Tube to create an entrance", "Rats will only go inside Rat Tubes that have entrances");
        this.addBlock((Supplier)RatsBlockRegistry.RAT_UPGRADE_BLOCK, "Rat Upgrade Block");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.TRASH_CAN, "Trash Can", "Right click with an empty hand to open or close", "Right click with blocks in hand to throw them away", "Creates garbage piles when enough blocks are discarded");
        this.addBlock((Supplier)RatsBlockRegistry.UPGRADE_COMBINER, "Upgrade Combiner");
        this.addBlockWithDesc((Supplier<Block>)RatsBlockRegistry.UPGRADE_SEPARATOR, "Upgrade Separator", "Throw a combined rat upgrade on top to shatter it");
        this.addEntityAndEgg(RatsEntityRegistry.BLACK_DEATH, "Black Death");
        this.addEntityAndEgg(RatsEntityRegistry.DEMON_RAT, "Demon Rat");
        this.addEntityAndEgg(RatsEntityRegistry.PIED_PIPER, "Pied Piper");
        this.addEntityAndEgg(RatsEntityRegistry.PLAGUE_BEAST, "Plague Beast");
        this.addEntityAndEgg(RatsEntityRegistry.PLAGUE_CLOUD, "Plague Cloud");
        this.addEntityAndEgg(RatsEntityRegistry.PLAGUE_DOCTOR, "Plague Doctor");
        this.add("entity.rats.plague_rat", "Plagued Rat");
        this.addEntityAndEgg(RatsEntityRegistry.RAT, "Wild Rat");
        this.addEntityAndEgg(RatsEntityRegistry.RAT_KING, "Rat King");
        this.addEntityType((Supplier)RatsEntityRegistry.PLAGUE_SHOT, "Plague Shot");
        this.addEntityType((Supplier)RatsEntityRegistry.PURIFYING_LIQUID, "Purifying Liquid");
        this.addEntityType((Supplier)RatsEntityRegistry.RAT_ARROW, "Rat-Tipped Arrow");
        this.addEntityType((Supplier)RatsEntityRegistry.RAT_CAPTURE_NET, "Rapture Net");
        this.addEntityType((Supplier)RatsEntityRegistry.RAT_DRAGON_FIRE, "Rat Dragon Flames");
        this.addEntityType((Supplier)RatsEntityRegistry.RAT_MOUNT_BEAST, "Rat Beast Mount");
        this.addEntityType((Supplier)RatsEntityRegistry.RAT_MOUNT_CHICKEN, "Rat Chicken Mount");
        this.addEntityType((Supplier)RatsEntityRegistry.RAT_MOUNT_GOLEM, "Rat Golem Mount");
        this.addEntityType((Supplier)RatsEntityRegistry.RAT_STRIDER_MOUNT, "Rat Strider Mount");
        this.addEntityType((Supplier)RatsEntityRegistry.RAT_SHOT, "Thrown Rat");
        this.addEntityType((Supplier)RatsEntityRegistry.SMALL_ARROW, "Arrow");
        this.addEntityType((Supplier)RatsEntityRegistry.TAMED_RAT, "Rat");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.ARCHEOLOGIST_HAT, "Archeologist Hat", "Drops from Husks or skeletons in jungles");
        this.addItem((Supplier)RatsItemRegistry.ASSORTED_VEGETABLES, "Assorted Vegetables");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.BLACK_DEATH_MASK, "Black Death Mask", "Plague Rats will no longer target you when worn");
        this.addItem((Supplier)RatsItemRegistry.BLUE_CHEESE, "Blue Cheese");
        this.addItemWithJEIDesc((Supplier<Item>)RatsItemRegistry.CENTIPEDE, "Centipede", "Right click a Little Black Worm onto some coarse dirt to turn it into a Centipede.");
        this.addItem((Supplier)RatsItemRegistry.CHARGED_CREEPER_CHUNK, "Charged Creeper Chunk");
        this.addItemWithJEIDesc((Supplier<Item>)RatsItemRegistry.CHEESE, "Cheese", "Used to tame rats. Throw cheese on the ground and let the wild rat eat it to tame one.");
        this.addItemWithBothDescs((Supplier<Item>)RatsItemRegistry.CHEESE_STICK, "Cheese Staff", "Used to set rat deposit and pickup inventories and rat home points. Right click on a rat with it to bind, then right click on a block or container (chest, furnace, machine, etc) for more item transport related options.", "Use on a rat to bind it", "Interact with a block to allow the rat to deposit or pick up items in it");
        this.addItem((Supplier)RatsItemRegistry.CHEF_TOQUE, "Chef Toque");
        this.addItem((Supplier)RatsItemRegistry.CONFIT_BYALDI, "Confit Byaldi");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.CONTAMINATED_FOOD, "Contaminated Food", "A wild rodent has touched this food.", "Probably not a good idea to eat this.");
        this.addItem((Supplier)RatsItemRegistry.COOKED_RAT, "Cooked Rat");
        this.addItem((Supplier)RatsItemRegistry.CORRUPT_RAT_SKULL, "Corrupt Rat Skull");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.CREATIVE_CHEESE, "Creative Cheese", "Right click a rat to instantly tame it");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.CRIMSON_FLUID, "Crimson Liquid", "Transforms demon rats into normal rats");
        this.addItem((Supplier)RatsItemRegistry.DRAGON_WING, "Dragon Wing");
        this.addItem((Supplier)RatsItemRegistry.EXTERMINATOR_HAT, "Exterminator Hat");
        this.addItem((Supplier)RatsItemRegistry.FARMER_HAT, "Farmer Hat");
        this.addItem((Supplier)RatsItemRegistry.FEATHERY_WING, "Feathery Wing");
        this.addItem((Supplier)RatsItemRegistry.FILTH, "Filth");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.FILTH_CORRUPTION, "Ball of Filth", "Transforms a rat into a Rat King");
        this.addItem((Supplier)RatsItemRegistry.FISHERMAN_HAT, "Fisherman's Hat");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.GILDED_RAT_FLUTE, "Gilded Rat Flute", "Fires rats when used");
        this.addItem((Supplier)RatsItemRegistry.GOLDEN_RAT_SKULL, "Golden Rat Skull");
        this.addItem((Supplier)RatsItemRegistry.HALO_HAT, "Golden Halo");
        this.addItem((Supplier)RatsItemRegistry.HERB_BUNDLE, "Bundle of Sweet-Smelling Herbs");
        this.addItem((Supplier)RatsItemRegistry.LITTLE_BLACK_SQUASH_BALLS, "Little Black Squash Balls");
        this.addItem((Supplier)RatsItemRegistry.LITTLE_BLACK_WORM, "Little Black Worm");
        this.addMusicDisc((Supplier<Item>)RatsItemRegistry.MUSIC_DISC_LIVING_MICE, "C418 - Living Mice");
        this.addMusicDisc((Supplier<Item>)RatsItemRegistry.MUSIC_DISC_MICE_ON_VENUS, "C418 - Mice on Venus");
        this.addItem((Supplier)RatsItemRegistry.NETHER_CHEESE, "Nether Cheese");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.PARTY_HAT, "Party Hat", "Can be dyed any color");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.PATROL_STICK, "Patrol Staff", "Use on a rat to bind it", "Interact with a block to set it as part of a rat's patrol route");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.PIPER_HAT, "Piper Hat", "Wild rats will no longer fear you when worn");
        this.addItem((Supplier)RatsItemRegistry.PIRAT_HAT, "Pirat Hat");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.PLAGUE_DOCTOR_MASK, "Plague Doctor Mask", "Reduces chance of getting plague from rats on contact");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.PLAGUE_DOCTORATE, "Plague Doctorate", "Transforms a villager into a Plague Doctor");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.PLAGUE_ESSENCE, "Plague Essence", "Rare drop from Plague Rats");
        this.addItem((Supplier)RatsItemRegistry.PLAGUE_LEECH, "Plague Leech");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.PLAGUE_SCYTHE, "Black Death Scythe", "Summons Plague Clouds when swung");
        this.addItem((Supplier)RatsItemRegistry.PLAGUE_STEW, "Plague Stew");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.PLAGUE_TOME, "Plague Tome", "Very rare drop from Plague Rats", "Transforms a Plague Doctor into the Black Death");
        this.addItem((Supplier)RatsItemRegistry.PLASTIC_WASTE, "Plastic Waste");
        this.addItem((Supplier)RatsItemRegistry.POTATO_KNISHES, "Potato Knishes");
        this.addItem((Supplier)RatsItemRegistry.POTATO_PANCAKE, "Potato Pancake");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.PURIFYING_LIQUID, "Purifying Liquid", "Cures mobs with plague and zombie villagers");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RADIUS_STICK, "Rat Radius Staff", "Use on a rat to bind it", "Interact with a block to modify a rat's search and harvest range");
        this.addItem((Supplier)RatsItemRegistry.RAT_ARROW, "Rat on Arrow");
        this.addItem((Supplier)RatsItemRegistry.RAT_BREEDING_LANTERN, "Rat Breeding Lantern");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_BURGER, "Rat Burger", "\u00a7o\"Just don't ask them where the meat comes from.\"");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_CAPTURE_NET, "Rapture Net", "Rounds up all tamed rats within 16 blocks into one neat sack!");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_FEZ, "Rat Fez", "Standard Headwear of the Sec-rat society...", "\u00a7mDefinitely not throwing shade at another mod");
        this.addItemWithBothDescs((Supplier<Item>)RatsItemRegistry.RAT_FLUTE, "Rat Flute", "Used to command rats en-masse. Warning: will result in all nearby tamed rats to you stopping their task and following the set command. Shift + right-click to change the set command.", "Commands all tamed rats within the local area", "Sneak and right click to change selected command");
        for (int i = 0; i < DyeColor.values().length; ++i) {
            String dye = WordUtils.capitalize((String)DyeColor.m_41053_((int)i).m_41065_().replace('_', ' '));
            this.addItem((Supplier)RatsItemRegistry.RAT_HAMMOCKS[i], dye + " Rat Hammock");
            this.addItem((Supplier)RatsItemRegistry.RAT_IGLOOS[i], dye + " Rat Igloo");
            this.addItem((Supplier)RatsItemRegistry.RAT_TUBES[i], dye + " Rat Tube");
        }
        this.addItem((Supplier)RatsItemRegistry.RAT_KING_CROWN, "Rat King's Crown");
        this.addItem((Supplier)RatsItemRegistry.RAT_NUGGET, "Rat \u00a7o\"Nugget\"");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_NUGGET_ORE, "Rat \u00a7o\"Nugget\"", "Right click to find out what's inside...");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_PAPERS, "Rat Papers", "Used to transfer rats between owners", "Right click on rat to bind", "Right click on other player to give bounded rat to them");
        this.addItem((Supplier)RatsItemRegistry.RAT_PAW, "Rat Paw");
        this.addItem((Supplier)RatsItemRegistry.RAT_PELT, "Rat Pelt");
        this.addItem((Supplier)RatsItemRegistry.RAT_SACK, "Rat Sack");
        this.addItem((Supplier)RatsItemRegistry.RAT_SEED_BOWL, "Rat Seed Bowl");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_SKULL, "Rat Skull", "Rare drop from rats");
        this.addItem((Supplier)RatsItemRegistry.RAT_WATER_BOTTLE, "Rat Water Bottle");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_WHEEL, "Rat Wheel", "Rats will spin the wheel and generate power");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_WHISTLE, "Rat Whistle", "Sends all nearby tamed rats to their home position when applicable");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RATBOW_ESSENCE, "Ratbow Essence", "Dyes rats to a \"Rainbow\" color");
        this.addItem((Supplier)RatsItemRegistry.RAW_PLASTIC, "Raw Plastic");
        this.addItem((Supplier)RatsItemRegistry.RAW_RAT, "Raw Rat");
        this.addItem((Supplier)RatsItemRegistry.SANTA_HAT, "Santa Hat");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.STRING_CHEESE, "String Cheese", "\u00a7o\"A world without string is chaos.\"");
        this.addItem((Supplier)RatsItemRegistry.TANGLED_RAT_TAILS, "Tangled Rat Tails");
        this.addItem((Supplier)RatsItemRegistry.TINY_COIN, "Tiny Coin");
        this.addItem((Supplier)RatsItemRegistry.TOKEN_FRAGMENT, "Mysterious Token Fragment");
        this.addItem((Supplier)RatsItemRegistry.TOKEN_PIECE, "Mysterious Token Chunk");
        this.addItem((Supplier)RatsItemRegistry.TOP_HAT, "Top Hat");
        this.addItem((Supplier)RatsItemRegistry.TREACLE, "Old Treacle");
        this.addBannerPattern("rat", "Rat");
        this.addBannerPattern("cheese", "Cheese");
        this.addBannerPattern("rat_and_crossbones", "Rat and Crossbones");
        this.addItem((Supplier)RatsItemRegistry.RAT_UPGRADE_ADVANCED_ENERGY, "Rat Upgrade: Advanced Energy Transfer");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_ANGEL, "Rat Upgrade: Angel", "Rat respawns a minute after death", "When rat dies, its ghost will appear nearby", "Ghost will return to life within a minute");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_AQUATIC, "Rat Upgrade: Aquatic", "Rat gains scales and the ability to swim adeptly", "Rat can breathe underwater", "Pretty much turns rats into fish");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_ARISTOCRAT, "Rat Upgrade: Aristoc-RAT", "Rat drops Tiny Coins randomly or when killing enemies");
        this.addItem((Supplier)RatsItemRegistry.RAT_UPGRADE_ARMOR, "Rat Upgrade: Armor");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_ASBESTOS, "Rat Upgrade: Asbesto-Rat", "Rat will not take damage from:", " -Fire", " -Lava", " -Magma");
        this.addItemWithBothDescs((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_BASIC, "Rat Upgrade: Basic", "The most basic rat upgrade. While it has no effects in itself, it is a crafting ingredient required for advanced upgrades.", "Has no effects");
        this.addItem((Supplier)RatsItemRegistry.RAT_UPGRADE_BASIC_ENERGY, "Rat Upgrade: Basic Energy Transfer");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_BASIC_MOUNT, "Rat Upgrade: Basic Mount", "Has no effects");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_BEAST_MOUNT, "Rat Upgrade: Beast Mount", "\u00a76Mount Upgrade\u00a7r\u00a77: rat gains a rat beast mount", "Beast mount has 80 health and moves quickly");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_BEE, "Rat Upgrade: Bee", "Rat gains the power of flight", "Rat gains poisonous attack", "Rat will randomly cause crops and plants to grow");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_BIG_BUCKET, "Rat Upgrade: Mega-Bucket", "Rat will transfer fluids instead of items", "Rat will transfer 5000 mb at a time");
        this.addItemWithBothDescs((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_BLACKLIST, "Rat Upgrade: Blacklist", "Rats will only pickup or hold items that are not on this list. To access it, click the upgrade and deposit the blacklisted items inside.", "Rats will only pickup/transfer items that are not on this list", "Right click to set items", "Contains:");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_BOTTLER, "Rat Upgrade: Bottler", "Rat will pick up water or honey from nearby blocks when holding glass bottles and is set to the 'Harvest' command");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_BOW, "Rat Upgrade: Bow", "Rats uses a bow in combat");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_BREEDER, "Rat Upgrade: Breeder", "Rats will use any held food to breed animals when set to the 'Harvest' command");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_BUCKET, "Rat Upgrade: Bucket", "Rat will transfer fluids instead of items", "Rat will transfer 1000 mb at a time");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_CARRAT, "Rat Upgrade: Carrat", "Right click rat when hungry to eat! (does not harm the rat)");
        this.addItemWithBothDescs((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_CHEF, "Rat Upgrade: Chef", "Rats with the chef upgrade will cook any held item. Once the item is cooked, they will either try and drop it in an inventory below them, or simply throw it on the ground. This upgrade also gives the rat the skill set required to make a few select delicacies.", "Rat will cook held items", "\u00a7bUnlocks Special ability: Confit Byaldi");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_CHICKEN_MOUNT, "Rat Upgrade: Chicken Mount", "\u00a76Mount Upgrade\u00a7r\u00a77: rat gains a chicken mount", "Chicken mount moves quickly");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_CHRISTMAS, "Rat Upgrade: Festive", "\u00a7o\"Ho Ho Ho! Merry Christmas!\"", "Rat will gift a random present every hour", "Rat will hold gift or put it in chest below");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_COMBINED, "Rat Upgrade: Combined", "Combination of the following upgrades:");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_COMBINED_CREATIVE, "Rat Upgrade: Combined (Creative)", "\u00a7dRight click to add components");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_CRAFTING, "Rat Upgrade: Crafting", "Rat will process crafting recipes while sitting on Rat Crafting Table", "\u00a7bUnlocks Special ability: Rat Crafting Table");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_CREATIVE, "Rat Upgrade: Creative", "Rat cannot take damage except from owner");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_CROSSBOW, "Rat Upgrade: Crossbow", "Rats uses a crossbow in combat", "Crossbow is slower than bow, but has higher damage");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION, "Rat Upgrade: Damage Protection", "Rat will not take damage from:", " -Fire, Lava, Magma damage", " -Poison, Magic, Wither damage", " -Suffocation, Drowning, Fall damage");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_DEMON, "Rat Upgrade: Demon", "Rats is lava and fire proof", "Rats will ignite enemies");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_DISENCHANTER, "Rat Upgrade: Disenchanter", "Rat will disenchant any enchanted held item");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_DJ, "Rat Upgrade: DJ", "Rat will play held record");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_DRAGON, "Rat Upgrade: Dragon", "Rat can fly and breathe fire", "Rat will not take fire damage");
        this.addItem((Supplier)RatsItemRegistry.RAT_UPGRADE_ELITE_ENERGY, "Rat Upgrade: Elite Energy Transfer");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_ENCHANTER, "Rat Upgrade: Enchanter", "Rat will enchant any held item", "Nearby bookshelves help improve level");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_ENDER, "Rat Upgrade: Ender", "Rats gain the ability to teleport at will", "Allows extremely fast rat transport", "Turns rats black with glowing purple eyes");
        this.addItem((Supplier)RatsItemRegistry.RAT_UPGRADE_EXTREME_ENERGY, "Rat Upgrade: Extreme Energy Transfer");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_FARMER, "Rat Upgrade: Planter", "Rats will plant any held seeds or saplings when set to the 'Harvest' command", "Rats will use bonemeal on crops and saplings as well");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_FISHERMAN, "Rat Upgrade: Fisherman", "Rats will move to water sources and start fishing", "Rats can catch fish, junk and treasure items");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_FLIGHT, "Rat Upgrade: Flight", "Rats gain the ability to flap rudimentary wings and fly", "Rats will move faster while flying and will not be bound the the constraints of land based travel", "Pretty much turns rats into pigeons");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_GARDENER, "Rat Upgrade: Gardener", "Rats will break nearby tall grass and flowers when set to the 'Harvest' command");
        this.addItem((Supplier)RatsItemRegistry.RAT_UPGRADE_GOD, "Rat Upgrade: Battle-God");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_GOLEM_MOUNT, "Rat Upgrade: Golem Mount", "\u00a76Mount Upgrade\u00a7r\u00a77: rat gains a golem mount", "Golem mount has 100 health");
        this.addItem((Supplier)RatsItemRegistry.RAT_UPGRADE_HEALTH, "Rat Upgrade: Health");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_IDOL, "Rat Upgrade: Idol", "Rat gains golden appearance", "Piglins will not target or attack this rat nor will they target you if the rat is sitting on you");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_JURY_RIGGED, "Rat Upgrade: Jury-Rigged", "Combine two rat upgrades", "Combined upgrades cannot be edited or removed");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_LUMBERJACK, "Rat Upgrade: Lumberjack", "Rats will fell trees when set to the 'Harvest' command", "If a rat has the 'Replanter' upgrade, it will plant saplings back where the tree used to be");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_MILKER, "Rat Upgrade: Milkmaid", "Rat will milk cows when set to Harvest", "Rat will transfer fluids instead of items", "Rat will transfer 1000 mb at a time");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_MOB_FILTER, "Rat Upgrade: Mob Filter", "Rats will only target mobs that are on this list", "Right click to open selection GUI");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_NO_FLUTE, "Rat Upgrade: Flute Denier", "Rat will not listen to flute commands");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING, "Rat Upgrade: Ore Doubling", "Rat will eat ore blocks and create \u00a7o\"nuggets\"", "\u00a7o\"nuggets\"\u00a7r\u00a77 can then be right clicked for associated ore item", "Rat will not deposit any held ore block into chest, will eat it instead", "Easy to automate");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_PICKPOCKET, "Rat Upgrade: Pickpocket", "Rats will randomly take one of a Villager's trade results when set to the 'Harvest' command.", "Pickpocketing will sometimes result in your reputation going down or Iron Golems targeting your rat");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_PLACER, "Rat Upgrade: Block Placer", "Rats will place any held blocks when set to the 'Harvest' command", "Rats will place blocks at its 'Home' Position");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_PLATTER, "Rat Upgrade: Platter", "\u00a7bRat will transfer entire stacks of items at a time");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_POISON, "Rat Upgrade: Poison Resistance", "Rat will not take damage from:", " -Poison", " -Magic", " -Wither");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_QUARRY, "Rat Upgrade: Quarry", "Rats digs a quarry when set to 'Harvest' command", "Set rat to deposit in Rat Quarry block");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_REMEDY, "Rat Upgrade: Natural Remedy", "Rat is able to heal itself over time");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_REPLANTER, "Rat Upgrade: Replanter", "Rat does not destroy crops when harvesting them");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_SCULKED, "Rat Upgrade: Sculked", "Rat gains sculk-like appearance", "Rats will emit no vibrations when performing tasks and cannot be detected by Wardens");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_SHEARS, "Rat Upgrade: Shears", "Rat will shear sheep, mooshrooms, etc. when set to 'Harvest' command", "Rats will collect honeycomb from nearby bee nests and hives");
        this.addItem((Supplier)RatsItemRegistry.RAT_UPGRADE_SPEED, "Rat Upgrade: Speed");
        this.addItem((Supplier)RatsItemRegistry.RAT_UPGRADE_STRENGTH, "Rat Upgrade: Strength");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_STRIDER_MOUNT, "Rat Upgrade: Strider Mount", "\u00a76Mount Upgrade\u00a7r\u00a77: rat gains a strider mount", "Strider mount has 20 health and can walk on lava");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_SUPPORT, "Rat Upgrade: Supporter", "Rat will throw healing potions when your health is low", "Rat may occasionally throw other potion buffs if you have full health");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_TICK_ACCELERATOR, "Rat Upgrade: Tick Accele-RAT-or", "Rat will slightly increase tick speed of any block it stands over or under", "Includes crops and machines");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_TIME_MANIPULATOR, "Rat Upgrade: Time Manipu-Rat-or", "Rat will greatly increase tick speed of any block in a 5x3x5 area around it", "Includes crops and machines");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_TNT, "Rat Upgrade: TNT", "Rat will explode upon attacking", "May kill rat and injure any nearby entities");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_TNT_SURVIVOR, "Rat Upgrade: TNT Expert", "Rat will explode upon attacking", "Will not damage rat or allies directly", "Rat will not take damage from explosions or falling");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_UNDEAD, "Rat Upgrade: Undead", "Rat gains skeletal appearance", "Rat cannot be targeted by monsters");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_UNDERWATER, "Rat Upgrade: Extra Breath", "Rat will not take damage from:", " -Suffocation", " -Drowning");
        this.addItemWithDesc((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_VOODOO, "Rat Upgrade: Voodoo", "Rat takes damage instead of its owner, only when within a certain distance", "Damage is evenly distributed amongst multiple rats with this upgrade");
        this.addItem((Supplier)RatsItemRegistry.RAT_UPGRADE_WARRIOR, "Rat Upgrade: Warrior");
        this.addItemWithBothDescs((Supplier<Item>)RatsItemRegistry.RAT_UPGRADE_WHITELIST, "Rat Upgrade: Whitelist", "Rats will only pickup or hold items that are on this list. To access it, click the upgrade and deposit the whitelisted items inside.", "Rats will only pickup/transfer items that are on this list", "Right click to set items", "Contains:");
        this.addSubtitle(RatsSoundRegistry.AIR_RAID_SIREN, "Air-Raid Siren wails");
        this.addSubtitle(RatsSoundRegistry.BIPLANE_DEATH, "Biplane breaks down");
        this.addSubtitle(RatsSoundRegistry.BIPLANE_HURT, "Biplane cracks");
        this.addSubtitle(RatsSoundRegistry.BIPLANE_LOOP, "Biplane buzzes");
        this.addSubtitle(RatsSoundRegistry.BIPLANE_SHOOT, "Biplane fires");
        this.addSubtitle(RatsSoundRegistry.BLACK_DEATH_IDLE, "Black Death rasps");
        this.addSubtitle(RatsSoundRegistry.BLACK_DEATH_DIE, "Black Death dissipates");
        this.addSubtitle(RatsSoundRegistry.BLACK_DEATH_HURT, "Black Death screams");
        this.addSubtitle(RatsSoundRegistry.BLACK_DEATH_SUMMON, "Plague Doctor transforms");
        this.addSubtitle(RatsSoundRegistry.BLUE_CHEESE_MADE, "Cheese molds");
        this.addSubtitle(RatsSoundRegistry.CHEESE_MADE, "Milk Curdles");
        this.addSubtitle(RatsSoundRegistry.CHEESE_CAULDRON_EMPTY, "Cauldron empties");
        this.addSubtitle(RatsSoundRegistry.NETHER_CHEESE_MADE, "Cheese burns");
        this.addSubtitle(RatsSoundRegistry.DUTCHRAT_IDLE, "Flying Dutchrat Laughs");
        this.addSubtitle(RatsSoundRegistry.DUTCHRAT_DIE, "Flying Dutchrat croaks");
        this.addSubtitle(RatsSoundRegistry.DUTCHRAT_HURT, "Flying Dutchrat groans");
        this.addSubtitle(RatsSoundRegistry.DUTCHRAT_LAUGH, "Flying Dutchrat bellows");
        this.addSubtitle(RatsSoundRegistry.DUTCHRAT_BELL, "Flying Dutchrat Bell rings");
        this.addSubtitle(RatsSoundRegistry.DYE_SPONGE_USED, "Dye removed");
        this.addSubtitle(RatsSoundRegistry.LASER, "Laser shoots");
        this.addSubtitle(RatsSoundRegistry.NEORATLANTEAN_IDLE, "Neo-Ratlantean buzzes");
        this.addSubtitle(RatsSoundRegistry.NEORATLANTEAN_DIE, "Neo-Ratlantean dies");
        this.addSubtitle(RatsSoundRegistry.NEORATLANTEAN_HURT, "Neo-Ratlantean hurts");
        this.addSubtitle(RatsSoundRegistry.NEORATLANTEAN_LOOP, "Neo-Ratlantean hums");
        this.addSubtitle(RatsSoundRegistry.NEORATLANTEAN_SUMMON, "Neo-Ratlantean summoned");
        this.addSubtitle(RatsSoundRegistry.PIED_PIPER_DEATH, "Pied Piper dies");
        this.addSubtitle(RatsSoundRegistry.PIED_PIPER_HURT, "Pied Piper hurts");
        this.addSubtitle(RatsSoundRegistry.PIPER_LOOP, "Pied Piper plays flute");
        this.addSubtitle(RatsSoundRegistry.PIRAT_SHOOT, "Pirat Cannon fires");
        this.addSubtitle(RatsSoundRegistry.PLAGUE_CLOUD_DEATH, "Plague Cloud dies");
        this.addSubtitle(RatsSoundRegistry.PLAGUE_CLOUD_HURT, "Plague Cloud hurts");
        this.addSubtitle(RatsSoundRegistry.PLAGUE_CLOUD_SHOOT, "Plague Scythe spreads plague");
        this.addSubtitle(RatsSoundRegistry.PLAGUE_DOCTOR_DISAPPEAR, "Plague Doctor vanishes");
        this.addSubtitle(RatsSoundRegistry.PLAGUE_DOCTOR_DRINK, "Plague Doctor gulps");
        this.addSubtitle(RatsSoundRegistry.PLAGUE_DOCTOR_DRINK_POTION, "Plague Doctor sips");
        this.addSubtitle(RatsSoundRegistry.PLAGUE_DOCTOR_REAPPEAR, "Plague Doctor reappears");
        this.addSubtitle(RatsSoundRegistry.PLAGUE_DOCTOR_SUMMON, "Villager transforms");
        this.addSubtitle(RatsSoundRegistry.PLAGUE_DOCTOR_THROW, "Plague Doctor throws vial");
        this.addSubtitle(RatsSoundRegistry.PLAGUE_SPREAD, "Plague spreads");
        this.addSubtitle(RatsSoundRegistry.POTION_EFFECT_BEGIN, "Nostalgia starts");
        this.addSubtitle(RatsSoundRegistry.POTION_EFFECT_END, "Nostalgia fades");
        this.addSubtitle(RatsSoundRegistry.RAT_IDLE, "Rat squeaks");
        this.addSubtitle(RatsSoundRegistry.RAT_MAKE_COIN, "Rat drops coin");
        this.addSubtitle(RatsSoundRegistry.RAT_CRAFT, "Rat crafts");
        this.addSubtitle(RatsSoundRegistry.RAT_DIE, "Rat dies");
        this.addSubtitle(RatsSoundRegistry.RAT_DIG, "Rat scratches");
        this.addSubtitle(RatsSoundRegistry.RAT_DRINK, "Rat drinks");
        this.addSubtitle(RatsSoundRegistry.RAT_EAT, "Rat eats");
        this.addSubtitle(RatsSoundRegistry.RAT_GROWL, "Plague Rat screeches");
        this.addSubtitle(RatsSoundRegistry.RAT_HURT, "Rat squeaks in pain");
        this.addSubtitle(RatsSoundRegistry.RAT_POOP, "Rat farts");
        this.addSubtitle(RatsSoundRegistry.RAT_PIRATE, "Rat aaarrrs");
        this.addSubtitle(RatsSoundRegistry.RAT_SANTA, "Rat bellows");
        this.addSubtitle(RatsSoundRegistry.RAT_SHOOT, "Rat shoots fire");
        this.addSubtitle(RatsSoundRegistry.RAT_TELEPORT, "Rat teleports");
        this.addSubtitle(RatsSoundRegistry.RAT_TRANSFER, "Rat changes owner");
        this.addSubtitle(RatsSoundRegistry.RAT_BEAST_GROWL, "Rat Beast growls");
        this.add("subtitles.rats.item.rat_flute", "Rat Flute blows");
        this.addSubtitle(RatsSoundRegistry.RAT_KING_SHOOT, "Rat King throws rat");
        this.addSubtitle(RatsSoundRegistry.RAT_KING_SUMMON, "Rat gets dirty");
        this.addSubtitle(RatsSoundRegistry.RAT_NET_THROW, "Rapture Net thrown");
        this.addSubtitle(RatsSoundRegistry.RAT_NUGGET_ORE, "Rat Nugget yields treasure");
        this.addSubtitle(RatsSoundRegistry.RAT_TRAP_ADD_BAIT, "Rat Trap bait placed");
        this.addSubtitle(RatsSoundRegistry.RAT_TRAP_CLOSE, "Rat Trap slams shut");
        this.addSubtitle(RatsSoundRegistry.RAT_TRAP_OPEN, "Rat Trap opens");
        this.addSubtitle(RatsSoundRegistry.RAT_TRAP_REMOVE_BAIT, "Rat Trap bait removed");
        this.addSubtitle(RatsSoundRegistry.RAT_WHISTLE, "Rat Whistle Tweets");
        this.addSubtitle(RatsSoundRegistry.ESSENCE_APPLIED, "Rat gets dyed");
        this.addSubtitle(RatsSoundRegistry.RATFISH_DEATH, "Ratfish dies");
        this.addSubtitle(RatsSoundRegistry.RATFISH_FLOP, "Ratfish flops");
        this.addSubtitle(RatsSoundRegistry.RATFISH_HURT, "Ratfish hurts");
        this.addSubtitle(RatsSoundRegistry.RATLANTEAN_AUTOMATON_IDLE, "Ratlantean Automaton bellows");
        this.addSubtitle(RatsSoundRegistry.RATLANTEAN_AUTOMATON_DIE, "Ratlantean Automaton dies");
        this.addSubtitle(RatsSoundRegistry.RATLANTEAN_AUTOMATON_HURT, "Ratlantean Automaton damages");
        this.addSubtitle(RatsSoundRegistry.RATLANTEAN_FLAME_SHOOT, "Ratlantean Flame shoots");
        this.addSubtitle(RatsSoundRegistry.RATLANTEAN_RATBOT_IDLE, "Ratlantean Ratbot beeps");
        this.addSubtitle(RatsSoundRegistry.RATBOT_DEATH, "Ratlantean Ratbot dies");
        this.addSubtitle(RatsSoundRegistry.RATBOT_HURT, "Ratlantean Ratbot hurts");
        this.addSubtitle(RatsSoundRegistry.RATLANTEAN_SPIRIT_IDLE, "Ratlantean Spirit wails");
        this.addSubtitle(RatsSoundRegistry.RATLANTEAN_SPIRIT_DIE, "Ratlantean Spirit dies");
        this.addSubtitle(RatsSoundRegistry.RATLANTEAN_SPIRIT_HURT, "Ratlantean Spirit hurts");
        this.addSubtitle(RatsSoundRegistry.RATTLING_GUN_SHOOT, "Rattling Gun fires");
        this.addSubtitle(RatsSoundRegistry.SAPLING_TRANSFORM, "Sapling transforms");
        this.addSubtitle(RatsSoundRegistry.TRASH_CAN_EMPTY, "Trash Can empties");
        this.addSubtitle(RatsSoundRegistry.TRASH_CAN_FILL, "Trash Can fills");
        this.addSubtitle(RatsSoundRegistry.TRASH_CAN, "Trash Can lid swings");
        this.add("container.rats.auto_curdler", "Curdling Station");
        this.add("container.rats.auto_curdler.mb", "Mb");
        this.add("container.rats.rat_crafting_table", "Rat Crafting Table");
        this.add("container.rats.rat_crafting_table.input", "Input");
        this.add("container.rats.rat_crafting_table.requires_rat", "Requires a rat with a crafting upgrade above the table to function");
        this.add("container.rats.rat_quarry", "Rat Quarry");
        this.add("container.rats.upgrade_combiner", "Rat Upgrade Combiner");
        this.add("container.rats.rat_upgrade_combiner.cannot_combine", "Cannot combine these upgrades");
        this.add("gui.rats.mob_filter", "Mob Filter");
        this.add("gui.rats.mob_filter.whitelist", "Toggle Whitelist");
        this.add("gui.rats.mob_filter.selected_mobs", "Show Selected Mobs");
        this.add("gui.rats.jei.archeologist", "Archeologist Rat");
        this.add("gui.rats.jei.cheesemaking", "Cheesemaking");
        this.add("gui.rats.jei.chef", "Chef Rat");
        this.add("item.rats.staff.bind", "Staff is now bound to %s");
        this.add("item.rats.staff.no_rat", "Staff is not bound to any rat");
        this.add("item.rats.cheese_staff.mark_deposit", "Deposit items in %s from the %s");
        this.add("item.rats.cheese_staff.mark_pickup", "Take items from %s");
        this.add("item.rats.cheese_staff.mark_home", "Set home point for rat to %s");
        this.add("item.rats.cheese_staff.unmark_transport", "Reset rat transport positions");
        this.add("item.rats.cheese_staff.unmark_home", "Reset rat home point");
        this.add("item.rats.radius_staff.radius", "Radius: %s");
        this.add("item.rats.radius_staff.reset_radius", "Reset Radius");
        this.add("item.rats.radius_staff.set_radius", "Set rat radius origin to %s");
        this.add("item.rats.patrol_staff.add_node", "Add patrol node at %s");
        this.add("item.rats.patrol_staff.remove_node", "Remove patrol node at %s");
        this.add("item.rats.patrol_staff.remove_nodes", "Remove all patrol nodes");
        this.add("entity.rats.rat.current_command", "Current Command:");
        this.add("entity.rats.rat.command_set", "Set Command:");
        this.add("entity.rats.rat.command.wander", "Wander");
        this.add("entity.rats.rat.command.wander.desc", "The rat will move around similar to wild behavior.");
        this.add("entity.rats.rat.command.sit", "Stay Here");
        this.add("entity.rats.rat.command.sit.desc", "The rat will sit down and not move.");
        this.add("entity.rats.rat.command.follow", "Follow Me");
        this.add("entity.rats.rat.command.follow.desc", "The rat will follow its owner.");
        this.add("entity.rats.rat.command.hunt", "Hunt Mobs");
        this.add("entity.rats.rat.command.hunt.desc", "When given a Mob Filter upgrade, the rat will kill all mobs it lists. The rat will also place their remains in a deposit container, if assigned one. Use the \u00a76Cheese Staff\u00a7r to set a deposit inventory.");
        this.add("entity.rats.rat.command.gather", "Gather Items");
        this.add("entity.rats.rat.command.gather.desc", "The rat will search the area for dropped items (craft whitelist or blacklist upgrades to limit what they pick up). You can use a \u00a76Cheese Staff\u00a7r to set a deposit inventory.");
        this.add("entity.rats.rat.command.harvest", "Harvest");
        this.add("entity.rats.rat.command.harvest.desc", "The rat will search for mature crops nearby to harvest. You can use a \u00a76Cheese Staff\u00a7r to set a deposit inventory where it will drop off any crops it collects. Many upgrades will repurpose this command to allow rats to perform various jobs, such as chopping down trees or breeding animals.");
        this.add("entity.rats.rat.command.transport", "Transport Items");
        this.add("entity.rats.rat.command.transport.desc", "Interacting with a rat with a \u00a76Cheese Staff\u00a7r will bind it to the rat. Clicking on a block with an inventory will open a GUI to mark that inventory for the rat to take from/deposit items into. Once the rat has a marked deposit inventory and pickup inventory, it will transport items from one to the other.");
        this.add("entity.rats.rat.command.patrol", "Patrol");
        this.add("entity.rats.rat.command.patrol.desc", "The rat will patrol a set path and fight any monsters it encounters. Right-click the rat with a \u00a76Patrol Staff\u00a7r to bind it and right-click any blocks with the staff to add points to patrol along.");
        this.add("block.rats.rat_cage.deposit", "Deposited %s Rat(s) in cage");
        this.add("block.rats.rat_cage.withdraw", "Released %s Rat(s) from cage");
        this.add("item.rats.cage_decoration.desc", "Rat Cage decoration");
        this.add("item.rats.cheese_staff.bound_rat", "Selected Rat: %s (%s)");
        this.add("item.rats.plague_heal_chance", "Has a %s percent chance to remove plague effect");
        this.add("item.rats.rat_flute.command_changed", "Changed command to: %s");
        this.add("item.rats.rat_flute.rat_count", "Commanded %s rats");
        this.add("item.rats.rat_papers.bound_rat", "Bound Rat: %s");
        this.add("rats.and_more", "... and %s more");
        this.add("item.rats.rat_sack.contains", "Contains %s/%s rat(s)");
        this.add("item.rats.rat_sack.release", "Released %s Rat(s) from sack");
        this.add("item.rats.rat_sack.too_full", "Rat Sack can't hold any more rats!");
        this.add("item.rats.ore_nugget.contains", "Contained Resource: %s");
        this.add("item.rats.rat_upgrade.regenerates_health", "Regenerates Health");
        this.add("item.rats.rat_upgrade.stat_boost", "+%s Rat %s");
        this.add("item.rats.rat_upgrade_mount.respawn_desc", "Cooldown on mount respawning when slain");
        this.add("item.rats.rat_upgrade.energy_desc0", "Rat will transfer energy instead of items");
        this.add("item.rats.rat_upgrade.energy_desc1", "Works with RF and RE");
        this.add("item.rats.rat_upgrade.energy_transfer_rate", "Max transfer rate: %s RF");
        this.add("item.rats.rat_upgrade.energy_charge_rate", "Item charge per tick: %s RF");
        this.add("item.rats.rat_upgrade_mob_filter.blacklist", "Blacklist");
        this.add("item.rats.rat_upgrade_mob_filter.mode", "Mode: %s");
        this.add("item.rats.rat_upgrade_mob_filter.selected_mobs", "Selected Mobs:");
        this.add("item.rats.rat_upgrade_mob_filter.whitelist", "Whitelist");
        this.add("item.rats.ratlantis_armor.desc0", "Protector of Ratlantis");
        this.add("item.rats.ratlantis_armor.desc1", "A spectral rat will protect you at all times, and keep enemies at bay.");
        this.add("item.rats.ratlantis_armor.desc2", "Effect stacks for all pieces of armor.");
        this.add("item.rats.ratlantis_disabled.desc0", "Ratlantis content is disabled in this world.");
        this.add("item.rats.ratlantis_disabled.desc1", "None of the items, blocks, or entities from ratlantis can be obtained legitimately in survival.");
        this.add("item.rats.ratlantis_disabled.desc2", "If you would like to have Ratlantis related content in your world make sure to enable the builtin datapack on world creation or turn the 'ratlantisEnabledByDefault' config option to true.");
        this.addEffect((Supplier)RatsEffectRegistry.PLAGUE, "Plague");
        this.addEffect((Supplier)RatsEffectRegistry.SYNESTHESIA, "Synesthesia");
        this.add("gamerule.doPiperSpawning", "Spawn Pied Pipers");
        this.add("gamerule.doPlagueDoctorSpawning", "Spawn Wandering Plague Doctors");
        this.add("gamerule.doRatSpawning", "Spawn Wild Rats");
        this.add("entity.minecraft.villager.rats.pet_shop_owner", "Pet Shop Owner");
        this.add("itemGroup.rats.rats", "Rats");
        this.add("itemGroup.rats.upgrades", "Rat Upgrades");
        this.add("itemGroup.rats.ratlantis", "Ratlantis");
        this.add("entity.rats.rat.respawn_angel", "%s respawned as an angel");
        this.add("entity.rats.rat.dismount", "Sneak and punch air to remove rats from shoulder");
        this.add("entity.rats.rat.griefing", "NOTICE: this world has Mob Griefing turned off. Rats may not work as expected! Tamed rats will not be able to perform many tasks you would normally expect them to because of this.\\nTo fix this, all you need to do is enable the mob griefing gamerule.\\nThis message will not appear again.");
        this.add("rats.direction.down", "bottom");
        this.add("rats.direction.east", "east");
        this.add("rats.direction.north", "north");
        this.add("rats.direction.south", "south");
        this.add("rats.direction.up", "top");
        this.add("rats.direction.west", "west");
        this.add("entity.rats.dutchrat.daytime", "The Flying Dutchrat can only manifest at night");
        this.add("entity.rats.ratlantean_automaton.ratlantis", "This machine cannot properly function in this world");
        this.add("entity.rats.dutchrat.ratlantis", "The Flying Dutchrat is unable to manifest in this world");
        this.add("entity.rats.rat_baron.ratlantis", "The siren is unable to bring forth anyone from this world");
        this.add("entity.rats.neo_ratlantean.ratlantis", "The vial had no effect on this beast here");
        this.add("pack.rats.rats", "Rats default resources");
        this.add("pack.rats.ratlantis", "Enables Ratlantis and all Ratlantis related features");
        this.add("trim_material.rats.gem_of_ratlantis", "Gem of Ratlantis Material");
        this.add("trim_material.rats.oratchalcum", "Oratchalcum Material");
        this.addRatlantisAdvancement("root", "Ratlantis", "An Empire Lost");
        this.addRatlantisAdvancement("token", "What lottery? The lottery, that's what lottery! Are you stupid? Only lottery that matters! Oh my god smell that air!", "Obtain a Chunky Cheese Token from a rat! Good job!");
        this.addRatlantisAdvancement("ratlantis", "Ratlantis!", "Use Chunky Cheese Token anywhere to create a portal to Ratlantis. Enter through the portal!");
        this.addRatlantisAdvancement("rat_upgrade_archeologist", "Ulterior Motive", "Craft Rat Upgrade: Archeologist, enabling an alternative to Ratlantis");
        this.addRatlantisAdvancement("ratglove_petals", "Flower Power", "Craft Ratglove Petals from nine Ratglove Flowers");
        this.addRatlantisAdvancement("ratlantean_spirit", "Ashes of a Trillion Dead Souls", "Encounter the long dead ghost of a Ratlantean");
        this.addRatlantisAdvancement("feral_ratlantean", "Going Native", "Encounter what now remains of Ratlantis' once-noble denizens");
        this.addRatlantisAdvancement("gem_of_ratlantis", "Closer to Godliness", "Craft the Gem of Ratlantis from Ratglove Petals and Emeralds");
        this.addRatlantisAdvancement("marbled_cheese_golem_core", "We can Rebuild...", "Craft a Ratlantean Automaton Core! Now, place a Ratlantean Automaton Head on top and surround the core with Marbled Cheese!");
        this.addRatlantisAdvancement("marbled_cheese_golem", "Man(or Rat) vs Machine", "Kill a Ratlantean Automaton");
        this.addRatlantisAdvancement("rat_upgrade_ratinator", "Like Tears in the Rain", "Craft a Rat Upgrade: Ratinator, bringing a deadly rat cyborg to life");
        this.addRatlantisAdvancement("upgrade_combiner", "MAXIMUM POWER!!!", "Craft a Rat Upgrade Combiner, and start mixing upgrades together");
        this.addRatlantisAdvancement("vial_of_sentience", "The Risks I Took Were Calculated...", "Create a Vial of Consciousness with Ratlantean Spirit Flame and Feral Rat Claws. Make sure to throw it at a Feral Ratlantean!");
        this.addRatlantisAdvancement("neoratlantean", "But Man am I Bad at Math", "Kill the Neo-Ratlantean");
        this.addRatlantisAdvancement("rat_upgrade_psychic", "Not a USB Stick", "Craft a Rat Upgrade: Psychic, and have your very own psychic rat");
        this.addRatlantisAdvancement("pirat", "Are You Ready Kids?", "Encounter the Pirat, a swashbuckling, sea-faring rat");
        this.addRatlantisAdvancement("rat_upgrade_buccaneer", "Aye-Aye Captain!", "Craft a Rat Upgrade: Buccaneer, giving unnecessary 16th century firepower to a rat");
        this.addRatlantisAdvancement("rat_upgrade_nonbeliever", "Whats a God to a Nonbeliever?", "Craft a Rat Upgrade: Nonbeliever, the one rat upgrade to rule them all");
        this.addRatlantisAdvancement("ghost_pirat", "Shiver Me Timbers", "Encounter a Ghost Pirat, the cursed spirits of long dead sailors");
        this.addRatlantisAdvancement("dutchrat_wheel", "LEDLE LEDLE LEDLE LEEEE", "Defeat the Flying Dutchrat");
        this.addRatlantisAdvancement("ratlantean_ratbot", "The Stainless Steel Rat", "Encounter a Ratlantean Ratbot, a relic from a past age of automation");
        this.addRatlantisAdvancement("oratchalcum_ingot", "Feel The Power!", "Obtain an Oratchalcum Ingot");
        this.addRatlantisAdvancement("ratlantis_armor", "The Gilded God!", "Obtain an the entire Ratlantis armor set");
        this.addRatlantisAdvancement("defeat_rat_baron", "Death or Glory", "Defeat the Rat Baron");
        this.addRatlantisAdvancement("rat_upgrade_mount_biplane", "How-Rat Hughes", "Craft a Rat Upgrade: Biplane Mount and get your very own Rat Flying Ace");
        this.add((Block)RatlantisBlockRegistry.AIR_RAID_SIREN.get(), "Air-Raid Siren");
        this.add((Block)RatlantisBlockRegistry.BLACK_MARBLED_CHEESE.get(), "Black Marbled Cheese");
        this.add((Block)RatlantisBlockRegistry.BRAIN_BLOCK.get(), "Brain Block");
        this.add((Block)RatlantisBlockRegistry.CHEESE_ORE.get(), "Cheese Ore");
        this.addBlockWithDesc((Supplier<Block>)RatlantisBlockRegistry.CHUNKY_CHEESE_TOKEN, "Chunky Cheese Token", "EXTREMELY rare drop rate from rat", "Right click anywhere to open a portal to Ratlantis");
        this.addBlockWithDesc((Supplier<Block>)RatlantisBlockRegistry.COMPRESSED_RAT, "Block of Ratglove", "\u00a7o\"In times like these we are thankful, but we must temper our thirst for our pursuit bears wondrous fruit, some ideas must rot where they fall.\"");
        this.add((Block)RatlantisBlockRegistry.DUTCHRAT_BELL.get(), "Flying Dutchrat's Bell");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE.get(), "Marbled Cheese");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_SLAB.get(), "Marbled Cheese Slab");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_STAIRS.get(), "Marbled Cheese Stairs");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK.get(), "Marbled Cheese Brick");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_SLAB.get(), "Marbled Cheese Brick Slab");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_STAIRS.get(), "Marbled Cheese Brick Stairs");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED.get(), "Cracked Marbled Cheese Brick");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED_SLAB.get(), "Cracked Marbled Cheese Brick Slab");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED_STAIRS.get(), "Cracked Marbled Cheese Brick Stairs");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY.get(), "Mossy Marbled Cheese Brick");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY_SLAB.get(), "Mossy Marbled Cheese Brick Slab");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY_STAIRS.get(), "Mossy Marbled Cheese Brick Stairs");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_CHISELED.get(), "Chiseled Marbled Cheese");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CHISELED.get(), "Chiseled Marbled Cheese Brick");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_PILLAR.get(), "Marbled Cheese Pillar");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_TILE.get(), "Marbled Cheese Tile");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_DIRT.get(), "Marbled Cheese Dirt");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_GRASS.get(), "Marbled Cheese Grass");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_GOLEM_CORE.get(), "Ratlantean Automaton Core");
        this.add((Block)RatlantisBlockRegistry.MARBLED_CHEESE_RAT_HEAD.get(), "Ratlantean Automaton Head");
        this.add((Block)RatlantisBlockRegistry.ORATCHALCUM_BLOCK.get(), "Block of Oratchalcum");
        this.add((Block)RatlantisBlockRegistry.ORATCHALCUM_ORE.get(), "Oratchalcum Ore");
        this.createWoodSet("pirat", "Ghost Pirat");
        this.add((Block)RatlantisBlockRegistry.POTTED_RATGLOVE_FLOWER.get(), "Potted Ratglove Flower");
        this.add((Block)RatlantisBlockRegistry.RATGLOVE_FLOWER.get(), "Ratglove Flower");
        this.add((Block)RatlantisBlockRegistry.RATLANTEAN_GEM_ORE.get(), "Ratlantean Gem Ore");
        this.add((Block)RatlantisBlockRegistry.RATLANTIS_PORTAL.get(), "Ratlantis Portal");
        this.add((Block)RatlantisBlockRegistry.RATLANTIS_REACTOR.get(), "Ratlantis Reactor");
        this.add((Block)RatlantisBlockRegistry.RATLANTIS_UPGRADE_BLOCK.get(), "Ratlantean Upgrade Block");
        this.addEntityAndEgg(RatlantisEntityRegistry.DUTCHRAT, "Flying Dutchrat");
        this.addEntityAndEgg(RatlantisEntityRegistry.FERAL_RATLANTEAN, "Feral Ratlantean");
        this.addEntityAndEgg(RatlantisEntityRegistry.GHOST_PIRAT, "Ghost Pirat");
        this.addEntityAndEgg(RatlantisEntityRegistry.NEO_RATLANTEAN, "Neo-Ratlantean");
        this.addEntityAndEgg(RatlantisEntityRegistry.PIRAT, "Pirat");
        this.addEntityAndEgg(RatlantisEntityRegistry.RAT_BARON, "Rat Baron");
        this.addEntityAndEgg(RatlantisEntityRegistry.RATFISH, "Ratfish");
        this.addEntityAndEgg(RatlantisEntityRegistry.RATLANTEAN_AUTOMATON, "Ratlantean Automaton");
        this.addEntityAndEgg(RatlantisEntityRegistry.RATLANTEAN_RATBOT, "Ratlantean Ratbot");
        this.addEntityAndEgg(RatlantisEntityRegistry.RATLANTEAN_SPIRIT, "Ratlantean Spirit");
        this.addEntityType((Supplier)RatlantisEntityRegistry.BOAT, "Boat");
        this.addEntityType((Supplier)RatlantisEntityRegistry.CHEESE_CANNONBALL, "Cheese Cannonball");
        this.addEntityType((Supplier)RatlantisEntityRegistry.CHEST_BOAT, "Chest Boat");
        this.addEntityType((Supplier)RatlantisEntityRegistry.DUTCHRAT_SWORD, "Thrown Ghost Sword");
        this.addEntityType((Supplier)RatlantisEntityRegistry.LASER_BEAM, "Laser");
        this.addEntityType((Supplier)RatlantisEntityRegistry.LASER_PORTAL, "Telekinetic Portal");
        this.addEntityType((Supplier)RatlantisEntityRegistry.PIRAT_BOAT, "Pirat Boat");
        this.addEntityType((Supplier)RatlantisEntityRegistry.RAT_BARON_PLANE, "Rat Baron's Plane");
        this.addEntityType((Supplier)RatlantisEntityRegistry.RAT_MOUNT_AUTOMATON, "Rat Automaton Mount");
        this.addEntityType((Supplier)RatlantisEntityRegistry.RAT_MOUNT_BIPLANE, "Rat Biplane Mount");
        this.addEntityType((Supplier)RatlantisEntityRegistry.RAT_PROTECTOR, "Rat Ghost");
        this.addEntityType((Supplier)RatlantisEntityRegistry.RATLANTEAN_AUTOMATON_BEAM, "Laser");
        this.addEntityType((Supplier)RatlantisEntityRegistry.RATLANTEAN_FLAME, "Soul Flame");
        this.addEntityType((Supplier)RatlantisEntityRegistry.RATLANTIS_ARROW, "Arrow");
        this.addEntityType((Supplier)RatlantisEntityRegistry.RATTLING_GUN, "Rattling Gun");
        this.addEntityType((Supplier)RatlantisEntityRegistry.RATTLING_GUN_BULLET, "Bullet");
        this.addEntityType((Supplier)RatsEntityRegistry.THROWN_BLOCK, "Telekinetic Block");
        this.addEntityType((Supplier)RatlantisEntityRegistry.VIAL_OF_SENTIENCE, "Vial of Consciousness");
        this.addItem((Supplier)RatlantisItemRegistry.ANCIENT_SAWBLADE, "Ancient Sawblade");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.ARCANE_TECHNOLOGY, "Arcane Technology", "\u00a7o\"Any sufficiently advanced technology is indistinguishable from magic.\"", "Who knows what magnificent marvels the ancient civilization of Ratlantis created?");
        this.addItem((Supplier)RatlantisItemRegistry.AVIATOR_HAT, "Aviator Cap");
        this.addItem((Supplier)RatlantisItemRegistry.BIPLANE_WING, "Biplane Wing");
        this.addItem((Supplier)RatlantisItemRegistry.CHARGED_RATBOT_BARREL, "Charged Ratbot Barrel");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.CHEESE_CANNONBALL, "Cheese Cannonball", "Fired from a Pirat cannon");
        this.addItem((Supplier)RatlantisItemRegistry.DUTCHRAT_WHEEL, "Flying Dutchrat's Ship Wheel");
        this.addItem((Supplier)RatlantisItemRegistry.FERAL_BAGH_NAKHS, "Feral Ratlantean Bagh-Nakhs");
        this.addItem((Supplier)RatlantisItemRegistry.FERAL_RAT_CLAW, "Feral Rat Claw");
        this.addItem((Supplier)RatlantisItemRegistry.GEM_OF_RATLANTIS, "Gem of Ratlantis");
        this.addItem((Supplier)RatlantisItemRegistry.GHOST_PIRAT_CUTLASS, "Ghost Pirat Cutlass");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.GHOST_PIRAT_ECTOPLASM, "Ghost Pirat Ectoplasm", "Turns saplings incorporeal");
        this.addItem((Supplier)RatlantisItemRegistry.GHOST_PIRAT_HAT, "Ghost Pirat Hat");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.IDOL_OF_RATLANTIS, "Avatar of Ratlantis", "Power incarnate");
        this.addItem((Supplier)RatlantisItemRegistry.MILITARY_HAT, "Ratlantean Officer Hat");
        this.addItem((Supplier)RatlantisItemRegistry.ORATCHALCUM_INGOT, "Oratchalcum Ingot");
        this.addItem((Supplier)RatlantisItemRegistry.ORATCHALCUM_NUGGET, "Oratchalcum Nugget");
        this.addItem((Supplier)RatlantisItemRegistry.PIRAT_CUTLASS, "Pirat Cutlass");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.PSIONIC_RAT_BRAIN, "Psionic Rat Brain", "\u00a7o\"The inner machinations of my mind are an enigma.\"", "A powerful mind capable of tinkering with the very fabric of reality.");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RAT_TOGA, "Rat Toga", "Right click on a rat to equip it with a toga", "Right click it again with a toga to de-equip");
        this.addItem((Supplier)RatlantisItemRegistry.RATBOT_BARREL, "Ratbot Barrel");
        this.addItem((Supplier)RatlantisItemRegistry.RATFISH, "Ratfish");
        this.addItem((Supplier)RatlantisItemRegistry.RATFISH_BUCKET, "Bucket of Ratfish");
        this.addItem((Supplier)RatlantisItemRegistry.RATGLOVE_PETALS, "Ratglove Petals");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RATLANTEAN_FLAME, "Ratlantean Spirit Flame", "Imbued with the ancient souls of the Ratlanteans... and Cheese.");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RATLANTIS_AXE, "Axe of Ratlantis", "Ratlantean Leafbreaker", "Mining leaf blocks will not damage this tool.");
        this.addItem((Supplier)RatlantisItemRegistry.RATLANTIS_BOOTS, "Boots of Ratlantis");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RATLANTIS_BOW, "Bow of Ratlantis", "Ratlantean Quiver", "Fires stronger arrows twice as fast.");
        this.addItem((Supplier)RatlantisItemRegistry.RATLANTIS_CHESTPLATE, "Chestplate of Ratlantis");
        this.addItem((Supplier)RatlantisItemRegistry.RATLANTIS_HELMET, "Helmet of Ratlantis");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RATLANTIS_HOE, "Hoe of Ratlantis", "Bounty of Ratlantis", "Tills an additional 8 dirt blocks.");
        this.addItem((Supplier)RatlantisItemRegistry.RATLANTIS_LEGGINGS, "Leggings of Ratlantis");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RATLANTIS_PICKAXE, "Pickaxe of Ratlantis", "Ratlantean Caver", "Mining stone blocks will not damage this tool.");
        this.addItem((Supplier)RatlantisItemRegistry.RATLANTIS_RAT_SKULL, "Skull of Ratlantis");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RATLANTIS_SHOVEL, "Shovel of Ratlantis", "Ratlantean Earthmower", "Mining sand blocks will not damage this tool.");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RATLANTIS_SWORD, "Sword of Ratlantis", "Spectral Alliance", "Each attack summons a spectral rat that deals an additional 6 damage.");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RATTLING_GUN, "Rattling Gun", "Place a rat on the gunner's seat by right clicking with a rat on your shoulder");
        this.addItem((Supplier)RatlantisItemRegistry.RAW_ORATCHALCUM, "Raw Oratchalcum");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.VIAL_OF_SENTIENCE, "Vial of Consciousness", "A serum that can, \u00a7lin theory\u00a7r\u00a77, reverse the de-evolution of a Ratlantean.");
        this.addBannerPattern("rat_and_sickle", "Rat and Sickle");
        this.addItemWithBothDescs((Supplier<Item>)RatlantisItemRegistry.RAT_UPGRADE_ARCHEOLOGIST, "Rat Upgrade: Archeologist", "Rats with the archeologist upgrade will research their held item, trying to discover Ratlantean artifacts from it. Once an artifact is discovered, they will either try and drop it in an inventory below them, or simply throw it on the ground.", "Researches held item, transforms it into Ratlantean artifact if possible");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RAT_UPGRADE_AUTOMATON_MOUNT, "Rat Upgrade: Automaton Mount", "\u00a76Mount Upgrade\u00a7r\u00a77: rat gains an automaton mount", "Automaton mount has 250 health and moves slowly");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RAT_UPGRADE_BASIC_RATLANTEAN, "Rat Upgrade: Basic Ratlantean", "Has no effects");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RAT_UPGRADE_BIPLANE_MOUNT, "Rat Upgrade: Biplane Mount", "\u00a76Mount Upgrade\u00a7r\u00a77: rat gains a biplane mount", "Biplane mount has 300 health and can fly");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RAT_UPGRADE_BUCCANEER, "Rat Upgrade: Buccaneer", "Rat gains an automatic firing cannon", "\u00a7cCAUTION: EXPLOSIVE");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RAT_UPGRADE_ETHEREAL, "Rat Upgrade: Ethereal", "Rat can phase through blocks", "Rat can float through the air");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RAT_UPGRADE_FERAL_BITE, "Rat Upgrade: Feral Bite", "Rat attack deals 5 extra damage, inflicts plague and poison debuff");
        this.addItem((Supplier)RatlantisItemRegistry.RAT_UPGRADE_NONBELIEVER, "Rat Upgrade: Nonbeliever");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RAT_UPGRADE_PSYCHIC, "Rat Upgrade: Psychic", "Summons portals that attack targets");
        this.addItemWithDesc((Supplier<Item>)RatlantisItemRegistry.RAT_UPGRADE_RATINATOR, "Rat Upgrade: Ratinator", "Half Machine, Half Rodent.", "Fires lasers at targets");
        this.add("biome.rats.ratlantis", "Ratlantis");
        this.add("dimension.rats.ratlantis", "Ratlantis");
    }

    public void addMusicDisc(Supplier<Item> disc, String description) {
        this.addItem(disc, "Music Disc");
        this.add(disc.get().m_5524_() + ".desc", description);
    }

    public void addAdvancement(String key, String title, String desc) {
        this.add("advancement.rats." + key + ".title", title);
        this.add("advancement.rats." + key + ".desc", desc);
    }

    public void addBlockWithJEIDesc(Supplier<Block> block, String blockName, String jeiLine) {
        this.addBlock(block, blockName);
        this.add(block.get().m_7705_() + ".jei_desc", jeiLine);
    }

    public void addBlockWithDesc(Supplier<Block> block, String blockName, String ... descLines) {
        this.addBlock(block, blockName);
        if (descLines.length == 1) {
            this.add(block.get().m_7705_() + ".desc", descLines[0]);
        } else {
            for (int i = 0; i < descLines.length; ++i) {
                this.add(block.get().m_7705_() + ".desc" + i, descLines[i]);
            }
        }
    }

    public void addBlockWithBothDescs(Supplier<Block> block, String blockName, String jeiLine, String ... descLines) {
        this.addBlock(block, blockName);
        this.add(block.get().m_7705_() + ".jei_desc", jeiLine);
        if (descLines.length == 1) {
            this.add(block.get().m_7705_() + ".desc", descLines[0]);
        } else {
            for (int i = 0; i < descLines.length; ++i) {
                this.add(block.get().m_7705_() + ".desc" + i, descLines[i]);
            }
        }
    }

    public void addItemWithDesc(Supplier<Item> item, String itemName, String ... descLines) {
        this.addItem(item, itemName);
        if (descLines.length == 1) {
            this.add(item.get().m_5524_() + ".desc", descLines[0]);
        } else {
            for (int i = 0; i < descLines.length; ++i) {
                this.add(item.get().m_5524_() + ".desc" + i, descLines[i]);
            }
        }
    }

    public void addItemWithJEIDesc(Supplier<Item> item, String itemName, String jeiLine) {
        this.addItem(item, itemName);
        this.add(item.get().m_5524_() + ".jei_desc", jeiLine);
    }

    public void addItemWithBothDescs(Supplier<Item> item, String itemName, String jeiLine, String ... descLines) {
        this.addItem(item, itemName);
        this.add(item.get().m_5524_() + ".jei_desc", jeiLine);
        if (descLines.length == 1) {
            this.add(item.get().m_5524_() + ".desc", descLines[0]);
        } else {
            for (int i = 0; i < descLines.length; ++i) {
                this.add(item.get().m_5524_() + ".desc" + i, descLines[i]);
            }
        }
    }

    public void addRatlantisAdvancement(String key, String title, String desc) {
        this.add("advancement.ratlantis." + key + ".title", title);
        this.add("advancement.ratlantis." + key + ".desc", desc);
    }

    public void createWoodSet(String woodPrefix, String woodName) {
        this.add("block.rats.potted_" + woodPrefix + "_sapling", "Potted " + woodName + " Sapling");
        this.add("block.rats." + woodPrefix + "_sapling", woodName + " Sapling");
        this.add("block.rats." + woodPrefix + "_leaves", woodName + " Leaves");
        this.add("block.rats." + woodPrefix + "_log", woodName + " Log");
        this.add("block.rats." + woodPrefix + "_wood", woodName + " Wood");
        this.add("block.rats.stripped_" + woodPrefix + "_log", "Stripped " + woodName + " Log");
        this.add("block.rats.stripped_" + woodPrefix + "_wood", "Stripped " + woodName + " Wood");
        this.add("block.rats." + woodPrefix + "_planks", woodName + " Planks");
        this.add("block.rats." + woodPrefix + "_slab", woodName + " Slab");
        this.add("block.rats." + woodPrefix + "_stairs", woodName + " Stairs");
        this.add("block.rats." + woodPrefix + "_button", woodName + " Button");
        this.add("block.rats." + woodPrefix + "_fence", woodName + " Fence");
        this.add("block.rats." + woodPrefix + "_fence_gate", woodName + " Fence Gate");
        this.add("block.rats." + woodPrefix + "_pressure_plate", woodName + " Pressure Plate");
        this.add("block.rats." + woodPrefix + "_trapdoor", woodName + " Trapdoor");
        this.add("block.rats." + woodPrefix + "_door", woodName + " Door");
        this.add("block.rats." + woodPrefix + "_sign", woodName + " Sign");
        this.add("block.rats." + woodPrefix + "_wall_sign", woodName + " Wall Sign");
        this.add("item.rats." + woodPrefix + "_boat", woodName + " Boat");
        this.add("item.rats." + woodPrefix + "_chest_boat", woodName + " Chest Boat");
        this.add("block.rats." + woodPrefix + "_hanging_sign", woodName + " Hanging Sign");
        this.add("block.rats." + woodPrefix + "_wall_hanging_sign", woodName + " Wall Hanging Sign");
    }

    public void addBannerPattern(String patternPrefix, String patternName) {
        this.add("item.rats." + patternPrefix + "_banner_pattern", "Banner Pattern");
        this.add("item.rats." + patternPrefix + "_banner_pattern.desc", patternName);
        for (DyeColor color : DyeColor.values()) {
            this.add("block.minecraft.banner.rats." + patternPrefix + "." + color.m_41065_(), WordUtils.capitalize((String)color.m_41065_().replace('_', ' ')) + " " + patternName);
        }
    }

    public void addEntityAndEgg(RegistryObject<? extends EntityType<?>> entity, String name) {
        this.addEntityType((Supplier)entity, name);
        this.add("item.rats." + entity.getId().m_135815_() + "_spawn_egg", name + " Spawn Egg");
    }

    public void addSubtitle(RegistryObject<SoundEvent> sound, String name) {
        String[] splitSoundName = sound.getId().m_135815_().split("\\.", 3);
        this.add("subtitles.rats." + splitSoundName[0] + "." + splitSoundName[2], name);
    }
}

