/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatlantisBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisDimensionRegistry;
import com.github.alexthe666.rats.server.block.CustomItemRarity;
import com.github.alexthe666.rats.server.block.entity.DutchratBellBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DutchratBellBlock
extends BellBlock
implements CustomItemRarity {
    public DutchratBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_49679_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61377_, (Comparable)BellAttachType.FLOOR)).m_61124_((Property)f_49681_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Rarity getRarity() {
        return Rarity.RARE;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        DutchratBellBlockEntity bell;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DutchratBellBlockEntity && !(bell = (DutchratBellBlockEntity)blockEntity).canDestroyBell()) {
            return false;
        }
        return super.canEntityDestroy(state, level, pos, entity);
    }

    public boolean m_49701_(Level level, BlockState state, BlockHitResult result, @Nullable Player player, boolean alwaysTrueIdk) {
        boolean flag;
        Direction direction = result.m_82434_();
        BlockPos blockpos = result.m_82425_();
        boolean bl = flag = !alwaysTrueIdk || this.canRingFrom(state, direction, result.m_82450_().m_7098_() - (double)blockpos.m_123342_());
        if (flag && player != null) {
            boolean flag1 = this.m_152188_((Entity)player, level, blockpos, direction);
            if (flag1) {
                player.m_36220_(Stats.f_12979_);
            }
            return true;
        }
        return false;
    }

    public boolean m_152188_(@Nullable Entity entity, Level level, BlockPos pos, @Nullable Direction direction) {
        BlockEntity be = level.m_7702_(pos);
        if (!level.m_5776_() && be instanceof DutchratBellBlockEntity) {
            DutchratBellBlockEntity bell = (DutchratBellBlockEntity)be;
            if (direction == null) {
                direction = (Direction)level.m_8055_(pos).m_61143_((Property)f_49679_);
            }
            if (bell.canDestroyBell()) {
                this.playRingSound(level, pos, !bell.canDestroyBell());
                bell.onHit(level, direction);
            }
            return true;
        }
        return false;
    }

    private boolean canRingFrom(BlockState state, Direction direction, double distance) {
        if (direction.m_122434_() != Direction.Axis.Y && !(distance > (double)0.8124f)) {
            Direction realDir = (Direction)state.m_61143_((Property)f_49679_);
            BellAttachType attachment = (BellAttachType)state.m_61143_((Property)BlockStateProperties.f_61377_);
            return switch (attachment) {
                default -> throw new IncompatibleClassChangeError();
                case BellAttachType.FLOOR -> {
                    if (realDir.m_122434_() == direction.m_122434_()) {
                        yield true;
                    }
                    yield false;
                }
                case BellAttachType.SINGLE_WALL, BellAttachType.DOUBLE_WALL -> {
                    if (realDir.m_122434_() != direction.m_122434_()) {
                        yield true;
                    }
                    yield false;
                }
                case BellAttachType.CEILING -> true;
            };
        }
        return false;
    }

    private void playRingSound(Level level, BlockPos pos, boolean alreadySummoning) {
        if (!alreadySummoning) {
            if (level.m_46461_() || level.m_6436_(pos).m_19048_() == Difficulty.PEACEFUL || RatConfig.summonDutchratOnlyInRatlantis && !level.m_46472_().equals(RatlantisDimensionRegistry.DIMENSION_KEY)) {
                level.m_5594_(null, pos, SoundEvents.f_11699_, SoundSource.BLOCKS, 2.0f, 1.0f);
            } else {
                level.m_5594_(null, pos, (SoundEvent)RatsSoundRegistry.DUTCHRAT_BELL.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DutchratBellBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return DutchratBellBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RatlantisBlockEntityRegistry.DUTCHRAT_BELL.get()), DutchratBellBlockEntity::tick);
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }
}

