/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block;

import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.block.RatCageDecoratedBlock;
import com.github.alexthe666.rats.server.block.RatTubeBlock;
import com.github.alexthe666.rats.server.block.entity.DecoratedRatCageBlockEntity;
import com.github.alexthe666.rats.server.block.entity.RatCageBreedingLanternBlockEntity;
import com.github.alexthe666.rats.server.block.entity.RatCageWheelBlockEntity;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.RatCageDecoration;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RatCageBlock
extends Block {
    public static final IntegerProperty NORTH = IntegerProperty.m_61631_((String)"north", (int)0, (int)2);
    public static final IntegerProperty EAST = IntegerProperty.m_61631_((String)"east", (int)0, (int)2);
    public static final IntegerProperty SOUTH = IntegerProperty.m_61631_((String)"south", (int)0, (int)2);
    public static final IntegerProperty WEST = IntegerProperty.m_61631_((String)"west", (int)0, (int)2);
    public static final IntegerProperty UP = IntegerProperty.m_61631_((String)"up", (int)0, (int)2);
    public static final IntegerProperty DOWN = IntegerProperty.m_61631_((String)"down", (int)0, (int)2);
    private static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final Map<Direction, IntegerProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
        map.put(Direction.UP, UP);
        map.put(Direction.DOWN, DOWN);
    })));
    private static final Map<Direction, VoxelShape> SHAPE_BY_DIRECTION = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH_AABB);
        map.put(Direction.EAST, EAST_AABB);
        map.put(Direction.SOUTH, SOUTH_AABB);
        map.put(Direction.WEST, WEST_AABB);
        map.put(Direction.UP, TOP_AABB);
        map.put(Direction.DOWN, BOTTOM_AABB);
    });

    public RatCageBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_(RatCageBlock.getDefaultCage((StateDefinition<Block, BlockState>)this.m_49965_()));
    }

    private static BlockState getDefaultCage(StateDefinition<Block, BlockState> definition) {
        BlockState blockstate = (BlockState)definition.m_61090_();
        for (IntegerProperty property : PROPERTY_BY_DIRECTION.values()) {
            if (!blockstate.m_61138_((Property)property)) continue;
            blockstate = (BlockState)blockstate.m_61124_((Property)property, (Comparable)Integer.valueOf(0));
        }
        return blockstate;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"block.rats.rat_cage.desc0").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"block.rats.rat_cage.desc1").m_130940_(ChatFormatting.GRAY));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        for (Direction direction : Direction.values()) {
            builder.m_61104_(new Property[]{(Property)PROPERTY_BY_DIRECTION.get(direction)});
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        for (Map.Entry<Direction, IntegerProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (!blockstate.m_61138_((Property)entry.getValue())) continue;
            blockstate = (BlockState)blockstate.m_61124_((Property)entry.getValue(), (Comparable)Integer.valueOf(this.runConnectionLogic(context.m_43725_().m_8055_(context.m_8083_().m_121945_(entry.getKey())))));
        }
        return blockstate;
    }

    public int runConnectionLogic(BlockState state) {
        if (state.m_60734_() instanceof RatTubeBlock) {
            return 2;
        }
        return state.m_60734_() instanceof RatCageBlock ? 1 : 0;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        if (state.m_60734_() instanceof RatCageBlock) {
            for (Map.Entry<Direction, IntegerProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
                if ((Integer)state.m_61143_((Property)entry.getValue()) != 0) continue;
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)SHAPE_BY_DIRECTION.get(entry.getKey()), (BooleanOp)BooleanOp.f_82695_);
            }
        }
        return shape1;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack;
        Item item = player.m_21120_(hand).m_41720_();
        if (item instanceof RatCageDecoration) {
            Direction limitedFacing;
            RatCageDecoration decoration = (RatCageDecoration)item;
            if (level.m_7702_(pos) == null && (Integer)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(decoration.getSupportedFace(limitedFacing = player.m_6350_().m_122424_()))) == 0) {
                if (player.m_21120_(hand).m_150930_((Item)RatsItemRegistry.RAT_BREEDING_LANTERN.get())) {
                    BlockState pre = level.m_8055_(pos);
                    BlockState decorated = ((Block)RatsBlockRegistry.RAT_CAGE_BREEDING_LANTERN.get()).m_152465_(pre);
                    level.m_46597_(pos, (BlockState)decorated.m_61124_((Property)RatCageDecoratedBlock.FACING, (Comparable)limitedFacing));
                    RatCageBreedingLanternBlockEntity te = new RatCageBreedingLanternBlockEntity(pos, decorated);
                    ItemStack added = new ItemStack((ItemLike)player.m_21120_(hand).m_41720_(), 1);
                    te.setContainedItem(added);
                    level.m_151523_((BlockEntity)te);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                } else if (player.m_21120_(hand).m_150930_((Item)RatsItemRegistry.RAT_WHEEL.get())) {
                    BlockState pre = level.m_8055_(pos);
                    BlockState decorated = ((Block)RatsBlockRegistry.RAT_CAGE_WHEEL.get()).m_152465_(pre);
                    level.m_46597_(pos, (BlockState)decorated.m_61124_((Property)RatCageDecoratedBlock.FACING, (Comparable)limitedFacing));
                    RatCageWheelBlockEntity te = new RatCageWheelBlockEntity(pos, decorated);
                    ItemStack added = new ItemStack((ItemLike)player.m_21120_(hand).m_41720_(), 1);
                    te.setContainedItem(added);
                    level.m_151523_((BlockEntity)te);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                } else {
                    BlockState pre = level.m_8055_(pos);
                    BlockState decorated = ((Block)RatsBlockRegistry.RAT_CAGE_DECORATED.get()).m_152465_(pre);
                    level.m_46597_(pos, (BlockState)decorated.m_61124_((Property)RatCageDecoratedBlock.FACING, (Comparable)limitedFacing));
                    DecoratedRatCageBlockEntity te = new DecoratedRatCageBlockEntity(pos, decorated);
                    ItemStack added = new ItemStack((ItemLike)player.m_21120_(hand).m_41720_(), 1);
                    te.setContainedItem(added);
                    level.m_151523_((BlockEntity)te);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (level.m_7702_(pos) != null && !(stack = this.getContainedItem(level, pos)).m_41619_() && player.m_6144_()) {
            BlockState pre = level.m_8055_(pos);
            BlockState decorated = ((Block)RatsBlockRegistry.RAT_CAGE.get()).m_49966_();
            decorated = decorated.m_60734_().m_152465_(pre);
            level.m_7731_(pos, decorated, 3);
            level.m_46597_(pos, decorated);
        }
        if (player.m_21120_(hand).m_41619_() && !player.m_6144_()) {
            boolean ridingRats = false;
            if (!player.m_20197_().isEmpty()) {
                for (Entity entity : player.m_20197_()) {
                    if (!(entity instanceof TamedRat)) continue;
                    ridingRats = true;
                    break;
                }
            }
            int ratCount = 0;
            if (ridingRats) {
                for (Entity entity : player.m_20197_()) {
                    TamedRat rat2;
                    if (!(entity instanceof TamedRat) || (rat2 = (TamedRat)entity).m_6162_()) continue;
                    rat2.m_8127_();
                    rat2.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                    rat2.m_21573_().m_26573_();
                    ++ratCount;
                }
                player.m_5661_((Component)Component.m_237110_((String)"block.rats.rat_cage.deposit", (Object[])new Object[]{ratCount}), true);
            } else {
                List list = level.m_6443_(TamedRat.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)), rat -> !rat.m_6162_() && rat.m_21830_((LivingEntity)player));
                for (TamedRat rat3 : list) {
                    rat3.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    ++ratCount;
                }
                player.m_5661_((Component)Component.m_237110_((String)"block.rats.rat_cage.withdraw", (Object[])new Object[]{ratCount}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemStack getContainedItem(Level level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof DecoratedRatCageBlockEntity) {
            DecoratedRatCageBlockEntity decorated = (DecoratedRatCageBlockEntity)be;
            return decorated.getContainedItem();
        }
        return ItemStack.f_41583_;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        RatCageDecoration decoration;
        Item item;
        DecoratedRatCageBlockEntity decorated;
        state = (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Integer.valueOf(this.runConnectionLogic(facingState)));
        BlockEntity blockEntity = accessor.m_7702_(currentPos);
        if (blockEntity instanceof DecoratedRatCageBlockEntity && !(decorated = (DecoratedRatCageBlockEntity)blockEntity).getContainedItem().m_41619_() && (item = decorated.getContainedItem().m_41720_()) instanceof RatCageDecoration && (Integer)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get((decoration = (RatCageDecoration)item).getSupportedFace((Direction)state.m_61143_((Property)RatCageDecoratedBlock.FACING)))) != 0) {
            BlockState pre = state;
            BlockState emptyCage = ((Block)RatsBlockRegistry.RAT_CAGE.get()).m_49966_();
            state = emptyCage.m_60734_().m_152465_(pre);
            accessor.m_7731_(currentPos, state, 3);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.mapDirections(state, arg_0 -> ((Rotation)rotation).m_55954_(arg_0));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return this.mapDirections(state, arg_0 -> ((Mirror)mirror).m_54848_(arg_0));
    }

    private BlockState mapDirections(BlockState state, Function<Direction, Direction> rotation) {
        BlockState blockstate = state;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            blockstate = (BlockState)blockstate.m_61124_((Property)PROPERTY_BY_DIRECTION.get(rotation.apply(direction)), (Comparable)((Integer)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction))));
        }
        return blockstate;
    }
}

