/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block.entity;

import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.inventory.RatCraftingTableMenu;
import com.github.alexthe666.rats.server.inventory.container.CraftingContainerWrapper;
import com.github.alexthe666.rats.server.inventory.container.TableItemHandlers;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RatCraftingTableBlockEntity
extends BlockEntity
implements MenuProvider,
RecipeHolder,
Clearable {
    private static final Component DEFAULT_NAME = Component.m_237115_((String)"container.rats.rat_crafting_table");
    private Component customName;
    public int prevCookTime;
    private boolean hasRat;
    public boolean hasValidRecipe;
    private int cookTime;
    protected StackedContents itemHelper = new StackedContents();
    protected Optional<CraftingRecipe> guideRecipe = Optional.empty();
    protected Optional<CraftingRecipe> recipeUsed = Optional.empty();
    protected List<CraftingRecipe> possibleRecipes = List.of();
    public int totalCookTime = 200;
    private int selectedRecipeIndex = 0;
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> RatCraftingTableBlockEntity.this.cookTime;
                case 1 -> RatCraftingTableBlockEntity.this.totalCookTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    RatCraftingTableBlockEntity.this.cookTime = value;
                    break;
                }
                case 1: {
                    RatCraftingTableBlockEntity.this.totalCookTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private static final EmptyHandler EMPTYHANDLER = new EmptyHandler();
    public LazyOptional<IItemHandlerModifiable> bufferHandler = LazyOptional.of(() -> new TableItemHandlers.BufferHandler(this));
    public LazyOptional<IItemHandlerModifiable> matrixHandler = LazyOptional.of(() -> new TableItemHandlers.MatrixHandler(this));
    public LazyOptional<IItemHandlerModifiable> resultHandler = LazyOptional.of(() -> new TableItemHandlers.ResultHandler(this));
    protected LazyOptional<IItemHandlerModifiable> combinedHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.matrixHandler.orElse((Object)EMPTYHANDLER), (IItemHandlerModifiable)this.bufferHandler.orElse((Object)EMPTYHANDLER)}));
    public LazyOptional<CraftingContainer> matrixWrapper = LazyOptional.of(() -> new CraftingContainerWrapper((IItemHandlerModifiable)this.matrixHandler.orElse((Object)EMPTYHANDLER)));

    public RatCraftingTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RatsBlockEntityRegistry.RAT_CRAFTING_TABLE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RatCraftingTableBlockEntity te) {
        te.hasRat = false;
        te.totalCookTime = 200;
        for (TamedRat rat : level.m_45976_(TamedRat.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_(), (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 1.0))) {
            if (!RatUpgradeUtils.hasUpgrade(rat, (Item)RatsItemRegistry.RAT_UPGRADE_CRAFTING.get())) continue;
            te.hasRat = true;
            if (!RatUpgradeUtils.hasUpgrade(rat, (Item)RatsItemRegistry.RAT_UPGRADE_SPEED.get())) continue;
            te.totalCookTime = 100;
        }
        if (!level.m_5776_()) {
            te.prevCookTime = te.cookTime;
            te.cookTime = te.m_7928_() != null && te.hasRat && te.cookTime < te.totalCookTime ? ++te.cookTime : Mth.m_14045_((int)(te.cookTime - 2), (int)0, (int)te.totalCookTime);
            if (te.cookTime >= te.totalCookTime) {
                te.cookTime = 0;
                ItemStack addStack = te.recipeUsed.map(r -> r.m_5874_((Container)((CraftingContainer)te.matrixWrapper.resolve().orElseThrow()), level.m_9598_())).orElse(ItemStack.f_41583_);
                te.resultHandler.ifPresent(h -> h.setStackInSlot(0, addStack.m_255036_(addStack.m_41613_() + h.getStackInSlot(0).m_41613_())));
                te.consumeIngredients(null);
                te.updateRecipe();
            }
        }
    }

    public boolean hasRat() {
        return this.hasRat;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public void updateHelper() {
        this.bufferHandler.ifPresent(handler -> ((TableItemHandlers.BufferHandler)((Object)handler)).m_5809_(this.itemHelper));
        this.checkIfRecipeIsValid(this.recipeUsed, this.itemHelper);
    }

    public void updateRecipe() {
        AtomicBoolean flag = new AtomicBoolean(true);
        if (this.m_58904_() != null) {
            this.matrixWrapper.ifPresent(w -> {
                this.possibleRecipes = this.m_58904_().m_7465_().m_44056_(RecipeType.f_44107_, (Container)w, this.m_58904_());
                if (this.possibleRecipes.isEmpty()) {
                    flag.set(false);
                } else {
                    this.selectedRecipeIndex = Mth.m_14045_((int)this.selectedRecipeIndex, (int)0, (int)(this.possibleRecipes.size() - 1));
                    this.guideRecipe = Optional.of(this.possibleRecipes.get(this.selectedRecipeIndex));
                    if (!this.checkIfResultFits(this.m_58904_(), this.guideRecipe)) {
                        flag.set(false);
                    }
                    this.recipeUsed = Optional.of(this.possibleRecipes.get(this.selectedRecipeIndex)).filter(r -> this.m_40135_(this.m_58904_(), null, (Recipe<?>)r));
                }
            });
            if (flag.get()) {
                this.checkIfRecipeIsValid(this.recipeUsed, this.itemHelper);
                if (!this.hasValidRecipe) {
                    this.m_6029_(null);
                }
            } else {
                this.guideRecipe = Optional.empty();
                this.m_6029_(null);
            }
        }
    }

    private boolean checkIfResultFits(Level level, Optional<CraftingRecipe> recipe) {
        if (recipe.isPresent() && this.resultHandler.resolve().isPresent()) {
            ItemStack resultStack;
            ItemStack checkStack = ((IItemHandlerModifiable)this.resultHandler.resolve().get()).getStackInSlot(0);
            return ItemStack.m_150942_((ItemStack)checkStack, (ItemStack)(resultStack = recipe.get().m_8043_(level.m_9598_()))) && checkStack.m_41613_() + resultStack.m_41613_() <= checkStack.m_41741_() || checkStack.m_41619_();
        }
        return false;
    }

    private void checkIfRecipeIsValid(Optional<CraftingRecipe> recipe, StackedContents helper) {
        this.hasValidRecipe = recipe.isPresent() && helper.m_36493_((Recipe)recipe.get(), null) > 0;
    }

    public void m_6211_() {
        this.combinedHandler.ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                h.setStackInSlot(i, ItemStack.f_41583_);
            }
        });
        this.updateRecipe();
    }

    public void incrementSelectedRecipe(boolean negative) {
        this.selectedRecipeIndex = negative ? --this.selectedRecipeIndex : ++this.selectedRecipeIndex;
        this.updateRecipe();
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        this.recipeUsed = Optional.ofNullable((CraftingRecipe)recipe);
    }

    public boolean m_40135_(Level level, @Nullable ServerPlayer player, Recipe<?> recipe) {
        return !level.m_46469_().m_46207_(GameRules.f_46151_) || recipe.m_5598_();
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return this.recipeUsed.orElse(null);
    }

    public Optional<CraftingRecipe> getGuideRecipe() {
        return this.guideRecipe;
    }

    public List<CraftingRecipe> getPossibleRecipes() {
        return this.possibleRecipes;
    }

    public void onLoad() {
        super.onLoad();
        this.updateRecipe();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.bufferHandler.ifPresent(handler -> ((INBTSerializable)handler).deserializeNBT((Tag)tag.m_128469_("Buffer")));
        this.matrixHandler.ifPresent(handler -> ((INBTSerializable)handler).deserializeNBT((Tag)tag.m_128469_("Matrix")));
        this.resultHandler.ifPresent(handler -> ((INBTSerializable)handler).deserializeNBT((Tag)tag.m_128469_("Result")));
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        this.cookTime = tag.m_128451_("CookTime");
        this.selectedRecipeIndex = tag.m_128451_("SelectedRecipe");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.bufferHandler.ifPresent(h -> tag.m_128365_("Buffer", ((INBTSerializable)h).serializeNBT()));
        this.matrixHandler.ifPresent(h -> tag.m_128365_("Matrix", ((INBTSerializable)h).serializeNBT()));
        this.resultHandler.ifPresent(h -> tag.m_128365_("Result", ((INBTSerializable)h).serializeNBT()));
        if (this.hasCustomName()) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        tag.m_128405_("CookTime", this.cookTime);
        tag.m_128405_("SelectedRecipe", this.selectedRecipeIndex);
    }

    @Nonnull
    public Component m_5446_() {
        return this.hasCustomName() ? this.customName : DEFAULT_NAME;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(@Nullable Component name) {
        this.customName = name;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new RatCraftingTableMenu(id, inventory, this, this.dataAccess);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.DOWN) {
                return this.resultHandler.cast();
            }
            return this.bufferHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void consumeIngredients(@Nullable Player player) {
        this.recipeUsed.ifPresent(recipe -> {
            NonNullList remainingStacks = this.matrixWrapper.map(arg_0 -> ((CraftingRecipe)recipe).m_7457_(arg_0)).orElse(NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_));
            if (this.hasValidRecipe) {
                this.bufferHandler.ifPresent(h -> recipe.m_7527_().forEach(i -> {
                    for (int j = 0; j < h.getSlots(); ++j) {
                        if (!i.test(h.getStackInSlot(j))) continue;
                        h.extractItem(j, 1, false);
                        break;
                    }
                }));
            }
            IntStream.range(0, remainingStacks.size()).mapToObj(i -> {
                ItemStack stack = (ItemStack)remainingStacks.get(i);
                return this.hasValidRecipe ? stack : this.matrixHandler.map(h -> h.insertItem(i, stack, false)).orElse(stack);
            }).filter(stack -> !stack.m_41619_()).map(stack -> this.bufferHandler.map(h -> ItemHandlerHelper.insertItemStacked((IItemHandler)h, (ItemStack)stack, (boolean)false)).orElse(stack)).filter(stack -> !stack.m_41619_()).forEach(stack -> {
                if (player != null) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
                } else {
                    this.outputStack((ItemStack)stack);
                }
            });
        });
    }

    private void outputStack(ItemStack stack) {
        ItemStack newStack = this.getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> ItemHandlerHelper.insertItemStacked((IItemHandler)h, (ItemStack)stack, (boolean)false)).orElse(stack);
        if (!newStack.m_41619_() && this.m_58904_() != null) {
            ItemEntity item = new ItemEntity(this.m_58904_(), (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_() + 1.0, (double)((float)this.m_58899_().m_123343_() + 0.5f), newStack);
            item.m_20256_(Vec3.f_82478_);
            item.m_32061_();
            item.m_32064_();
            this.m_58904_().m_7967_((Entity)item);
        }
    }
}

