/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.data.tags.RatsBlockTags;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.ai.goal.RatMoveToBlockGoal;
import com.github.alexthe666.rats.server.entity.rat.DiggingRat;
import com.github.alexthe666.rats.server.misc.RatPathingHelper;
import com.github.alexthe666.rats.server.misc.RatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraftforge.event.ForgeEventFactory;

public class RatRaidChestsGoal
extends RatMoveToBlockGoal {
    private final DiggingRat rat;

    public RatRaidChestsGoal(DiggingRat entity) {
        super((PathfinderMob)entity, 1.0, 16);
        this.rat = entity;
    }

    public boolean m_8036_() {
        if (!this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            return false;
        }
        if (!this.rat.canMove() || this.rat.m_269323_() != null || !RatConfig.ratsStealItems) {
            return false;
        }
        return ForgeEventFactory.getMobGriefingEvent((Level)this.rat.m_9236_(), (Entity)this.rat) && super.m_8036_();
    }

    public boolean m_8045_() {
        return super.m_8045_() && this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    public void m_8037_() {
        BlockEntity entity;
        super.m_8037_();
        if (this.m_25625_() && (entity = this.rat.m_9236_().m_7702_(this.f_25602_)) instanceof Container) {
            Container feeder = (Container)entity;
            double distance = this.rat.m_20275_(this.f_25602_.m_123341_(), this.f_25602_.m_123342_(), this.f_25602_.m_123343_());
            if (distance < 6.25 && distance > (double)2.72f) {
                this.toggleChest(feeder, true);
                this.rat.m_9236_().m_247517_(null, this.f_25602_, SoundEvents.f_11749_, SoundSource.BLOCKS);
            }
            if (distance <= (double)2.89f) {
                this.toggleChest(feeder, false);
                this.rat.m_9236_().m_247517_(null, this.f_25602_, SoundEvents.f_11747_, SoundSource.BLOCKS);
                ItemStack stack = RatUtils.getFoodFromInventory(feeder, this.rat.m_9236_().m_213780_());
                if (stack != ItemStack.f_41583_) {
                    int slotToReplace;
                    ItemStack duplicate = stack.m_41777_();
                    duplicate.m_41764_(1);
                    if (!this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                        this.rat.m_5552_(this.rat.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
                    }
                    this.rat.m_21008_(InteractionHand.MAIN_HAND, duplicate);
                    stack.m_41774_(1);
                    if (RatConfig.ratsContaminateFood && this.rat.m_217043_().m_188503_(3) == 0 && (slotToReplace = RatUtils.getContaminatedSlot(feeder, this.rat.m_9236_().m_213780_())) != -1) {
                        if (feeder.m_8020_(slotToReplace).m_41619_()) {
                            ItemStack stack1 = new ItemStack((ItemLike)RatsItemRegistry.CONTAMINATED_FOOD.get());
                            feeder.m_6836_(slotToReplace, stack1);
                        } else if (feeder.m_8020_(slotToReplace).m_150930_((Item)RatsItemRegistry.CONTAMINATED_FOOD.get())) {
                            feeder.m_8020_(slotToReplace).m_41769_(1);
                        }
                    }
                    this.rat.setFleePos(this.f_25602_);
                }
            }
        }
    }

    protected boolean m_6465_(LevelReader reader, BlockPos pos) {
        if (!reader.m_8055_(pos).m_204336_(RatsBlockTags.UNRAIDABLE_CONTAINERS) && reader.m_8055_(pos).m_60734_() instanceof EntityBlock) {
            if (!RatPathingHelper.canSeeOrDigToBlock(this.rat, pos)) {
                return false;
            }
            if (RatUtils.isBlockProtected(this.rat.m_9236_(), pos, this.rat)) {
                return false;
            }
            BlockEntity entity = reader.m_7702_(pos);
            if (entity instanceof Container) {
                Container inventory = (Container)entity;
                try {
                    RandomizableContainerBlockEntity container;
                    if (entity instanceof RandomizableContainerBlockEntity && (container = (RandomizableContainerBlockEntity)entity).m_187480_().m_128441_("LootTable")) {
                        return false;
                    }
                    if (!inventory.m_7983_() && RatUtils.doesContainFood(inventory)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    RatsMod.LOGGER.warn("Rats stopped a " + entity.getClass().getSimpleName() + " from causing a crash during access");
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    public void toggleChest(Container te, boolean open) {
        if (te instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)te;
            if (open) {
                this.rat.m_9236_().m_7696_(this.f_25602_, chest.m_58900_().m_60734_(), 1, 1);
            } else {
                this.rat.m_9236_().m_7696_(this.f_25602_, chest.m_58900_().m_60734_(), 1, 0);
            }
        }
    }
}

