/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal.harvest;

import com.github.alexthe666.rats.server.entity.ai.goal.harvest.BaseRatHarvestGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RatPlaceGoal
extends BaseRatHarvestGoal {
    private final TamedRat rat;

    public RatPlaceGoal(TamedRat rat) {
        super(rat);
        this.rat = rat;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!(super.m_8036_() && this.checkTheBasics(false, false) && this.holdingBlock())) {
            return false;
        }
        this.resetTarget();
        return this.getTargetBlock() != null;
    }

    private boolean holdingBlock() {
        ItemStack stack = this.rat.m_21120_(InteractionHand.MAIN_HAND);
        return !stack.m_41619_() && stack.m_41720_() instanceof BlockItem;
    }

    public boolean m_8045_() {
        return this.getTargetBlock() != null && this.holdingBlock() && this.rat.m_9236_().m_8055_(this.getTargetBlock()).m_247087_();
    }

    public void m_8037_() {
        if (this.getTargetBlock() != null && this.holdingBlock()) {
            ItemStack stack = this.rat.m_21120_(InteractionHand.MAIN_HAND);
            BlockItem blockItem = (BlockItem)stack.m_41720_();
            BlockState block = this.rat.m_9236_().m_8055_(this.getTargetBlock());
            BlockPos moveToPos = this.getTargetBlock();
            this.rat.m_21573_().m_26519_((double)moveToPos.m_123341_() + 0.5, (double)moveToPos.m_123342_(), (double)moveToPos.m_123343_() + 0.5, 1.25);
            if (block.m_60734_().m_7898_(block, (LevelReader)this.rat.m_9236_(), this.getTargetBlock()) && this.rat.m_9236_().m_46859_(this.getTargetBlock().m_7494_()) && this.rat.m_9236_().m_8055_(this.getTargetBlock()).m_247087_()) {
                double distance = this.rat.getRatDistanceCenterSq(this.getTargetBlock().m_123341_(), this.getTargetBlock().m_123342_(), this.getTargetBlock().m_123343_());
                if (distance < this.rat.getRatHarvestDistance(0.0)) {
                    ItemStack seedStack = this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41777_();
                    seedStack.m_41764_(1);
                    this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41774_(1);
                    BlockHitResult raytrace = this.rat.m_9236_().m_45547_(new ClipContext(new Vec3((double)this.getTargetBlock().m_123341_(), (double)this.getTargetBlock().m_123342_(), (double)this.getTargetBlock().m_123343_()), new Vec3((double)this.getTargetBlock().m_123341_(), (double)this.getTargetBlock().m_123342_(), (double)this.getTargetBlock().m_123343_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.rat));
                    BlockPlaceContext itemusecontext = new BlockPlaceContext(this.rat.m_9236_(), null, InteractionHand.MAIN_HAND, this.rat.m_21120_(InteractionHand.MAIN_HAND), raytrace);
                    BlockState BlockState1 = blockItem.m_40614_().m_5573_(new BlockPlaceContext((UseOnContext)itemusecontext));
                    this.rat.m_9236_().m_46597_(this.getTargetBlock(), BlockState1);
                    if (this.rat.m_5830_()) {
                        this.rat.m_6034_(this.rat.m_20185_(), this.rat.m_20186_() + 1.0, this.rat.m_20189_());
                    }
                    SoundType placeSound = BlockState1.m_60734_().getSoundType(BlockState1, (LevelReader)this.rat.m_9236_(), this.getTargetBlock(), (Entity)this.rat);
                    this.rat.m_5496_(placeSound.m_56777_(), (placeSound.m_56773_() + 1.0f) / 2.0f, placeSound.m_56774_() * 0.8f);
                    this.setTargetBlock(null);
                    this.m_8041_();
                }
            } else {
                this.setTargetBlock(null);
                this.m_8041_();
            }
        }
    }

    private void resetTarget() {
        BlockPos newTarget = null;
        if (this.rat.getHomePoint().isPresent()) {
            newTarget = this.rat.getHomePoint().get().m_122646_();
            if (!this.rat.m_9236_().m_8055_(newTarget).m_247087_()) {
                newTarget = newTarget.m_7494_();
            }
        }
        if (newTarget != null && RatUtils.canRatPlaceBlock(this.rat.m_9236_(), newTarget, this.rat)) {
            this.setTargetBlock(newTarget);
        }
    }
}

