/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.misc;

import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkHooks;

public class PiratWoodBoat
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.m_135353_(PiratWoodBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PiratWoodBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public PiratWoodBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)RatlantisEntityRegistry.BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public Type getRatsBoatType() {
        return Type.byId((Integer)this.m_20088_().m_135370_(BOAT_TYPE));
    }

    public Item m_38369_() {
        switch (this.getRatsBoatType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case PIRAT: 
        }
        return (Item)RatlantisItemRegistry.PIRAT_BOAT.get();
    }

    public void setTwilightBoatType(Type boatType) {
        this.m_20088_().m_135381_(BOAT_TYPE, (Object)boatType.ordinal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(BOAT_TYPE, (Object)Type.PIRAT.ordinal());
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128359_("Type", this.getRatsBoatType().getName());
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("Type", 8)) {
            this.setTwilightBoatType(Type.getTypeFromString(tag.m_128461_("Type")));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Type {
        PIRAT((Block)RatlantisBlockRegistry.PIRAT_PLANKS.get(), "pirat");

        private final String name;
        private final Block block;

        private Type(Block block, String name) {
            this.name = name;
            this.block = block;
        }

        public String getName() {
            return this.name;
        }

        public Block asPlank() {
            return this.block;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] types = Type.values();
            if (id < 0 || id >= types.length) {
                id = 0;
            }
            return types[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.getName().equals(nameIn)) continue;
                return type;
            }
            return types[0];
        }
    }
}

