/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;

public abstract class ArrowlikeProjectile
extends Projectile {
    @Nullable
    private BlockState lastState;
    protected boolean inGround;
    protected int inGroundTime;
    public int shakeTime;
    private int life;
    private double baseDamage = 2.0;

    protected ArrowlikeProjectile(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    protected ArrowlikeProjectile(EntityType<? extends Projectile> type, double x, double y, double z, Level level) {
        this(type, level);
        this.m_6034_(x, y, z);
    }

    protected ArrowlikeProjectile(EntityType<? extends Projectile> type, LivingEntity owner, Level level) {
        this(type, owner.m_20185_(), owner.m_20188_() - (double)0.1f, owner.m_20189_(), level);
        this.m_5602_((Entity)owner);
    }

    public boolean m_6783_(double dist) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return dist < (d0 *= 64.0 * ArrowlikeProjectile.m_20150_()) * d0;
    }

    public void m_6686_(double x, double y, double z, float yRot, float xRot) {
        super.m_6686_(x, y, z, yRot, xRot);
        this.life = 0;
    }

    public void m_6001_(double xMotion, double yMotion, double zMotion) {
        super.m_6001_(xMotion, yMotion, zMotion);
        this.life = 0;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        super.m_8119_();
        boolean flag = this.f_19794_;
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (!(blockstate.m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_) || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType))) {
            this.m_20095_();
        }
        if (this.inGround && !flag) {
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            } else if (!this.m_9236_().m_5776_()) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
        } else {
            this.inGroundTime = 0;
            HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
            if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(ArrowlikeProjectile.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(ArrowlikeProjectile.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 0.99f;
            this.m_20256_(vec3.m_82490_((double)f));
            if (!this.m_20068_() && !flag) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
            }
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
        }
    }

    private boolean shouldFall() {
        return this.inGround && this.m_9236_().m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        Vec3 vec3 = this.m_20184_();
        this.m_20256_(vec3.m_82542_((double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f)));
        this.life = 0;
    }

    public void m_6478_(MoverType type, Vec3 vec) {
        super.m_6478_(type, vec);
        if (type != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= 1200) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        DamageSource damagesource;
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.getBaseDamage()), (double)0.0, (double)2.147483647E9));
        Entity entity1 = this.m_19749_();
        if (entity1 == null) {
            damagesource = this.m_269291_().m_268998_(DamageTypes.f_268739_, (Entity)this, (Entity)this);
        } else {
            damagesource = this.m_269291_().m_268998_(DamageTypes.f_268739_, (Entity)this, entity1);
            if (entity1 instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity1;
                living.m_21335_(entity);
            }
        }
        boolean flag = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !flag) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.m_9236_().m_5776_() && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
            }
        } else {
            entity.m_7311_(k);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
        }
        this.m_146870_();
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && (this.m_19749_() == null || !this.isAlliedToOwner(entity));
    }

    protected boolean isAlliedToOwner(Entity entity) {
        OwnableEntity ownable;
        Entity entity2 = this.m_19749_();
        if (entity2 instanceof OwnableEntity && (ownable = (OwnableEntity)entity2).m_269323_() == entity) {
            return true;
        }
        return entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).m_269323_() == entity;
    }

    protected void m_8060_(BlockHitResult result) {
        this.m_146870_();
        if (this.explodesOnHit()) {
            Explosion explosion = this.m_9236_().m_254849_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, Level.ExplosionInteraction.MOB);
            explosion.m_46061_();
            explosion.m_46075_(true);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128376_("life", (short)this.life);
        if (this.lastState != null) {
            tag.m_128365_("inBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.lastState));
        }
        tag.m_128344_("shake", (byte)this.shakeTime);
        tag.m_128379_("inGround", this.inGround);
        tag.m_128347_("damage", this.baseDamage);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.life = tag.m_128448_("life");
        if (tag.m_128425_("inBlockState", 10)) {
            this.lastState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("inBlockState"));
        }
        this.shakeTime = tag.m_128445_("shake") & 0xFF;
        this.inGround = tag.m_128471_("inGround");
        if (tag.m_128425_("damage", 99)) {
            this.baseDamage = tag.m_128459_("damage");
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void setBaseDamage(double damage) {
        this.baseDamage = damage;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public boolean m_6097_() {
        return false;
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return 0.13f;
    }

    public abstract boolean explodesOnHit();

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

