/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.projectile;

import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.server.entity.projectile.ArrowlikeProjectile;
import com.github.alexthe666.rats.server.events.ForgeEvents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class PlagueShot
extends ArrowlikeProjectile {
    public PlagueShot(EntityType<? extends ArrowlikeProjectile> type, Level level) {
        super(type, level);
        this.setBaseDamage(6.0);
    }

    public PlagueShot(EntityType<? extends ArrowlikeProjectile> type, Level level, LivingEntity shooter, double dmg) {
        super(type, shooter, level);
        this.setBaseDamage(dmg);
    }

    public boolean m_20069_() {
        return false;
    }

    @Override
    public void m_8119_() {
        float sqrt = Mth.m_14116_((float)((float)(this.m_20184_().m_7096_() * this.m_20184_().m_7096_() + this.m_20184_().m_7094_() * this.m_20184_().m_7094_())));
        if (!this.m_6000_(this.m_20185_(), this.m_20186_(), this.m_20189_()) || (sqrt < 0.1f || this.inGround || this.f_19862_) && this.f_19797_ > 5) {
            this.m_146870_();
        }
        double d0 = 0.0;
        double d1 = 0.01;
        double d2 = 0.0;
        double x = this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
        double y = this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()) - (double)this.m_20206_();
        double z = this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
        float f = (this.m_20205_() + this.m_20206_() + this.m_20205_()) * 0.333f + 0.5f;
        if (this.particleDistSq(x, y, z) < (double)(f * f)) {
            if (this.f_19796_.m_188499_()) {
                this.m_9236_().m_7106_((ParticleOptions)RatsParticleRegistry.BLACK_DEATH.get(), x, y + 0.5, z, d0, d1, d2);
            } else {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, x, y + 0.5, z, d0, d1, d2);
            }
        }
        super.m_8119_();
    }

    public double particleDistSq(double toX, double toY, double toZ) {
        double d0 = this.m_20185_() - toX;
        double d1 = this.m_20186_() - toY;
        double d2 = this.m_20189_() - toZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.m_19749_() == null || !living.m_7306_(this.m_19749_())) {
                ForgeEvents.maybeAddAndSyncPlague(null, living, 1200, 0);
            }
        }
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public boolean explodesOnHit() {
        return false;
    }
}

