/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.projectile;

import com.github.alexthe666.rats.data.tags.RatsEntityTags;
import com.github.alexthe666.rats.registry.RatsEffectRegistry;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.DemonRat;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;

public class PurifyingLiquid
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Boolean> NETHER = SynchedEntityData.m_135353_(PurifyingLiquid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public PurifyingLiquid(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
    }

    public PurifyingLiquid(Level level, LivingEntity thrower, boolean nether) {
        super((EntityType)RatsEntityRegistry.PURIFYING_LIQUID.get(), thrower, level);
        this.m_20088_().m_135381_(NETHER, (Object)nether);
    }

    public PurifyingLiquid(Level level, double x, double y, double z, boolean nether) {
        super((EntityType)RatsEntityRegistry.PURIFYING_LIQUID.get(), x, y, z, level);
        this.m_20088_().m_135381_(NETHER, (Object)nether);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(NETHER, (Object)false);
    }

    protected void m_6532_(HitResult result) {
        if (!this.m_9236_().m_5776_()) {
            AABB aabb = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
            List list = this.m_9236_().m_45976_(LivingEntity.class, aabb);
            if (!list.isEmpty()) {
                for (LivingEntity living : list) {
                    ZombieVillager zomb;
                    Rat rat;
                    double d0;
                    if (!living.m_5801_() || !((d0 = this.m_20280_((Entity)living)) < 16.0)) continue;
                    if (((Boolean)this.m_20088_().m_135370_(NETHER)).booleanValue()) {
                        if (!(living instanceof DemonRat)) continue;
                        rat = new Rat((EntityType<? extends Rat>)((EntityType)RatsEntityRegistry.RAT.get()), this.m_9236_());
                        rat.m_20359_((Entity)living);
                        if (!this.m_9236_().m_5776_()) {
                            ForgeEventFactory.onFinalizeSpawn((Mob)rat, (ServerLevelAccessor)((ServerLevelAccessor)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.CONVERSION, null, null);
                        }
                        rat.m_7105_(false);
                        rat.m_21816_(null);
                        this.m_9236_().m_7967_((Entity)rat);
                        living.m_146870_();
                        continue;
                    }
                    if (living instanceof Rat && (rat = (Rat)living).hasPlague()) {
                        rat.setPlagued(false);
                    }
                    if (living.m_21023_((MobEffect)RatsEffectRegistry.PLAGUE.get())) {
                        living.m_21195_((MobEffect)RatsEffectRegistry.PLAGUE.get());
                    }
                    if (living.m_6095_().m_204039_(RatsEntityTags.PLAGUE_LEGION)) {
                        living.m_6469_(this.m_269291_().m_269425_(), 10.0f);
                    }
                    if (!(living instanceof ZombieVillager) || (zomb = (ZombieVillager)living).m_34408_()) continue;
                    zomb.m_34383_(this.m_19749_() != null ? this.m_19749_().m_20148_() : null, 200);
                }
            }
            this.m_9236_().m_46796_(2002, this.m_20183_(), (Boolean)this.m_20088_().m_135370_(NETHER) != false ? 11342878 : 12574690);
            this.m_146870_();
        }
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)this.m_7881_());
    }

    protected Item m_7881_() {
        try {
            return (Boolean)this.m_20088_().m_135370_(NETHER) != false ? (Item)RatsItemRegistry.CRIMSON_FLUID.get() : (Item)RatsItemRegistry.PURIFYING_LIQUID.get();
        }
        catch (Exception ignored) {
            return (Item)RatsItemRegistry.PURIFYING_LIQUID.get();
        }
    }
}

