/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.projectile;

import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.RatSummoner;
import com.github.alexthe666.rats.server.entity.rat.DiggingRat;
import com.github.alexthe666.rats.server.entity.rat.InventoryRat;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import com.github.alexthe666.rats.server.entity.rat.RatCommand;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class RatShot
extends ThrowableProjectile {
    private static final EntityDataAccessor<String> RAT_COLOR = SynchedEntityData.m_135353_(RatShot.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    protected void m_8097_() {
        this.m_20088_().m_135372_(RAT_COLOR, (Object)RatVariant.getVariantId(RatVariant.getRandomVariant(this.f_19796_, false)));
    }

    public RatShot(EntityType<? extends ThrowableProjectile> type, Level level) {
        super(type, level);
    }

    public RatShot(EntityType<? extends ThrowableProjectile> type, Level level, LivingEntity thrower) {
        super(type, thrower, level);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("RatColor", RatVariant.getVariantId(this.getColorVariant()));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setColorVariant(RatVariant.getVariant(compound.m_128461_("RatColor")));
    }

    public void m_7822_(byte id) {
        if (id == 3) {
            for (int i = 0; i < 18; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)RatsItemRegistry.CHEESE.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3d = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = vec3d.m_165925_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)f) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    protected void m_6532_(HitResult result) {
        float damage;
        if (result instanceof EntityHitResult) {
            EntityHitResult entityResult = (EntityHitResult)result;
            if (this.m_19749_() != null && this.m_19749_().m_7307_(entityResult.m_82443_())) {
                return;
            }
        }
        Entity hitEntity = null;
        float f = damage = this.m_19749_() instanceof Player ? 6.0f : 8.0f;
        if (!this.m_9236_().m_5776_()) {
            Entity thrower;
            if (result instanceof EntityHitResult) {
                EntityHitResult entityResult = (EntityHitResult)result;
                if ((this.m_19749_() == null || !entityResult.m_82443_().m_7307_(this.m_19749_())) && entityResult.m_82443_() instanceof LivingEntity) {
                    entityResult.m_82443_().m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), damage);
                    hitEntity = entityResult.m_82443_();
                }
            }
            if ((thrower = this.m_19749_()) != null) {
                Level level;
                DiggingRat rat = thrower instanceof Player ? new TamedRat((EntityType<? extends TamableAnimal>)((EntityType)RatsEntityRegistry.TAMED_RAT.get()), this.m_9236_()) : new Rat((EntityType<? extends Rat>)((EntityType)RatsEntityRegistry.RAT.get()), this.m_9236_());
                rat.m_20359_((Entity)this);
                if (thrower instanceof Player) {
                    Player player = (Player)thrower;
                    rat.m_21828_(player);
                    ((InventoryRat)rat).setCommand(RatCommand.WANDER);
                    if (hitEntity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)hitEntity;
                        rat.m_6710_(living);
                    }
                } else if (thrower instanceof Mob) {
                    Mob mob = (Mob)thrower;
                    rat.m_6710_(mob.m_5448_());
                    rat.m_7105_(false);
                    rat.m_21816_(mob.m_20148_());
                }
                if (thrower instanceof RatSummoner) {
                    RatSummoner ratter = (RatSummoner)thrower;
                    ratter.setRatsSummoned(ratter.getRatsSummoned() + 1);
                }
                if ((level = this.m_9236_()) instanceof ServerLevelAccessor) {
                    ServerLevelAccessor accessor = (ServerLevelAccessor)level;
                    ForgeEventFactory.onFinalizeSpawn((Mob)rat, (ServerLevelAccessor)accessor, (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.REINFORCEMENT, null, null);
                }
                rat.setColorVariant(this.getColorVariant());
                if (rat instanceof Rat) {
                    Rat plagueable = (Rat)rat;
                    plagueable.setPlagued(false);
                }
                this.m_9236_().m_7967_((Entity)rat);
            }
            this.m_146870_();
        }
    }

    public RatVariant getColorVariant() {
        return RatVariant.getVariant((String)this.m_20088_().m_135370_(RAT_COLOR));
    }

    public void setColorVariant(RatVariant variant) {
        this.m_20088_().m_135381_(RAT_COLOR, (Object)RatVariant.getVariantId(variant));
    }

    public BlockPos getLightPosition() {
        BlockPos pos = this.m_20183_();
        if (!this.m_9236_().m_8055_(pos).m_60815_()) {
            return pos.m_7494_();
        }
        return pos;
    }
}

