/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.rat;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisDimensionRegistry;
import com.github.alexthe666.rats.server.entity.ai.goal.RatEnterTrapGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.WildRatAvoidPlayerGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.WildRatDefendPlagueDoctorGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.WildRatTargetFoodGoal;
import com.github.alexthe666.rats.server.entity.monster.boss.RatKing;
import com.github.alexthe666.rats.server.entity.rat.DiggingRat;
import com.github.alexthe666.rats.server.entity.rat.RatCommand;
import com.github.alexthe666.rats.server.entity.rat.RatStatus;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.events.ForgeEvents;
import com.github.alexthe666.rats.server.misc.RatUtils;
import com.github.alexthe666.rats.server.misc.RatsDateFetcher;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class Rat
extends DiggingRat {
    private static final EntityDataAccessor<Boolean> PLAGUE = SynchedEntityData.m_135353_(Rat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TOGA = SynchedEntityData.m_135353_(Rat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RAT_KING_TRANSFORMATION = SynchedEntityData.m_135353_(Rat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int ratKingTransformTicks = 0;
    public int wildTrust = 0;
    public int cheeseFeedings = 0;
    private static final Predicate<Player> AVOIDED_PLAYERS = entity -> !entity.m_20163_() && !entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)RatsItemRegistry.PIPER_HAT.get()) && EntitySelector.f_20406_.test(entity);

    public Rat(EntityType<? extends Rat> rat, Level level) {
        super(rat, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22280_, 0.35).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 12.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new WildRatAvoidPlayerGoal(this, entity -> AVOIDED_PLAYERS.test((Player)entity)));
        this.f_21345_.m_25352_(2, (Goal)new RatEnterTrapGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new PanicGoal((PathfinderMob)this, 1.225){

            protected boolean m_202729_() {
                return !Rat.this.hasPlague() && this.f_25684_.m_21188_() instanceof Player;
            }
        });
        this.f_21346_.m_25352_(0, (Goal)new WildRatTargetFoodGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new WildRatDefendPlagueDoctorGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> {
            if (!EntitySelector.f_20406_.test(entity) || !this.hasPlague()) {
                return false;
            }
            return !entity.m_7307_((Entity)this) && !entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)RatsItemRegistry.BLACK_DEATH_MASK.get()) && entity.m_9236_().m_46791_() != Difficulty.PEACEFUL;
        }));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(PLAGUE, (Object)false);
        this.m_20088_().m_135372_(TOGA, (Object)false);
        this.m_20088_().m_135372_(RAT_KING_TRANSFORMATION, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.m_21534_() != BlockPos.f_121853_) {
            BlockPos home = this.m_21534_();
            compound.m_128365_("Home", (Tag)this.makeDoubleList(home.m_123341_(), home.m_123342_(), home.m_123343_()));
            compound.m_128350_("HomeDistance", this.m_21535_());
        }
        compound.m_128405_("CheeseFeedings", this.cheeseFeedings);
        compound.m_128405_("WildTrust", this.wildTrust);
        compound.m_128379_("Plague", this.hasPlague());
        compound.m_128379_("Toga", this.hasToga());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Home", 9)) {
            ListTag nbttaglist = compound.m_128437_("Home", 6);
            int hx = (int)nbttaglist.m_128772_(0);
            int hy = (int)nbttaglist.m_128772_(1);
            int hz = (int)nbttaglist.m_128772_(2);
            this.m_21446_(new BlockPos(hx, hy, hz), (int)compound.m_128457_("HomeDistance"));
        }
        this.wildTrust = compound.m_128451_("WildTrust");
        this.cheeseFeedings = compound.m_128451_("CheeseFeedings");
        this.setPlagued(compound.m_128471_("Plague"));
        this.setToga(compound.m_128471_("Toga"));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_269323_() == null || !this.m_269323_().m_6084_()) {
            this.m_21816_(null);
        }
        if (this.hasPlague() && this.m_217043_().m_188501_() < 0.3f) {
            double d0 = 0.0;
            double d1 = this.m_217043_().m_188583_() * 0.05 + 0.5;
            double d2 = 0.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
        }
        if (this.isBecomingRatKing() && (!this.m_21205_().m_150930_((Item)RatsItemRegistry.FILTH_CORRUPTION.get()) || this.m_9236_().m_6436_(this.m_20183_()).m_19048_() == Difficulty.PEACEFUL)) {
            this.m_20088_().m_135381_(RAT_KING_TRANSFORMATION, (Object)false);
            if (this.m_9236_().m_6436_(this.m_20183_()).m_19048_() == Difficulty.PEACEFUL) {
                this.m_19983_(this.m_21205_());
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
        }
        if (this.isBecomingRatKing()) {
            this.setAnimation(ANIMATION_EAT);
            this.setRatStatus(RatStatus.EATING);
            ++this.eatingTicks;
            ++this.ratKingTransformTicks;
            this.handleRatKingTransform();
        }
    }

    public int m_213860_() {
        return this.hasPlague() ? 10 : super.m_213860_();
    }

    @Nullable
    public LivingEntity m_269323_() {
        try {
            ServerLevel server;
            Entity entity;
            UUID uuid = this.m_21805_();
            Level level = this.m_9236_();
            if (level instanceof ServerLevel && (entity = (server = (ServerLevel)level).m_8791_(uuid)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return living;
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return null;
    }

    private void handleRatKingTransform() {
        if (this.m_9236_().m_5776_()) {
            int i;
            if (this.ratKingTransformTicks < 120) {
                for (i = 0; i < 15; ++i) {
                    Vec3 ratPos = DefaultRandomPos.m_148403_((PathfinderMob)this, (int)32, (int)10);
                    if (ratPos == null || !this.m_9236_().m_8055_(BlockPos.m_274446_((Position)ratPos)).m_60795_() || this.m_9236_().m_8055_(BlockPos.m_274446_((Position)ratPos).m_7495_()).m_60795_()) continue;
                    this.m_9236_().m_7107_((ParticleOptions)RatsParticleRegistry.RUNNING_RAT.get(), ratPos.m_7096_(), ratPos.m_7098_(), ratPos.m_7094_(), (double)this.m_20183_().m_123341_(), (double)this.m_20183_().m_123342_(), (double)this.m_20183_().m_123343_());
                    break;
                }
            }
            if (this.ratKingTransformTicks % 2 == 0) {
                for (i = 0; i < this.ratKingTransformTicks * 2; ++i) {
                    double randomOff = Math.max((double)this.ratKingTransformTicks / 60.0, 1.0);
                    this.m_9236_().m_7106_((ParticleOptions)RatsParticleRegistry.RAT_KING_SMOKE.get(), this.m_20182_().m_7096_() - randomOff / 2.0 + this.m_217043_().m_188500_() * randomOff, this.m_20182_().m_7098_() + this.m_217043_().m_188500_() * 0.75, this.m_20182_().m_7094_() - randomOff / 2.0 + this.m_217043_().m_188500_() * randomOff, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.ratKingTransformTicks == 200 && !this.m_9236_().m_5776_()) {
            RatKing king = new RatKing((EntityType<? extends Monster>)((EntityType)RatsEntityRegistry.RAT_KING.get()), this.m_9236_());
            king.m_20359_((Entity)this);
            ForgeEventFactory.onFinalizeSpawn((Mob)king, (ServerLevelAccessor)((ServerLevelAccessor)this.m_9236_()), (DifficultyInstance)this.m_9236_().m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.CONVERSION, null, null);
            this.m_9236_().m_7967_((Entity)king);
            this.m_146870_();
        }
    }

    @Override
    public boolean isHoldingItemInHands() {
        return (this.isBecomingRatKing() || this.isEating()) && this.sleepProgress <= 0.0f;
    }

    protected boolean m_8028_() {
        return this.hasPlague();
    }

    protected void m_7472_(DamageSource source, int looting, boolean playerKill) {
        if (this.hasToga()) {
            this.m_5552_(new ItemStack((ItemLike)RatlantisItemRegistry.RAT_TOGA.get()), 0.0f);
        }
        super.m_7472_(source, looting, playerKill);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(accessor, difficulty, type, data, tag);
        if (this.m_217043_().m_188503_(15) == 0 && this.m_9236_().m_46791_() != Difficulty.PEACEFUL && type != MobSpawnType.CONVERSION) {
            this.setPlagued(true);
        }
        if (accessor.m_6018_().m_46472_().equals(RatlantisDimensionRegistry.DIMENSION_KEY)) {
            this.setToga(true);
        }
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            if (RatsDateFetcher.isHalloweenSeason() && this.m_217043_().m_188501_() <= 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Blocks.f_50143_));
                this.m_21508_(EquipmentSlot.HEAD);
            } else if (RatsDateFetcher.isChristmasSeason() && this.m_217043_().m_188501_() <= (RatsDateFetcher.isChristmasDay() ? 1.0f : 0.25f) || RatConfig.ratsSpawnWithSantaHats && this.m_217043_().m_188503_(100) == 0) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RatsItemRegistry.SANTA_HAT.get()));
                this.m_21508_(EquipmentSlot.HEAD);
            } else if (RatsDateFetcher.isNewYearsEve() && this.m_217043_().m_188501_() <= 0.25f || RatsDateFetcher.isAlexsBDay() || RatsDateFetcher.isGizmosBDay() || RatConfig.ratsSpawnWithPartyHats && this.m_217043_().m_188503_(100) == 0) {
                ItemStack stack = new ItemStack((ItemLike)RatsItemRegistry.PARTY_HAT.get());
                ((DyeableLeatherItem)stack.m_41720_()).m_41115_(stack, (int)(this.m_217043_().m_188501_() * 1.6777215E7f));
                this.m_8061_(EquipmentSlot.HEAD, stack);
                this.m_21508_(EquipmentSlot.HEAD);
            } else if (RatsDateFetcher.isPirateDay() && this.m_217043_().m_188501_() <= 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RatsItemRegistry.PIRAT_HAT.get()));
                this.m_21508_(EquipmentSlot.HEAD);
            }
        }
        if (this.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && RatsDateFetcher.isChristmasDay() && this.m_217043_().m_188501_() <= 0.75f) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)RatsItemRegistry.TINY_COIN.get()));
            this.m_21508_(EquipmentSlot.MAINHAND);
        }
        return data;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.hasPlague()) {
            if (itemstack.m_150930_((Item)RatsItemRegistry.FILTH_CORRUPTION.get()) && this.m_9236_().m_6436_(this.m_20183_()).m_19048_() != Difficulty.PEACEFUL) {
                this.m_5496_((SoundEvent)RatsSoundRegistry.RAT_KING_SUMMON.get(), 1.0f, 1.5f);
                if (!this.m_21205_().m_41619_()) {
                    this.m_19983_(this.m_21205_());
                    this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
                this.m_21008_(InteractionHand.MAIN_HAND, player.m_21120_(hand).m_255036_(1));
                this.m_20088_().m_135381_(RAT_KING_TRANSFORMATION, (Object)true);
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.m_9236_().m_5776_() && itemstack.m_150930_((Item)RatsItemRegistry.CREATIVE_CHEESE.get())) {
                TamedRat rat = RatUtils.tameRat(this, this.m_9236_());
                this.m_9236_().m_7605_((Entity)rat, (byte)83);
                rat.m_21828_(player);
                rat.setCommand(RatCommand.SIT);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41647_(player, (LivingEntity)this, hand) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public boolean isBecomingRatKing() {
        return (Boolean)this.m_20088_().m_135370_(RAT_KING_TRANSFORMATION);
    }

    public boolean hasToga() {
        return (Boolean)this.m_20088_().m_135370_(TOGA);
    }

    public void setToga(boolean toga) {
        this.m_20088_().m_135381_(TOGA, (Object)toga);
    }

    public boolean hasPlague() {
        return (Boolean)this.m_20088_().m_135370_(PLAGUE);
    }

    public void setPlagued(boolean plague) {
        this.m_20088_().m_135381_(PLAGUE, (Object)plague);
    }

    public boolean m_6673_(DamageSource source) {
        return this.isBecomingRatKing() || super.m_6673_(source);
    }

    public boolean m_20147_() {
        return super.m_20147_() || this.isBecomingRatKing();
    }

    public static boolean checkRatSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor accessor, MobSpawnType type, BlockPos pos, RandomSource random) {
        if (random.m_188503_(16) == 0) {
            return type == MobSpawnType.SPAWNER || Rat.spawnCheck(accessor, pos, random, type);
        }
        return false;
    }

    private static boolean spawnCheck(LevelAccessor accessor, BlockPos pos, RandomSource random, MobSpawnType type) {
        ServerLevelAccessor server;
        if (!accessor.m_6106_().m_5470_().m_46207_(RatsMod.SPAWN_RATS)) {
            return false;
        }
        if (type != MobSpawnType.NATURAL) {
            return true;
        }
        int spawnRoll = RatConfig.ratSpawnDecrease;
        if (accessor instanceof ServerLevelAccessor && (server = (ServerLevelAccessor)accessor).m_6018_().m_46472_().equals(RatlantisDimensionRegistry.DIMENSION_KEY)) {
            return spawnRoll <= 0 || random.m_188503_(spawnRoll) == 0;
        }
        if (RatConfig.ratsSpawnLikeMonsters) {
            if (accessor.m_46791_() == Difficulty.PEACEFUL) {
                spawnRoll *= 2;
            }
            if (spawnRoll == 0 || accessor.m_213780_().m_188503_(spawnRoll) == 0) {
                BlockState state = accessor.m_8055_(pos.m_7495_());
                return Rat.isValidLightLevel(accessor, random, pos) && state.m_60643_((BlockGetter)accessor, pos.m_7495_(), (EntityType)RatsEntityRegistry.RAT.get());
            }
        } else {
            return (spawnRoll /= 2) <= 0 || random.m_188503_(spawnRoll) == 0;
        }
        return false;
    }

    @Override
    public boolean m_5545_(LevelAccessor accessor, MobSpawnType type) {
        return Rat.spawnCheck(accessor, this.m_20183_(), accessor.m_213780_(), type);
    }

    public Component m_7755_() {
        if (!this.m_8077_() && this.hasPlague()) {
            return Component.m_237115_((String)"entity.rats.plague_rat");
        }
        return super.m_7755_();
    }

    public int m_8100_() {
        return this.hasPlague() ? 200 : super.m_8100_();
    }

    @Override
    @Nullable
    protected SoundEvent m_7515_() {
        if (this.hasPlague() && this.m_5448_() != null) {
            return (SoundEvent)RatsSoundRegistry.RAT_GROWL.get();
        }
        return super.m_7515_();
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag && this.hasPlague()) {
            LivingEntity living;
            this.m_19970_((LivingEntity)this, entity);
            if (entity instanceof LivingEntity && this.rollForPlague(living = (LivingEntity)entity)) {
                ForgeEvents.maybeAddAndSyncPlague((LivingEntity)this, living, 6000, 0);
            }
        }
        return flag;
    }

    protected void m_7324_(Entity entity) {
        if (!this.m_9236_().m_5776_() && this.hasPlague()) {
            LivingEntity living;
            Rat rat;
            if (entity instanceof Rat && !(rat = (Rat)entity).hasPlague()) {
                rat.setPlagued(true);
            } else if (entity instanceof LivingEntity && this.rollForPlague(living = (LivingEntity)entity)) {
                ForgeEvents.maybeAddAndSyncPlague(null, living, 6000, 0);
            }
        }
        super.m_7324_(entity);
    }

    private boolean rollForPlague(LivingEntity target) {
        boolean mask;
        boolean bl = mask = target.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)RatsItemRegistry.PLAGUE_DOCTOR_MASK.get()) || target.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)RatsItemRegistry.BLACK_DEATH_MASK.get());
        if (mask) {
            return this.m_217043_().m_188501_() < 0.3f;
        }
        return true;
    }
}

