/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.events;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.data.tags.RatsEntityTags;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsCapabilityRegistry;
import com.github.alexthe666.rats.registry.RatsEffectRegistry;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsLootRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.registry.RatsVillagerRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisDimensionRegistry;
import com.github.alexthe666.rats.server.capability.SelectedRatCapability;
import com.github.alexthe666.rats.server.entity.misc.PlagueDoctor;
import com.github.alexthe666.rats.server.entity.projectile.ArrowlikeProjectile;
import com.github.alexthe666.rats.server.entity.projectile.PlagueShot;
import com.github.alexthe666.rats.server.entity.rat.DemonRat;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.RatSackItem;
import com.github.alexthe666.rats.server.items.RatStaffItem;
import com.github.alexthe666.rats.server.message.DismountRatPacket;
import com.github.alexthe666.rats.server.message.ManageRatStaffPacket;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.github.alexthe666.rats.server.message.SyncArmSwingPacket;
import com.github.alexthe666.rats.server.message.SyncPlaguePacket;
import com.github.alexthe666.rats.server.misc.PlagueDoctorTrades;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.github.alexthe666.rats.server.misc.RatUtils;
import com.github.alexthe666.rats.server.world.PlagueDoctorSpawner;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="rats", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onPlayerInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        PlagueDoctor doctor;
        Villager villager;
        Entity i2;
        Sheep sheep;
        ItemStack heldItem = event.getEntity().m_21120_(event.getHand());
        Entity entity = event.getTarget();
        if (entity instanceof Sheep && (sheep = (Sheep)entity).m_29874_() != DyeColor.WHITE && event.getEntity().m_21120_(event.getHand()).m_150930_(((Block)RatsBlockRegistry.DYE_SPONGE.get()).m_5456_())) {
            sheep.m_29855_(DyeColor.WHITE);
            for (int i2 = 0; i2 < 8; ++i2) {
                double d0 = sheep.m_217043_().m_188583_() * 0.02;
                double d1 = sheep.m_217043_().m_188583_() * 0.02;
                double d2 = sheep.m_217043_().m_188583_() * 0.02;
                sheep.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)RatsBlockRegistry.DYE_SPONGE.get())), sheep.m_20185_() + (double)(sheep.m_217043_().m_188501_() * sheep.m_20205_() * 2.0f) - (double)sheep.m_20205_(), sheep.m_20186_() + (double)(sheep.m_217043_().m_188501_() * sheep.m_20206_() * 2.0f) - (double)sheep.m_20206_(), sheep.m_20189_() + (double)(sheep.m_217043_().m_188501_() * sheep.m_20205_() * 2.0f) - (double)sheep.m_20205_(), d0, d1, d2);
            }
            sheep.m_5496_((SoundEvent)RatsSoundRegistry.DYE_SPONGE_USED.get(), 1.0f, 1.0f);
        }
        if (heldItem.m_150930_((Item)RatsItemRegistry.PLAGUE_DOCTORATE.get()) && (i2 = event.getTarget()) instanceof Villager && !(villager = (Villager)i2).m_6162_() && (villager.m_7141_().m_35571_() == VillagerProfession.f_35596_ || villager.m_7141_().m_35571_() == VillagerProfession.f_35585_) && (doctor = (PlagueDoctor)villager.m_21406_((EntityType)RatsEntityRegistry.PLAGUE_DOCTOR.get(), true)) != null) {
            doctor.setWillDespawn(false);
            event.getEntity().m_6674_(event.getHand());
            event.getLevel().m_5594_(null, doctor.m_20183_(), (SoundEvent)RatsSoundRegistry.PLAGUE_DOCTOR_SUMMON.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            if (!event.getEntity().m_7500_()) {
                heldItem.m_41774_(1);
            }
        }
        if ((entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ForgeEvents.maybeAddAndSyncPlague((LivingEntity)event.getEntity(), living, 6000, 0);
        }
    }

    public static int getProtectorCount(LivingEntity entity) {
        int protectors = 0;
        if (entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)RatlantisItemRegistry.RATLANTIS_HELMET.get())) {
            ++protectors;
        }
        if (entity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)RatlantisItemRegistry.RATLANTIS_CHESTPLATE.get())) {
            ++protectors;
        }
        if (entity.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)RatlantisItemRegistry.RATLANTIS_LEGGINGS.get())) {
            ++protectors;
        }
        if (entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)RatlantisItemRegistry.RATLANTIS_BOOTS.get())) {
            ++protectors;
        }
        return protectors;
    }

    @SubscribeEvent
    public static void piglinsDontAttackGoldRatsEver(LivingChangeTargetEvent event) {
        TamedRat rat;
        LivingEntity livingEntity;
        if (event.getEntity() instanceof Piglin && (livingEntity = event.getNewTarget()) instanceof TamedRat && RatUpgradeUtils.hasUpgrade(rat = (TamedRat)livingEntity, (Item)RatsItemRegistry.RAT_UPGRADE_IDOL.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void sculkedRatsDontEmitVibrations(VanillaGameEvent event) {
        TamedRat rat;
        Entity entity = event.getCause();
        if (entity instanceof TamedRat && RatUpgradeUtils.hasUpgrade(rat = (TamedRat)entity, (Item)RatsItemRegistry.RAT_UPGRADE_SCULKED.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void spawnAngelRat(LivingDeathEvent event) {
        TamedRat rat;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof TamedRat && RatUpgradeUtils.hasUpgrade(rat = (TamedRat)livingEntity, (Item)RatsItemRegistry.RAT_UPGRADE_ANGEL.get())) {
            event.setCanceled(true);
            rat.spawnAngelCopy();
            rat.m_216990_((SoundEvent)RatsSoundRegistry.RAT_DIE.get());
            LivingEntity livingEntity2 = rat.m_269323_();
            if (livingEntity2 instanceof Player) {
                Player player = (Player)livingEntity2;
                player.m_213846_((Component)Component.m_237110_((String)"entity.rats.rat.respawn_angel", (Object[])new Object[]{rat.m_7755_().getString()}));
            }
            rat.m_146870_();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void ejectRatsOutOfSack(ItemExpireEvent event) {
        if (event.getEntity().m_32055_().m_150930_((Item)RatsItemRegistry.RAT_SACK.get()) && RatSackItem.getRatsInSack(event.getEntity().m_32055_()) > 0) {
            RatSackItem.ejectRatsFromSack(event.getEntity().m_32055_(), event.getEntity().m_9236_(), event.getEntity().m_20183_());
        }
    }

    @SubscribeEvent
    public static void hackySetFireFix(LivingAttackEvent event) {
        TamedRat rat;
        Entity entity;
        if (!event.getEntity().m_5825_() && (entity = event.getSource().m_7639_()) instanceof TamedRat && RatUpgradeUtils.hasUpgrade(rat = (TamedRat)entity, (Item)RatsItemRegistry.RAT_UPGRADE_DEMON.get())) {
            event.getEntity().m_20254_(1);
        }
    }

    @SubscribeEvent
    public static void checkIfPlagueCanApplyToMob(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().m_19544_() == RatsEffectRegistry.PLAGUE.get() && event.getEntity().m_6095_().m_204039_(RatsEntityTags.PLAGUE_IMMUNE)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onHitEntity(LivingAttackEvent event) {
        Entity trueSource;
        int protectors;
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ForgeEvents.maybeAddAndSyncPlague(living, event.getEntity(), 6000, 0);
        }
        if ((protectors = ForgeEvents.getProtectorCount(event.getEntity())) > 0 && event.getSource() != null && event.getSource().m_7639_() != null && (double)(trueSource = event.getSource().m_7639_()).m_20270_((Entity)event.getEntity()) < 4.0) {
            trueSource.m_6469_(event.getEntity().m_269291_().m_269425_(), 0.75f * (float)protectors);
            Vec3 vec3d = trueSource.m_20184_();
            double strength = 0.15 * (double)protectors;
            Vec3 vec3d1 = new Vec3(event.getEntity().m_20185_() - trueSource.m_20185_(), 0.0, event.getEntity().m_20189_() - trueSource.m_20189_()).m_82541_().m_82490_(strength);
            trueSource.m_20334_(vec3d.f_82479_ / 2.0 - vec3d1.f_82479_, trueSource.m_20096_() ? Math.min(0.4, vec3d.f_82480_ / 2.0 + strength) : vec3d.f_82480_, vec3d.f_82481_ / 2.0 - vec3d1.f_82481_);
        }
    }

    @SubscribeEvent
    public static void addPlagueDoctorSpawning(LevelEvent.Load event) {
        ServerLevel server;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (server = (ServerLevel)levelAccessor).m_46472_().equals(Level.f_46428_)) {
            ArrayList<PlagueDoctorSpawner> spawners = new ArrayList<PlagueDoctorSpawner>(server.f_8558_);
            spawners.add(new PlagueDoctorSpawner(server));
            server.f_8558_ = spawners;
        }
    }

    @SubscribeEvent
    public static void maybeSendPlayerWarning(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundTag playerData;
        CompoundTag data;
        if (!event.getEntity().m_9236_().m_46469_().m_46207_(GameRules.f_46132_) && (data = (playerData = event.getEntity().getPersistentData()).m_128469_("PlayerPersisted")) != null && !data.m_128471_("rats_griefing_warning")) {
            event.getEntity().m_5661_((Component)Component.m_237115_((String)"entity.rats.rat.griefing").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}), false);
            data.m_128379_("rats_griefing_warning", true);
            playerData.m_128365_("PlayerPersisted", (Tag)data);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Husk husk;
        Entity entity;
        if (event.getEntity() != null && (entity = event.getEntity()) instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            if (RatConfig.golemsTargetRats) {
                golem.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)golem, Rat.class, true, RatUtils.UNTAMED_RAT_SELECTOR));
            }
        }
        if (event.getEntity() != null && RatUtils.isPredator(event.getEntity()) && (entity = event.getEntity()) instanceof Animal) {
            Animal animal = (Animal)entity;
            animal.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)animal, Rat.class, true, RatUtils.UNTAMED_RAT_SELECTOR));
        }
        if (event.getEntity() != null && (entity = event.getEntity()) instanceof Husk && (husk = (Husk)entity).m_217043_().m_188501_() < 0.12f) {
            husk.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RatsItemRegistry.ARCHEOLOGIST_HAT.get()));
            husk.m_21409_(EquipmentSlot.HEAD, 1.0f);
        }
        if (event.getEntity() != null && (entity = event.getEntity()) instanceof AbstractSkeleton) {
            AbstractSkeleton skele = (AbstractSkeleton)entity;
            if (event.getEntity().m_9236_().m_204166_(event.getEntity().m_20183_()).m_203656_(BiomeTags.f_207610_) && skele.m_217043_().m_188501_() < 0.25f) {
                skele.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)RatsItemRegistry.ARCHEOLOGIST_HAT.get()));
                skele.m_21409_(EquipmentSlot.HEAD, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void spawnStriderJockeys(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob;
        if (event.getDifficulty().m_19048_() != Difficulty.PEACEFUL && (event.getSpawnType() == MobSpawnType.CHUNK_GENERATION || event.getSpawnType() == MobSpawnType.NATURAL) && (mob = event.getEntity()) instanceof Strider) {
            DemonRat demonRat;
            Strider strider = (Strider)mob;
            if (event.getEntity().m_6095_() == EntityType.f_20482_ && !strider.m_6162_() && !strider.m_6254_() && strider.m_20197_().isEmpty() && strider.m_217043_().m_188501_() < 0.1f && (demonRat = (DemonRat)((EntityType)RatsEntityRegistry.DEMON_RAT.get()).m_20615_((Level)event.getLevel().m_6018_())) != null) {
                demonRat.m_7678_(strider.m_20185_(), strider.m_20186_(), strider.m_20189_(), strider.m_146908_(), 0.0f);
                demonRat.m_6518_(event.getLevel(), event.getDifficulty(), MobSpawnType.JOCKEY, null, null);
                demonRat.m_7998_((Entity)strider, true);
                demonRat.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42685_));
                strider.m_5853_(null);
            }
        }
    }

    @SubscribeEvent
    public static void makeCentipede(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().m_150930_((Item)RatsItemRegistry.LITTLE_BLACK_WORM.get()) && event.getLevel().m_8055_(event.getHitVec().m_82425_()).m_60713_(Blocks.f_50546_)) {
            event.getItemStack().m_41774_(1);
            ItemStack centipede = new ItemStack((ItemLike)RatsItemRegistry.CENTIPEDE.get());
            if (!event.getEntity().m_36356_(centipede.m_41777_())) {
                event.getEntity().m_36176_(centipede, false);
            }
            event.getEntity().m_6674_(event.getHand());
            event.getLevel().m_46597_(event.getHitVec().m_82425_(), Blocks.f_50493_.m_49966_());
            event.getLevel().m_5594_(null, event.getHitVec().m_82425_(), SoundEvents.f_144206_, SoundSource.BLOCKS, 2.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void ratlantisFishing(ItemFishedEvent event) {
        FishingHook hook = event.getHookEntity();
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (RatsMod.RATLANTIS_DATAPACK_ENABLED && level.m_46472_().equals(RatlantisDimensionRegistry.DIMENSION_KEY)) {
            event.getDrops().clear();
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)hook.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)ForgeEvents.checkHandsForRod(player)).m_287286_(LootContextParams.f_81458_, (Object)player).m_287286_(LootContextParams.f_81455_, (Object)hook).m_287239_((float)hook.f_37096_ + player.m_36336_());
            LootTable loottable = level.m_7654_().m_278653_().m_278676_(RatsLootRegistry.RATLANTIS_FISH);
            ObjectArrayList list = loottable.m_287195_(builder.m_287235_(LootContextParamSets.f_81414_));
            event.getDrops().addAll((Collection)list);
        }
    }

    private static ItemStack checkHandsForRod(Player player) {
        if (player.m_21205_().canPerformAction(ToolActions.FISHING_ROD_CAST)) {
            return player.m_21205_();
        }
        if (player.m_21206_().canPerformAction(ToolActions.FISHING_ROD_CAST)) {
            return player.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    @SubscribeEvent
    public static void initVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == RatsVillagerRegistry.PET_SHOP_OWNER.get()) {
            ((List)event.getTrades().get(1)).add(new PlagueDoctorTrades.ItemsToEmeralds((ItemLike)Items.f_42500_, 12, 12, 1));
            ((List)event.getTrades().get(1)).add(new PlagueDoctorTrades.ItemsToEmeralds((ItemLike)Items.f_42583_, 11, 12, 1));
            ((List)event.getTrades().get(1)).add(new PlagueDoctorTrades.ItemsToEmeralds((ItemLike)Items.f_42526_, 10, 12, 1));
            ((List)event.getTrades().get(1)).add(new PlagueDoctorTrades.ItemsToEmeralds((ItemLike)Items.f_42401_, 12, 12, 1));
            ((List)event.getTrades().get(1)).add(new PlagueDoctorTrades.ItemsToEmeralds((ItemLike)Items.f_42521_, 16, 12, 1));
            ((List)event.getTrades().get(1)).add(new PlagueDoctorTrades.ItemsToEmeralds((ItemLike)RatsItemRegistry.RAW_RAT.get(), 11, 12, 1));
            ((List)event.getTrades().get(1)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.CHEESE.get(), 1, 5, 1));
            ((List)event.getTrades().get(2)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.COOKED_RAT.get(), 1, 5, 5));
            ((List)event.getTrades().get(2)).add(new PlagueDoctorTrades.ItemsAndEmeraldsToItems((ItemLike)RatsBlockRegistry.GARBAGE_PILE.get(), 10, 3, (Item)RatsItemRegistry.PLASTIC_WASTE.get(), 10, 12, 5));
            ((List)event.getTrades().get(2)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsBlockRegistry.MARBLED_CHEESE_RAW.get(), 1, 8, 5));
            ((List)event.getTrades().get(2)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsBlockRegistry.GARBAGE_PILE.get(), 1, 6, 5));
            ((List)event.getTrades().get(2)).add(new PlagueDoctorTrades.ItemsToEmeralds((ItemLike)RatsItemRegistry.RAW_PLASTIC.get(), 5, 12, 5));
            ((List)event.getTrades().get(2)).add(new PlagueDoctorTrades.ItemsToEmeralds((ItemLike)RatsItemRegistry.RAT_FLUTE.get(), 1, 12, 5));
            ((List)event.getTrades().get(3)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.ARCHEOLOGIST_HAT.get(), 12, 1, 10));
            ((List)event.getTrades().get(3)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.SANTA_HAT.get(), 20, 1, 15));
            ((List)event.getTrades().get(3)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.PARTY_HAT.get(), 20, 1, 15));
            ((List)event.getTrades().get(3)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.HALO_HAT.get(), 8, 1, 10));
            ((List)event.getTrades().get(3)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.EXTERMINATOR_HAT.get(), 14, 1, 10));
            ((List)event.getTrades().get(4)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.RAT_UPGRADE_BASIC.get(), 5, 1, 20));
            ((List)event.getTrades().get(4)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.RAT_UPGRADE_JURY_RIGGED.get(), 16, 1, 20));
            ((List)event.getTrades().get(4)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.RAT_UPGRADE_BLACKLIST.get(), 8, 1, 20));
            ((List)event.getTrades().get(4)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.RAT_UPGRADE_WHITELIST.get(), 8, 1, 20));
            ((List)event.getTrades().get(4)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.RAT_UPGRADE_SPEED.get(), 10, 1, 20));
            ((List)event.getTrades().get(4)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.RAT_UPGRADE_HEALTH.get(), 10, 1, 20));
            ((List)event.getTrades().get(4)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.RAT_UPGRADE_ARMOR.get(), 10, 1, 20));
            ((List)event.getTrades().get(5)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.PLAGUE_DOCTORATE.get(), 10, 1, 30));
            ((List)event.getTrades().get(5)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.PLAGUE_TOME.get(), 32, 1, 30));
            ((List)event.getTrades().get(5)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.RAT_PAPERS.get(), 5, 1, 30));
            ((List)event.getTrades().get(5)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.CHARGED_CREEPER_CHUNK.get(), 3, 1, 30));
            ((List)event.getTrades().get(5)).add(new PlagueDoctorTrades.EmeraldsToItems((ItemLike)RatsItemRegistry.TINY_COIN.get(), 1, 8, 30));
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getLevel().m_5776_()) {
            if (event.getEntity().m_6144_() && !event.getEntity().m_20197_().isEmpty()) {
                for (Entity passenger : event.getEntity().m_20197_()) {
                    if (!(passenger instanceof TamedRat)) continue;
                    passenger.m_8127_();
                    Vec3 dismountPos = passenger.m_7688_((LivingEntity)event.getEntity());
                    passenger.m_6034_(dismountPos.m_7096_(), dismountPos.m_7098_(), dismountPos.m_7094_());
                    RatsNetworkHandler.CHANNEL.sendToServer((Object)new DismountRatPacket(passenger.m_19879_()));
                }
            }
            ForgeEvents.handleArmSwing(event.getItemStack(), event.getEntity());
            RatsNetworkHandler.CHANNEL.sendToServer((Object)new SyncArmSwingPacket(event.getItemStack()));
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        List list;
        if (event.getEntity() instanceof Player && !(list = event.getEntity().m_9236_().m_6443_(TamedRat.class, event.getEntity().m_20191_().m_82400_(RatConfig.ratVoodooDistance), rat -> rat.m_21824_() && rat.m_21830_(event.getEntity()) && !rat.m_20147_() && !rat.m_6673_(event.getSource()) && RatUpgradeUtils.hasUpgrade(rat, (Item)RatsItemRegistry.RAT_UPGRADE_VOODOO.get()))).isEmpty()) {
            float damage = event.getAmount() / (float)list.size();
            event.setCanceled(true);
            for (TamedRat rat2 : list) {
                rat2.m_6469_(event.getSource(), damage);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        if (event.getEntity().m_21023_((MobEffect)RatsEffectRegistry.PLAGUE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        RandomSource rand;
        if (event.getEntity().m_9236_().m_5776_() && event.getEntity().m_21023_((MobEffect)RatsEffectRegistry.PLAGUE.get()) && (rand = event.getEntity().m_217043_()).m_188503_(4) == 0) {
            int entitySize = 1;
            if (event.getEntity().m_20191_().m_82309_() > 0.0) {
                entitySize = Math.max(1, (int)event.getEntity().m_20191_().m_82309_());
            }
            for (int i = 0; i < entitySize; ++i) {
                float motionX = rand.m_188501_() * 0.1f - 0.05f;
                float motionZ = rand.m_188501_() * 0.1f - 0.05f;
                event.getEntity().m_9236_().m_7106_((ParticleOptions)RatsParticleRegistry.FLEA.get(), event.getEntity().m_20185_() + (double)(rand.m_188501_() * event.getEntity().m_20205_() * 2.0f) - (double)event.getEntity().m_20205_(), event.getEntity().m_20186_() + (double)(rand.m_188501_() * event.getEntity().m_20206_()), event.getEntity().m_20189_() + (double)(rand.m_188501_() * event.getEntity().m_20205_() * 2.0f) - (double)event.getEntity().m_20205_(), (double)motionX, 0.0, (double)motionZ);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getEntity().m_21120_(event.getHand());
        Item item = stack.m_41720_();
        if (item instanceof RatStaffItem) {
            RatStaffItem staff = (RatStaffItem)item;
            event.setUseBlock(Event.Result.DENY);
            event.setCancellationResult(InteractionResult.FAIL);
            event.setCanceled(true);
            TamedRat rat = null;
            if (event.getEntity().getCapability(RatsCapabilityRegistry.SELECTED_RAT).resolve().isPresent()) {
                rat = ((SelectedRatCapability)event.getEntity().getCapability(RatsCapabilityRegistry.SELECTED_RAT).resolve().get()).getSelectedRat();
            }
            if (rat != null) {
                event.getEntity().m_6674_(event.getHand());
                if (!event.getLevel().m_5776_()) {
                    RatsNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new ManageRatStaffPacket(rat.m_19879_(), event.getPos(), event.getFace().ordinal(), false, true, staff.getStaff(stack)));
                }
            } else {
                event.getEntity().m_5661_((Component)Component.m_237115_((String)"item.rats.staff.no_rat").m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    public static void maybeAddAndSyncPlague(@Nullable LivingEntity attacker, LivingEntity victim, int duration, int amplifier) {
        if (RatConfig.plagueSpread && !victim.m_9236_().m_5776_() && (attacker == null || attacker.m_21023_((MobEffect)RatsEffectRegistry.PLAGUE.get()))) {
            MobEffectInstance plague = new MobEffectInstance((MobEffect)RatsEffectRegistry.PLAGUE.get(), duration, amplifier);
            if (!victim.m_21023_((MobEffect)RatsEffectRegistry.PLAGUE.get()) && victim.m_7301_(plague)) {
                victim.m_7292_(plague);
                victim.m_5496_((SoundEvent)RatsSoundRegistry.PLAGUE_SPREAD.get(), 1.0f, 1.0f);
                RatsNetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> victim), (Object)new SyncPlaguePacket(victim.m_19879_(), plague));
            }
        }
    }

    public static void handleArmSwing(ItemStack stack, Player player) {
        if (stack.m_150930_((Item)RatsItemRegistry.PLAGUE_SCYTHE.get()) && player.f_20913_ == 0 && !player.m_5833_()) {
            Multimap dmg = stack.m_41638_(EquipmentSlot.MAINHAND);
            double totalDmg = 0.0;
            for (AttributeModifier modifier : dmg.get((Object)Attributes.f_22281_)) {
                totalDmg += modifier.m_22218_();
            }
            player.m_5496_((SoundEvent)RatsSoundRegistry.PLAGUE_CLOUD_SHOOT.get(), 1.0f, 1.0f);
            PlagueShot shot = new PlagueShot((EntityType<? extends ArrowlikeProjectile>)((EntityType)RatsEntityRegistry.PLAGUE_SHOT.get()), player.m_9236_(), (LivingEntity)player, totalDmg * 0.5);
            Vec3 vec3 = player.m_20252_(1.0f);
            shot.m_6686_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 1.0f, 0.5f);
            player.m_9236_().m_7967_((Entity)shot);
        }
    }
}

