/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.events;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.message.ChangeRatlantisStatusPacket;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="rats", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RatlantisPackEvents {
    @SubscribeEvent
    public static void checkDatapackOnWorldLoad(LevelEvent.Load event) {
        ServerLevel server;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (server = (ServerLevel)levelAccessor).m_46472_().equals(Level.f_46428_) && event.getLevel().m_7654_() != null) {
            boolean enabled;
            RatsMod.RATLANTIS_DATAPACK_ENABLED = enabled = event.getLevel().m_7654_().m_129910_().m_6645_().f_244096_().m_45850_().contains("ratlantis");
            RatsNetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ChangeRatlantisStatusPacket(enabled));
            RatsMod.LOGGER.debug("Overworld loaded! Ratlantis datapack is {} for this world.", (Object)(enabled ? "enabled" : "disabled"));
        }
    }

    @SubscribeEvent
    public static void checkDatapackOnSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            boolean enabled;
            RatsMod.RATLANTIS_DATAPACK_ENABLED = enabled = event.getPlayer().m_284548_().m_7654_().m_129910_().m_6645_().f_244096_().m_45850_().contains("ratlantis");
            RatsNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((OnDatapackSyncEvent)event).getPlayer()), (Object)new ChangeRatlantisStatusPacket(enabled));
            RatsMod.LOGGER.debug("Ratlantis datapack flag has been set to {} for {} ({})", (Object)enabled, (Object)event.getPlayer().m_5446_().getString(), (Object)event.getPlayer().m_20149_());
        } else {
            event.getPlayerList().m_11314_().forEach(player -> {
                boolean enabled;
                RatsMod.RATLANTIS_DATAPACK_ENABLED = enabled = player.m_284548_().m_7654_().m_129910_().m_6645_().f_244096_().m_45850_().contains("ratlantis");
                RatsNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ChangeRatlantisStatusPacket(enabled));
                RatsMod.LOGGER.debug("Ratlantis datapack flag has been set to {} for {} ({})", (Object)enabled, (Object)player.m_5446_().getString(), (Object)player.m_20149_());
            });
        }
    }
}

