/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RatSackItem
extends Item {
    public RatSackItem(Item.Properties properties) {
        super(properties);
    }

    public static void packRatIntoSack(ItemStack sack, TamedRat rat, int ratCount) {
        CompoundTag tag = sack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            sack.m_41751_(tag);
        }
        CompoundTag ratTag = new CompoundTag();
        rat.m_7380_(ratTag);
        if (rat.m_8077_()) {
            ratTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)rat.m_7770_()));
        }
        tag.m_128365_("Rat_" + ratCount, (Tag)ratTag);
    }

    public static int getRatsInSack(ItemStack sack) {
        int ratCount = 0;
        if (sack.m_41783_() != null) {
            for (String tagInfo : sack.m_41783_().m_128431_()) {
                if (!tagInfo.contains("Rat")) continue;
                ++ratCount;
            }
        }
        return ratCount;
    }

    public static int ejectRatsFromSack(ItemStack stack, Level level, BlockPos pos) {
        int ratCount = 0;
        if (stack.m_41783_() != null) {
            for (String tagInfo : stack.m_41783_().m_128431_()) {
                if (!tagInfo.contains("Rat")) continue;
                ++ratCount;
                CompoundTag ratTag = stack.m_41783_().m_128469_(tagInfo);
                TamedRat rat = new TamedRat((EntityType<? extends TamableAnimal>)((EntityType)RatsEntityRegistry.TAMED_RAT.get()), level);
                rat.m_7378_(ratTag);
                if (!ratTag.m_128461_("CustomName").isEmpty()) {
                    rat.m_6593_((Component)Component.Serializer.m_130701_((String)ratTag.m_128461_("CustomName")));
                }
                rat.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                if (level.m_5776_()) continue;
                level.m_7967_((Entity)rat);
            }
        }
        return ratCount;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int ratCount = 0;
        ArrayList<String> ratNames = new ArrayList<String>();
        if (stack.m_41783_() != null) {
            for (String tagInfo : stack.m_41783_().m_128431_()) {
                MutableComponent ratNameTag;
                if (!tagInfo.contains("Rat")) continue;
                CompoundTag ratTag = stack.m_41783_().m_128469_(tagInfo);
                ++ratCount;
                String ratName = I18n.m_118938_((String)"entity.rats.rat", (Object[])new Object[0]);
                if (!ratTag.m_128461_("CustomName").isEmpty() && (ratNameTag = Component.Serializer.m_130701_((String)ratTag.m_128461_("CustomName"))) != null) {
                    ratName = ratNameTag.getString();
                }
                ratNames.add(ratName);
            }
        }
        tooltip.add((Component)Component.m_237110_((String)"item.rats.rat_sack.contains", (Object[])new Object[]{ratCount, RatConfig.ratSackCapacity}).m_130940_(ChatFormatting.GRAY));
        if (!ratNames.isEmpty()) {
            for (int i = 0; i < ratNames.size() && i < 3; ++i) {
                tooltip.add((Component)Component.m_237113_((String)((String)ratNames.get(i))).m_130940_(ChatFormatting.GRAY));
            }
            if (ratNames.size() > 3) {
                tooltip.add((Component)Component.m_237110_((String)"rats.and_more", (Object[])new Object[]{ratNames.size() - 3}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        int ratCount;
        ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
        if (stack.m_150930_((Item)RatsItemRegistry.RAT_SACK.get()) && RatSackItem.getRatsInSack(stack) > 0 && (ratCount = RatSackItem.ejectRatsFromSack(stack, context.m_43725_(), context.m_8083_().m_121945_(context.m_43719_()))) > 0) {
            context.m_43723_().m_5661_((Component)Component.m_237110_((String)"item.rats.rat_sack.release", (Object[])new Object[]{ratCount}), true);
            stack.m_41751_(new CompoundTag());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onDestroyed(ItemEntity entity, DamageSource source) {
        ItemStack stack = entity.m_32055_();
        if (RatSackItem.getRatsInSack(stack) > 0) {
            RatSackItem.ejectRatsFromSack(stack, entity.m_9236_(), entity.m_20183_());
        }
    }
}

