/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.registry.RatsRecipeRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.TickRatUpgrade;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class ChefRatUpgradeItem
extends BaseRatUpgradeItem
implements TickRatUpgrade {
    public ChefRatUpgradeItem(Item.Properties properties) {
        super(properties, 2, 2);
    }

    @Override
    public boolean isRatHoldingFood(TamedRat rat) {
        return false;
    }

    @Override
    public boolean shouldDepositItem(TamedRat rat, ItemStack stack) {
        return this.getCookingResultFor(rat, stack).m_41619_();
    }

    @Override
    public void tick(TamedRat rat) {
        if (!rat.m_21205_().m_41619_()) {
            this.tryCooking(rat);
            this.createFinishedParticles(rat, (ParticleOptions)ParticleTypes.f_123762_, 3, (ParticleOptions)ParticleTypes.f_123744_, 0.125f);
        }
    }

    private void tryCooking(TamedRat rat) {
        ItemStack heldItem = rat.m_21205_();
        ItemStack burntItem = this.getCookingResultFor(rat, heldItem.m_255036_(1));
        if (burntItem.m_41619_()) {
            rat.cookingProgress = 0;
        } else {
            ++rat.cookingProgress;
            if (rat.cookingProgress == 100) {
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    rat.m_21008_(InteractionHand.MAIN_HAND, burntItem);
                } else if (!rat.tryDepositItemInContainers(burntItem) && !rat.m_9236_().m_5776_()) {
                    rat.m_5552_(burntItem, 0.25f);
                }
                rat.cookingProgress = 0;
            }
        }
    }

    private ItemStack getCookingResultFor(TamedRat rat, ItemStack stack) {
        ItemStack itemstack;
        ItemStack specialChefRecipe = rat.getResultForRecipe((RecipeType<? extends SingleItemRecipe>)((RecipeType)RatsRecipeRegistry.CHEF.get()), stack);
        if (!specialChefRecipe.m_41619_()) {
            return specialChefRecipe.m_41777_();
        }
        Optional optional = rat.m_9236_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), rat.m_9236_());
        if (optional.isPresent() && !(itemstack = ((SmeltingRecipe)optional.get()).m_8043_(rat.m_9236_().m_9598_())).m_41619_()) {
            ItemStack itemstack1 = itemstack.m_41777_();
            itemstack1.m_41764_(stack.m_41613_() * itemstack.m_41613_());
            return itemstack1;
        }
        return ItemStack.f_41583_;
    }
}

