/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.client.gui.RatScreen;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.inventory.RatMenu;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record OpenRatScreenPacket(int containerId, int entityId) {
    public static OpenRatScreenPacket decode(FriendlyByteBuf buf) {
        return new OpenRatScreenPacket(buf.readInt(), buf.readInt());
    }

    public static void encode(OpenRatScreenPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.containerId());
        buf.writeInt(packet.entityId());
    }

    public static class Handler {
        public static void handle(final OpenRatScreenPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId());
                    if (entity instanceof TamedRat) {
                        TamedRat rat = (TamedRat)entity;
                        LocalPlayer localplayer = Minecraft.m_91087_().f_91074_;
                        SimpleContainer container = new SimpleContainer(6);
                        RatMenu menu = new RatMenu(packet.containerId(), (Container)container, localplayer.m_150109_());
                        localplayer.f_36096_ = menu;
                        Minecraft.m_91087_().m_91152_((Screen)new RatScreen(menu, localplayer.m_150109_(), rat));
                    }
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

