/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.network.NetworkEvent;

public record RatUpgradeVisibilityPacket(int ratId, EquipmentSlot slot, boolean visible) {
    public static RatUpgradeVisibilityPacket decode(FriendlyByteBuf buf) {
        return new RatUpgradeVisibilityPacket(buf.readInt(), EquipmentSlot.m_20747_((String)buf.m_130277_().toLowerCase(Locale.ROOT)), buf.readBoolean());
    }

    public static void encode(RatUpgradeVisibilityPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.ratId());
        buf.m_130070_(packet.slot().name());
        buf.writeBoolean(packet.visible());
    }

    public static class Handler {
        public static void handle(RatUpgradeVisibilityPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(packet.ratId())) instanceof TamedRat) {
                    TamedRat rat = (TamedRat)entity;
                    rat.setSlotVisibility(packet.slot(), packet.visible());
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

