/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record SyncRatStaffPacket(int entityId, long pos, int facing, int control, int extraData) {
    public SyncRatStaffPacket(int entityId, BlockPos pos, Direction facing, int control) {
        this(entityId, pos.m_121878_(), facing.ordinal(), control, 0);
    }

    public SyncRatStaffPacket(int entityId, BlockPos pos, Direction facing, int control, int extraData) {
        this(entityId, pos.m_121878_(), facing.ordinal(), control, extraData);
    }

    public static SyncRatStaffPacket decode(FriendlyByteBuf buf) {
        return new SyncRatStaffPacket(buf.readInt(), buf.readLong(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void encode(SyncRatStaffPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityId());
        buf.writeLong(packet.pos());
        buf.writeInt(packet.facing());
        buf.writeInt(packet.control());
        buf.writeInt(packet.extraData());
    }

    public static class Handler {
        public static void handle(SyncRatStaffPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Entity e;
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (e = player.m_9236_().m_6815_(packet.entityId())) instanceof TamedRat) {
                    TamedRat rat = (TamedRat)e;
                    switch (packet.control) {
                        case 0: {
                            rat.setDepositPos(GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)BlockPos.m_122022_((long)packet.pos())));
                            rat.depositFacing = Direction.values()[packet.facing()];
                            break;
                        }
                        case 1: {
                            rat.setPickupPos(GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)BlockPos.m_122022_((long)packet.pos())));
                            break;
                        }
                        case 2: {
                            rat.setHomePoint(GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)BlockPos.m_122022_((long)packet.pos())));
                            break;
                        }
                        case 3: {
                            rat.setHomePoint(null);
                            break;
                        }
                        case 4: {
                            rat.setRadiusCenter(GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)BlockPos.m_122022_((long)packet.pos())));
                            break;
                        }
                        case 5: {
                            rat.setRadius(packet.extraData());
                            break;
                        }
                        case 6: {
                            rat.setRadiusCenter(null);
                            rat.setRadius(RatConfig.defaultRatRadius);
                            break;
                        }
                        case 7: {
                            rat.setPickupPos(null);
                            rat.setDepositPos(null);
                        }
                    }
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

