/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.misc;

import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class PlagueDoctorTrades {
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> PLAGUE_DOCTOR_TRADES;
    public static final VillagerTrades.ItemListing COMBINER_TRADE;
    public static final VillagerTrades.ItemListing SEPARATOR_TRADE;
    public static final VillagerTrades.ItemListing UPGRADE_COMBINED_TRADE;

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> createTrades(ImmutableMap<Integer, VillagerTrades.ItemListing[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    static {
        COMBINER_TRADE = new ItemsAndEmeraldsToItems((ItemLike)RatsItemRegistry.RAT_UPGRADE_GOD.get(), 1, 40, ((Block)RatsBlockRegistry.UPGRADE_COMBINER.get()).m_5456_(), 1, 1, 30);
        SEPARATOR_TRADE = new ItemsAndEmeraldsToItems((ItemLike)RatsItemRegistry.RAT_UPGRADE_JURY_RIGGED.get(), 1, 4, ((Block)RatsBlockRegistry.UPGRADE_SEPARATOR.get()).m_5456_(), 1, 1, 30);
        UPGRADE_COMBINED_TRADE = new EmeraldsToItems((ItemLike)RatsItemRegistry.RAT_UPGRADE_COMBINED.get(), 6, 1, 1);
        PLAGUE_DOCTOR_TRADES = PlagueDoctorTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsToEmeralds((ItemLike)RatsItemRegistry.RAW_RAT.get(), 10, 12, 1), new ItemsToEmeralds((ItemLike)Items.f_42500_, 10, 12, 1), new ItemsToEmeralds((ItemLike)Items.f_42583_, 10, 12, 1), new ItemsToEmeralds((ItemLike)Items.f_42591_, 5, 12, 1), new ItemsToEmeralds((ItemLike)Items.f_42586_, 2, 12, 2), new ItemsToEmeralds((ItemLike)Items.f_42714_, 4, 12, 2), new ItemsToEmeralds((ItemLike)Items.f_42675_, 2, 12, 2), new ItemsToEmeralds((ItemLike)RatsItemRegistry.CONTAMINATED_FOOD.get(), 5, 12, 2), new EmeraldsToItems((ItemLike)RatsItemRegistry.COOKED_RAT.get(), 1, 5, 1), new ItemsAndEmeraldsToItems((ItemLike)Items.f_41940_, 5, 1, (Item)RatsItemRegistry.HERB_BUNDLE.get(), 3, 12, 2), new EmeraldsToItems((ItemLike)RatsItemRegistry.TREACLE.get(), 1, 2, 1), new EmeraldsToItems((ItemLike)RatsBlockRegistry.GARBAGE_PILE.get(), 1, 4, 3), new EmeraldsToItems((ItemLike)RatsBlockRegistry.CURSED_GARBAGE.get(), 1, 2, 3), new EmeraldsToItems((ItemLike)RatsBlockRegistry.PURIFIED_GARBAGE.get(), 1, 2, 3), new EmeraldsToItems((ItemLike)RatsBlockRegistry.PIED_WOOL.get(), 3, 1, 5, 5), new EmeraldsToItems((ItemLike)RatsItemRegistry.PLAGUE_DOCTOR_MASK.get(), 15, 1, 2, 5), new EmeraldsToItems((ItemLike)RatsItemRegistry.RAT_SKULL.get(), 3, 1, 3)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new EmeraldsToItems((ItemLike)RatsItemRegistry.PLAGUE_LEECH.get(), 2, 1, 5), new EmeraldsToItems((ItemLike)RatsItemRegistry.PLAGUE_STEW.get(), 5, 1, 7), new EmeraldsToItems((ItemLike)RatsItemRegistry.FILTH.get(), 3, 1, 7), new EmeraldsToItems((ItemLike)RatsItemRegistry.PURIFYING_LIQUID.get(), 8, 1, 7), new EmeraldsToItems((ItemLike)RatsItemRegistry.TOKEN_FRAGMENT.get(), 5, 1, 2, 5), new EmeraldsToItems((ItemLike)RatsItemRegistry.RAT_UPGRADE_BASIC.get(), 1, 2, 5), new EmeraldsToItems((ItemLike)RatsItemRegistry.PLAGUE_ESSENCE.get(), 2, 1, 5), new EmeraldsToItems((ItemLike)RatsItemRegistry.GOLDEN_RAT_SKULL.get(), 4, 1, 7), new EmeraldsToItems((ItemLike)RatsItemRegistry.PLAGUE_TOME.get(), 32, 1, 1, 15)}));
    }

    public static class ItemsAndEmeraldsToItems
    implements VillagerTrades.ItemListing {
        private final ItemStack fromItem;
        private final int fromCount;
        private final int emeraldCost;
        private final ItemStack toItem;
        private final int toCount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsAndEmeraldsToItems(ItemLike fromItem, int amountToGive, int emeraldCost, Item toItem, int amountToReceive, int tradeUses, int xp) {
            this.fromItem = new ItemStack(fromItem);
            this.fromCount = amountToGive;
            this.emeraldCost = emeraldCost;
            this.toItem = new ItemStack((ItemLike)toItem);
            this.toCount = amountToReceive;
            this.maxUses = tradeUses;
            this.villagerXp = xp;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)this.fromItem.m_41720_(), this.fromCount), new ItemStack((ItemLike)this.toItem.m_41720_(), this.toCount), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class EmeraldsToItems
    implements VillagerTrades.ItemListing {
        private final ItemStack itemStack;
        private final int emeraldCost;
        private final int numberOfItems;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public EmeraldsToItems(ItemLike item, int emeraldCost, int itemAmountToRecieve, int tradeUses, int xp) {
            this(new ItemStack(item), emeraldCost, itemAmountToRecieve, tradeUses, xp);
        }

        public EmeraldsToItems(ItemLike item, int emeraldCost, int itemAmountToRecieve, int xp) {
            this(new ItemStack(item), emeraldCost, itemAmountToRecieve, 12, xp);
        }

        public EmeraldsToItems(ItemStack stack, int emeraldCost, int itemAmountToRecieve, int tradeUses, int xp) {
            this(stack, emeraldCost, itemAmountToRecieve, tradeUses, xp, 0.05f);
        }

        public EmeraldsToItems(ItemStack stack, int emeraldCost, int itemAmountToRecieve, int tradeUses, int xp, float multiplier) {
            this.itemStack = stack;
            this.emeraldCost = emeraldCost;
            this.numberOfItems = itemAmountToRecieve;
            this.maxUses = tradeUses;
            this.villagerXp = xp;
            this.priceMultiplier = multiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)this.itemStack.m_41720_(), this.numberOfItems), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class ItemsToEmeralds
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int amount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsToEmeralds(ItemLike item, int itemAmountToGive, int uses, int xp) {
            this.item = item.m_5456_();
            this.amount = itemAmountToGive;
            this.maxUses = uses;
            this.villagerXp = xp;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack itemstack = new ItemStack((ItemLike)this.item, this.amount);
            return new MerchantOffer(itemstack, new ItemStack((ItemLike)Items.f_42616_), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }
}

