/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.misc;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.DyeColor;

public class RatColorUtil {
    private static final Map<DyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(color -> color, RatColorUtil::createRatColor)));

    public static float[] getDyeRgb(DyeColor color) {
        return DYE_TO_RGB.get(color);
    }

    private static float[] createRatColor(DyeColor color) {
        if (color == DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = color.m_41068_();
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }
}

