/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.misc;

import com.github.alexthe666.rats.registry.RatVariantRegistry;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class RatVariant {
    private final ResourceLocation texture;
    private final String name;
    private final boolean breedingExclusive;

    public RatVariant(Properties properties) {
        this(properties.texture, properties.name, properties.breedingExclusive);
    }

    private RatVariant(ResourceLocation texture, String name, boolean breedingExclusive) {
        this.texture = texture;
        this.name = name;
        this.breedingExclusive = breedingExclusive;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBreedingExclusive() {
        return this.breedingExclusive;
    }

    public static RatVariant getRandomVariant(RandomSource random, boolean fromBreeding) {
        ArrayList<RatVariant> validVariants = new ArrayList<RatVariant>(RatVariantRegistry.RAT_VARIANT_REGISTRY.get().getValues().stream().toList());
        validVariants.removeIf(variant -> !fromBreeding && variant.isBreedingExclusive() || !variant.getName().isEmpty());
        return ((RatVariant[])validVariants.toArray(RatVariant[]::new))[random.m_188503_(validVariants.size())];
    }

    public static RatVariant getRandomBreedingExclusiveVariant(RandomSource random) {
        ArrayList<RatVariant> validVariants = new ArrayList<RatVariant>(RatVariantRegistry.RAT_VARIANT_REGISTRY.get().getValues().stream().toList());
        validVariants.removeIf(variant -> !variant.isBreedingExclusive());
        return ((RatVariant[])validVariants.toArray(RatVariant[]::new))[random.m_188503_(validVariants.size())];
    }

    public static RatVariant getVariant(String id) {
        return Optional.ofNullable((RatVariant)RatVariantRegistry.RAT_VARIANT_REGISTRY.get().getValue(new ResourceLocation(id))).orElse((RatVariant)RatVariantRegistry.BLUE.get());
    }

    public static String getVariantId(RatVariant variant) {
        return Optional.ofNullable(RatVariantRegistry.RAT_VARIANT_REGISTRY.get().getKey((Object)variant)).orElse(RatVariantRegistry.RAT_VARIANT_REGISTRY.get().getKey((Object)((RatVariant)RatVariantRegistry.BLUE.get()))).toString();
    }

    public static class Properties {
        private final ResourceLocation texture;
        private String name = "";
        private boolean breedingExclusive = false;

        public Properties(ResourceLocation texture) {
            this.texture = texture;
        }

        public Properties setNamingExclusive(String name) {
            this.name = name;
            return this;
        }

        public Properties setBreedingExclusive() {
            this.breedingExclusive = true;
            return this;
        }

        public static Properties copyFrom(RatVariant rat) {
            Properties props = new Properties(rat.getTexture());
            props.name = rat.name;
            props.breedingExclusive = rat.breedingExclusive;
            return props;
        }
    }
}

