/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.capability.ReputationEntry;
import elucent.eidolon.capability.ReputationImpl;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.spell.PrayerSpell;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public interface IReputation {
    public static final Capability<IReputation> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IReputation>(){});

    public double getReputation(UUID var1, ResourceLocation var2);

    public void addReputation(UUID var1, ResourceLocation var2, double var3);

    public void subtractReputation(UUID var1, ResourceLocation var2, double var3);

    public void setReputation(UUID var1, ResourceLocation var2, double var3);

    public boolean isLocked(UUID var1, ResourceLocation var2);

    public boolean hasLock(UUID var1, ResourceLocation var2, ResourceLocation var3);

    public void lock(UUID var1, ResourceLocation var2, ResourceLocation var3);

    public boolean unlock(UUID var1, ResourceLocation var2, ResourceLocation var3);

    public void pray(UUID var1, PrayerSpell var2, long var3);

    public boolean canPray(UUID var1, PrayerSpell var2, long var3);

    default public double getReputation(Player player, ResourceLocation deity) {
        return this.getReputation(player.m_20148_(), deity);
    }

    default public void considerChange(Player player, ResourceLocation deity, double prev) {
        double amount = this.getReputation(player, deity);
        Deity d = Deities.find(deity);
        if (d != null && amount != prev) {
            d.onReputationChange(player, this, prev, amount);
        }
    }

    default public void addReputation(Player player, ResourceLocation deity, double amount) {
        double prev = this.getReputation(player.m_20148_(), deity);
        this.addReputation(player.m_20148_(), deity, amount);
        this.considerChange(player, deity, prev);
    }

    default public void subtractReputation(Player player, ResourceLocation deity, double amount) {
        double prev = this.getReputation(player.m_20148_(), deity);
        this.subtractReputation(player.m_20148_(), deity, amount);
        this.considerChange(player, deity, prev);
    }

    default public void setReputation(Player player, ResourceLocation deity, double amount) {
        double prev = this.getReputation(player.m_20148_(), deity);
        this.setReputation(player.m_20148_(), deity, amount);
        this.considerChange(player, deity, prev);
    }

    default public void pray(Player player, PrayerSpell spell, long time) {
        this.pray(player.m_20148_(), spell, time);
    }

    default public boolean canPray(Player player, PrayerSpell spell, long time) {
        return player.m_7500_() || this.canPray(player.m_20148_(), spell, time);
    }

    public Map<UUID, Map<ResourceLocation, Long>> getPrayerTimes();

    public Map<UUID, Map<ResourceLocation, ReputationEntry>> getReputationMap();

    default public Map<ResourceLocation, Long> getPrayerTimeMap(UUID player) {
        return this.getPrayerTimes().computeIfAbsent(player, k -> new HashMap());
    }

    default public Map<ResourceLocation, ReputationEntry> getReputationMap(UUID player) {
        return this.getReputationMap().computeIfAbsent(player, k -> new HashMap());
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        final ReputationImpl impl = new ReputationImpl();

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            if (cap == INSTANCE) {
                return LazyOptional.of(() -> this.impl);
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.deserializeNBT(nbt);
        }
    }
}

