/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.deity;

import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.capability.Facts;
import elucent.eidolon.common.deity.DeityLocks;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.util.KnowledgeUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class DarkDeity
extends Deity {
    public DarkDeity(ResourceLocation id, int red, int green, int blue) {
        super(id, red, green, blue);
        this.progression.add(new Deity.Stage(DeityLocks.SACRIFICE_MOB, 3, true).requirement(new Deity.ResearchRequirement(DeityLocks.SACRIFICE_MOB))).add(new Deity.Stage(DeityLocks.SACRIFICE_VILLAGER, 15, true).requirement(new Deity.ResearchRequirement(DeityLocks.SACRIFICE_VILLAGER))).add(new Deity.Stage(DeityLocks.ZOMBIFY_VILLAGER, 35, true).requirement(new Deity.ResearchRequirement(DeityLocks.ZOMBIFY_VILLAGER))).add(new Deity.Stage(DeityLocks.ENTHRALL_UNDEAD, 50, true).requirement(new Deity.ResearchRequirement(DeityLocks.ENTHRALL_UNDEAD))).setMax(100);
    }

    @Override
    public void onReputationUnlock(Player player, ResourceLocation lock) {
        if (lock.equals((Object)DeityLocks.SACRIFICE_MOB)) {
            KnowledgeUtil.grantSign((Entity)player, Signs.SOUL_SIGN);
        } else if (lock.equals((Object)DeityLocks.SACRIFICE_VILLAGER)) {
            KnowledgeUtil.grantSign((Entity)player, Signs.MIND_SIGN);
        } else if (lock.equals((Object)DeityLocks.ZOMBIFY_VILLAGER)) {
            KnowledgeUtil.grantSign((Entity)player, Signs.HARMONY_SIGN);
        } else if (lock.equals((Object)DeityLocks.ENTHRALL_UNDEAD)) {
            KnowledgeUtil.grantSign((Entity)player, Signs.WARDING_SIGN);
        }
    }

    @Override
    public void onReputationLock(Player player, ResourceLocation lock) {
        if (lock.equals((Object)DeityLocks.SACRIFICE_MOB)) {
            KnowledgeUtil.grantSign((Entity)player, Signs.BLOOD_SIGN);
        } else if (lock.equals((Object)DeityLocks.SACRIFICE_VILLAGER)) {
            KnowledgeUtil.grantFact((Entity)player, Facts.VILLAGER_SACRIFICE);
        } else if (lock.equals((Object)DeityLocks.ZOMBIFY_VILLAGER)) {
            KnowledgeUtil.grantFact((Entity)player, Facts.ZOMBIFY);
            KnowledgeUtil.grantSign((Entity)player, Signs.DEATH_SIGN);
        } else if (lock.equals((Object)DeityLocks.ENTHRALL_UNDEAD)) {
            KnowledgeUtil.grantFact((Entity)player, Facts.ENTHRALL);
            KnowledgeUtil.grantSign((Entity)player, Signs.MAGIC_SIGN);
        }
    }
}

