/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.common.item.model.BonelordArmorModel;
import elucent.eidolon.registries.EidolonAttributes;
import elucent.eidolon.registries.Registry;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.extensions.IForgeItem;
import org.jetbrains.annotations.NotNull;

public class BonelordArmorItem
extends ArmorItem
implements IForgeItem {
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};

    public BonelordArmorItem(ArmorItem.Type slot, Item.Properties builderIn) {
        super((ArmorMaterial)Material.INSTANCE, slot, builderIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack) {
        ImmutableMultimap.Builder attributes = new ImmutableMultimap.Builder();
        attributes.putAll(super.m_7167_(pEquipmentSlot));
        if (this.f_265916_.m_266308_() == pEquipmentSlot) {
            UUID uuid = (UUID)f_265987_.get(this.f_265916_);
            attributes.put((Object)((Attribute)EidolonAttributes.PERSISTENT_SOUL_HEARTS.get()), (Object)new AttributeModifier(uuid, "eidolon:bonelord_ethereal_hearts", this.m_40402_() == EquipmentSlot.CHEST ? 20.0 : 10.0, AttributeModifier.Operation.ADDITION));
        }
        return attributes.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public BonelordArmorModel getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel _default) {
                float pticks = Minecraft.m_91087_().m_91296_();
                float f = Mth.m_14189_((float)pticks, (float)entity.f_20884_, (float)entity.f_20883_);
                float f1 = Mth.m_14189_((float)pticks, (float)entity.f_20886_, (float)entity.f_20885_);
                float netHeadYaw = f1 - f;
                float netHeadPitch = Mth.m_14179_((float)pticks, (float)entity.f_19860_, (float)entity.m_146909_());
                ClientRegistry.BONELORD_ARMOR_MODEL.slot = BonelordArmorItem.this.m_40402_();
                ClientRegistry.BONELORD_ARMOR_MODEL.copyFromDefault(_default);
                ClientRegistry.BONELORD_ARMOR_MODEL.m_6973_(entity, entity.f_267362_.m_267756_(), entity.f_267362_.m_267731_(), (float)entity.f_19797_ + pticks, netHeadYaw, netHeadPitch);
                return ClientRegistry.BONELORD_ARMOR_MODEL;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "eidolon:textures/entity/bonelord_armor.png";
    }

    public static class Material
    implements ArmorMaterial {
        public static final Material INSTANCE = new Material();

        public int m_266425_(ArmorItem.Type slot) {
            return MAX_DAMAGE_ARRAY[slot.m_266308_().m_20749_()] * 38;
        }

        public int m_7366_(ArmorItem.Type slot) {
            return switch (slot) {
                case ArmorItem.Type.CHESTPLATE -> 9;
                case ArmorItem.Type.HELMET -> 4;
                case ArmorItem.Type.LEGGINGS -> 7;
                default -> 0;
            };
        }

        public int m_6646_() {
            return 25;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return ArmorMaterials.TURTLE.m_7344_();
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Registry.IMBUED_BONES.get())});
        }

        @NotNull
        public String m_6082_() {
            return "eidolon:bonelord";
        }

        public float m_6651_() {
            return 2.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

