/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.altar.AltarInfo;
import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.common.deity.DeityLocks;
import elucent.eidolon.common.spell.PrayerSpell;
import elucent.eidolon.common.tile.EffigyTileEntity;
import elucent.eidolon.common.tile.GobletTileEntity;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VillagerSacrificeSpell
extends PrayerSpell {
    public VillagerSacrificeSpell(ResourceLocation name, Deity deity, int baseRep, double powerMult, Sign ... signs) {
        super(name, deity, baseRep, powerMult, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        if (this.reputationCheck(world, player, 15.0)) {
            return false;
        }
        EffigyTileEntity effigy = VillagerSacrificeSpell.getEffigy(world, pos);
        GobletTileEntity goblet = VillagerSacrificeSpell.getGoblet(world, pos);
        if (effigy == null || goblet == null || goblet.getEntityType() == null) {
            return false;
        }
        AltarInfo info = AltarInfo.getAltarInfo(world, effigy.m_58899_());
        if (info.getAltar() != Registry.STONE_ALTAR.get() || info.getIcon() != Registry.ELDER_EFFIGY.get()) {
            return false;
        }
        return (goblet.getEntityType() == EntityType.f_20532_ || goblet.getEntityType().m_20615_(world) instanceof AbstractVillager) && effigy.ready();
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        EffigyTileEntity effigy = VillagerSacrificeSpell.getEffigy(world, pos);
        GobletTileEntity goblet = VillagerSacrificeSpell.getGoblet(world, pos);
        if (effigy == null || goblet == null || goblet.getEntityType() == null) {
            return;
        }
        if (!world.f_46443_) {
            effigy.pray();
            goblet.setEntityType(null);
            AltarInfo info = AltarInfo.getAltarInfo(world, effigy.m_58899_());
            world.getCapability(IReputation.INSTANCE, null).ifPresent(rep -> {
                rep.pray(player, (PrayerSpell)this, world.m_46467_());
                KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.SACRIFICE_VILLAGER);
                rep.addReputation(player, this.deity.getId(), 6.0 + this.getPowerMultiplier() * info.getPower());
                VillagerSacrificeSpell.updateMagic(info, player, world, rep.getReputation(player, this.deity.getId()));
            });
        } else {
            this.playSuccessSound(world, player, effigy, Signs.SOUL_SIGN);
        }
    }
}

