/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import elucent.eidolon.capability.IPlayerData;
import elucent.eidolon.client.ClientConfig;
import elucent.eidolon.common.item.IWingsItem;
import elucent.eidolon.common.spell.DarkTouchSpell;
import elucent.eidolon.common.spell.LightTouchSpell;
import elucent.eidolon.util.RenderUtil;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="eidolon", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    @OnlyIn(value=Dist.CLIENT)
    static MultiBufferSource.BufferSource DELAYED_RENDER = null;
    @OnlyIn(value=Dist.CLIENT)
    static float clientTicks = 0.0f;
    @OnlyIn(value=Dist.CLIENT)
    public static Matrix4f particleMVMatrix = null;
    public static int jumpTicks = 0;
    public static boolean wasJumping = false;

    @OnlyIn(value=Dist.CLIENT)
    public static MultiBufferSource.BufferSource getDelayedRender() {
        if (DELAYED_RENDER == null) {
            HashMap<RenderType, BufferBuilder> buffers = new HashMap<RenderType, BufferBuilder>();
            for (RenderType type : new RenderType[]{RenderUtil.VAPOR_TRANSLUCENT, RenderUtil.DELAYED_PARTICLE, RenderUtil.GLOWING_PARTICLE, RenderUtil.GLOWING_BLOCK_PARTICLE, RenderUtil.GLOWING, RenderUtil.GLOWING_SPRITE}) {
                buffers.put(type, new BufferBuilder(ModList.get().isLoaded("rubidium") ? 262144 : type.m_110507_()));
            }
            DELAYED_RENDER = MultiBufferSource.m_109900_(buffers, (BufferBuilder)new BufferBuilder(ModList.get().isLoaded("rubidium") ? 262144 : 256));
        }
        return DELAYED_RENDER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLast() {
        if (((Boolean)ClientConfig.BETTER_LAYERING.get()).booleanValue()) {
            PoseStack viewStack = RenderSystem.getModelViewStack();
            viewStack.m_85836_();
            viewStack.m_166856_();
            if (particleMVMatrix != null) {
                viewStack.m_252931_(particleMVMatrix);
            }
            RenderSystem.applyModelViewMatrix();
            RenderSystem.blendFunc((int)770, (int)771);
            ClientEvents.getDelayedRender().m_109912_(RenderUtil.DELAYED_PARTICLE);
            RenderSystem.blendFunc((int)770, (int)1);
            ClientEvents.getDelayedRender().m_109912_(RenderUtil.GLOWING_PARTICLE);
            ClientEvents.getDelayedRender().m_109912_(RenderUtil.GLOWING_BLOCK_PARTICLE);
            viewStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            ClientEvents.getDelayedRender().m_109912_(RenderUtil.GLOWING_SPRITE);
            ClientEvents.getDelayedRender().m_109912_(RenderUtil.GLOWING);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderStages(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            ClientEvents.onRenderLast();
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            clientTicks += event.getPartialTick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getClientTicks() {
        return clientTicks;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.CLIENT) {
            return;
        }
        Player p = event.player;
        if (p instanceof LocalPlayer) {
            LocalPlayer lp = (LocalPlayer)p;
            p.getCapability(IPlayerData.INSTANCE).ifPresent(d -> {
                ItemStack wings = d.getWingsItem(p);
                if (!d.canFlap(p)) {
                    return;
                }
                if (!(wings.m_41720_() instanceof IWingsItem)) {
                    return;
                }
                if (lp.f_108618_.f_108572_ && (!wasJumping || jumpTicks > 0)) {
                    if (++jumpTicks > 20) {
                        jumpTicks = 20;
                    }
                } else if (wasJumping && jumpTicks > 0) {
                    if (jumpTicks >= 20 && !d.isDashing(p)) {
                        d.tryDash(p);
                    } else {
                        d.tryFlapWings(p);
                    }
                    jumpTicks = 0;
                }
            });
            if (p.m_20096_()) {
                jumpTicks = 0;
            }
            wasJumping = p.m_20096_() || lp.f_108618_.f_108572_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void tooltip(ItemTooltipEvent event) {
        CompoundTag tag = event.getItemStack().m_41783_();
        if (tag != null) {
            if (tag.m_128441_(DarkTouchSpell.NECROTIC_KEY)) {
                event.getToolTip().add(Component.m_237115_((String)"eidolon.tooltip.necrotic").m_130940_(ChatFormatting.DARK_BLUE));
            }
            if (tag.m_128441_(LightTouchSpell.SACRED_KEY)) {
                event.getToolTip().add(Component.m_237115_((String)"eidolon.tooltip.sacred").m_130940_(ChatFormatting.GOLD));
            }
        }
    }
}

