/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark;

import dev.dediamondpro.resourcify.libs.commonmark.Extension;
import dev.dediamondpro.resourcify.libs.commonmark.renderer.html.UrlSanitizer;
import dev.dediamondpro.resourcify.libs.minemark.MineMarkCore;
import dev.dediamondpro.resourcify.libs.minemark.elements.Elements;
import dev.dediamondpro.resourcify.libs.minemark.elements.creators.ElementCreator;
import dev.dediamondpro.resourcify.libs.minemark.elements.creators.TagBasedElementCreator;
import dev.dediamondpro.resourcify.libs.minemark.elements.creators.TextElementCreator;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.LinkElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.ParagraphElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.formatting.AlignmentElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.formatting.CssStyleElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.formatting.FormattingElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.list.ListHolderElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.table.TableHolderElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.table.TableRowElement;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MineMarkCoreBuilder<S extends Style, R> {
    private final ArrayList<ElementCreator<S, R>> elements = new ArrayList();
    private final ArrayList<Extension> extensions = new ArrayList();
    private TextElementCreator<S, R> textElement = null;
    private boolean withDefaultElements = true;
    private UrlSanitizer urlSanitizer = null;

    protected MineMarkCoreBuilder() {
    }

    public MineMarkCoreBuilder<S, R> setTextElement(@NotNull TextElementCreator<S, R> textElement) {
        this.textElement = textElement;
        return this;
    }

    public MineMarkCoreBuilder<S, R> addElement(@NotNull ElementCreator<S, R> element) {
        this.elements.add(element);
        return this;
    }

    public MineMarkCoreBuilder<S, R> addElement(@NotNull List<String> tags, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(new TagBasedElementCreator<S, R>(tags, element));
    }

    public MineMarkCoreBuilder<S, R> addElement(@NotNull String tag, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(Collections.singletonList(tag), element);
    }

    public MineMarkCoreBuilder<S, R> addElement(@NotNull Elements elementName, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(elementName.tags, element);
    }

    public MineMarkCoreBuilder<S, R> addElement(int position, @NotNull ElementCreator<S, R> element) {
        this.elements.add(position, element);
        return this;
    }

    public MineMarkCoreBuilder<S, R> addElement(int position, @NotNull List<String> tags, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(position, new TagBasedElementCreator<S, R>(tags, element));
    }

    public MineMarkCoreBuilder<S, R> addElement(int position, @NotNull String tag, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(position, Collections.singletonList(tag), element);
    }

    public MineMarkCoreBuilder<S, R> addElement(int position, @NotNull Elements elementName, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(position, elementName.tags, element);
    }

    public MineMarkCoreBuilder<S, R> addElements(@NotNull List<ElementCreator<S, R>> elements) {
        for (ElementCreator<S, R> element : elements) {
            this.addElement(element);
        }
        return this;
    }

    public MineMarkCoreBuilder<S, R> addExtension(Extension extension) {
        this.extensions.add(extension);
        return this;
    }

    public MineMarkCoreBuilder<S, R> withoutDefaultElements() {
        this.withDefaultElements = false;
        return this;
    }

    public MineMarkCoreBuilder<S, R> setUrlSanitizer(UrlSanitizer urlSanitizer) {
        this.urlSanitizer = urlSanitizer;
        return this;
    }

    public MineMarkCore<S, R> build() {
        if (this.textElement == null) {
            throw new IllegalArgumentException("A text element has to be provided by using \"setTextElement(textElement\"");
        }
        if (this.withDefaultElements) {
            this.addElement(0, Elements.PARAGRAPH, ParagraphElement::new);
            this.addElement(0, Elements.FORMATTING, FormattingElement::new);
            this.addElement(0, Elements.LINK, LinkElement::new);
            this.addElement(0, Elements.LIST_PARENT, ListHolderElement::new);
            this.addElement(0, Elements.TABLE, TableHolderElement::new);
            this.addElement(0, Elements.TABLE_ROW, TableRowElement::new);
            this.addElement(0, new AlignmentElement.AlignmentElementCreator());
            this.addElement(0, new CssStyleElement.CssStyleElementCreator());
        }
        return new MineMarkCore<S, R>(this.textElement, this.elements, this.extensions, this.urlSanitizer);
    }
}

