/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.platform;

import com.google.common.collect.Lists;
import dev.dediamondpro.resourcify.libs.universal.UMinecraft;
import dev.dediamondpro.resourcify.mixins.AbstractResourcePackAccessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001f\u0010\u0003J\r\u0010 \u001a\u00020\u0006\u00a2\u0006\u0004\b \u0010\u0003\u00a8\u0006!"}, d2={"Ldev/dediamondpro/resourcify/platform/Platform;", "", "<init>", "()V", "Lnet/minecraft/server/packs/repository/PackRepository;", "arg", "", "applyResources", "(Lnet/minecraft/server/packs/repository/PackRepository;)V", "Ljava/io/File;", "file", "", "closeResourcePack", "(Ljava/io/File;)I", "position", "enableResourcePack", "(Ljava/io/File;I)V", "", "getMcVersion", "()Ljava/lang/String;", "Lnet/minecraft/server/packs/PackResources;", "resourcePack", "getResourcePackFile", "(Lnet/minecraft/server/packs/PackResources;)Ljava/io/File;", "", "getSelectedResourcePacks", "()Ljava/util/List;", "Lnet/minecraft/client/gui/screens/Screen;", "screen", "getTranslateKey", "(Lnet/minecraft/client/gui/screens/Screen;)Ljava/lang/String;", "reloadResources", "saveSettings", "resourcify"})
@SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\ndev/dediamondpro/resourcify/platform/Platform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1603#2,9:135\n1855#2:144\n1856#2:146\n1612#2:147\n288#2,2:148\n1549#2:150\n1620#2,3:151\n288#2,2:154\n1549#2:156\n1620#2,3:157\n1#3:145\n*S KotlinDebug\n*F\n+ 1 Platform.kt\ndev/dediamondpro/resourcify/platform/Platform\n*L\n55#1:135,9\n55#1:144\n55#1:146\n55#1:147\n69#1:148,2\n80#1:150\n80#1:151,3\n95#1:154,2\n102#1:156\n102#1:157,3\n55#1:145\n*E\n"})
public final class Platform {
    @NotNull
    public static final Platform INSTANCE = new Platform();

    private Platform() {
    }

    @NotNull
    public final String getMcVersion() {
        String string = SharedConstants.m_183709_().m_132493_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCurrentVersion().name");
        return string;
    }

    @NotNull
    public final String getTranslateKey(@NotNull Screen screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        ComponentContents content = screen.m_96636_().m_214077_();
        if (!(content instanceof TranslatableContents)) {
            String optifineTranslation = I18n.m_118938_((String)"of.options.shadersTitle", (Object[])new Object[0]);
            if (!Intrinsics.areEqual((Object)optifineTranslation, (Object)"of.options.shadersTitle") && Intrinsics.areEqual((Object)optifineTranslation, (Object)screen.m_96636_().getString())) {
                return "of.options.shadersTitle";
            }
            String string = screen.m_96636_().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"screen.title.string");
            return string;
        }
        String string = ((TranslatableContents)content).m_237508_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"content.key");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getSelectedResourcePacks() {
        void $this$mapNotNullTo$iv$iv;
        Collection collection = UMinecraft.getMinecraft().m_91099_().m_10524_();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getMinecraft().resourceP\u2026kRepository.selectedPacks");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File file;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pack it = (Pack)element$iv$iv;
            boolean bl2 = false;
            if (!(it.m_10445_() instanceof FilePackResources)) {
                file = null;
            } else {
                PackResources packResources = it.m_10445_();
                Intrinsics.checkNotNullExpressionValue((Object)packResources, (String)"it.open()");
                file = INSTANCE.getResourcePackFile(packResources);
            }
            if (file == null) continue;
            File it$iv$iv = file;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void reloadResources() {
        UMinecraft.getMinecraft().m_91391_();
    }

    /*
     * WARNING - void declaration
     */
    public final int closeResourcePack(@NotNull File file) {
        Object v3;
        ArrayList packs;
        PackRepository repo;
        block6: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            repo = UMinecraft.getMinecraft().m_91099_();
            repo.m_10506_();
            packs = Lists.newArrayList((Iterable)repo.m_10524_());
            Collection collection = UMinecraft.getMinecraft().m_91099_().m_10519_();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getMinecraft().resourceP\u2026Repository.availablePacks");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                Pack it = (Pack)element$iv;
                boolean bl2 = false;
                if (!(it.m_10445_() instanceof FilePackResources)) {
                    bl = false;
                } else {
                    PackResources packResources = it.m_10445_();
                    Intrinsics.checkNotNullExpressionValue((Object)packResources, (String)"it.open()");
                    bl = Intrinsics.areEqual((Object)INSTANCE.getResourcePackFile(packResources), (Object)file);
                }
                if (!bl) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        Pack pack = v3;
        if (pack != null) {
            int index = packs.indexOf(pack);
            if (index != -1) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object element$iv;
                packs.remove(pack);
                Intrinsics.checkNotNullExpressionValue((Object)packs, (String)"packs");
                Iterable $i$f$firstOrNull = packs;
                PackRepository packRepository = repo;
                boolean $i$f$map = false;
                element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pack pack2 = (Pack)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.m_10446_());
                }
                packRepository.m_10509_((Collection)((List)destination$iv$iv));
                Intrinsics.checkNotNullExpressionValue((Object)repo, (String)"repo");
                this.applyResources(repo);
            }
            pack.m_10445_().close();
            return index;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void enableResourcePack(@NotNull File file, int position) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object v3;
        ArrayList arrayList;
        int n;
        ArrayList packs;
        PackRepository repo;
        block5: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            repo = UMinecraft.getMinecraft().m_91099_();
            repo.m_10506_();
            packs = Lists.newArrayList((Iterable)repo.m_10524_());
            Collection collection = repo.m_10519_();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repo.availablePacks");
            Iterable iterable = collection;
            n = position;
            arrayList = packs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                Pack it = (Pack)element$iv;
                boolean bl2 = false;
                if (!(it.m_10445_() instanceof FilePackResources)) {
                    bl = false;
                } else {
                    PackResources packResources = it.m_10445_();
                    Intrinsics.checkNotNullExpressionValue((Object)packResources, (String)"it.open()");
                    bl = Intrinsics.areEqual((Object)INSTANCE.getResourcePackFile(packResources), (Object)file);
                }
                if (!bl) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        Object var16_18 = v3;
        Pack pack = var16_18;
        if (pack == null) {
            return;
        }
        arrayList.add(n, pack);
        Intrinsics.checkNotNullExpressionValue((Object)packs, (String)"packs");
        Iterable iterable = packs;
        arrayList = repo;
        boolean $i$f$map = false;
        void $i$f$firstOrNull = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pack pack2 = (Pack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.m_10446_());
        }
        arrayList.m_10509_((List)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)repo, (String)"repo");
        this.applyResources(repo);
    }

    private final void applyResources(PackRepository arg) {
        UMinecraft.getMinecraft().f_91066_.f_92117_.clear();
        UMinecraft.getMinecraft().f_91066_.f_92118_.clear();
        for (Object e : arg.m_10524_()) {
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type net.minecraft.server.packs.repository.Pack");
            Pack resourcePackInfo = (Pack)e;
            if (resourcePackInfo.m_10450_()) continue;
            UMinecraft.getMinecraft().f_91066_.f_92117_.add(resourcePackInfo.m_10446_());
            if (resourcePackInfo.m_10443_().m_10489_()) continue;
            UMinecraft.getMinecraft().f_91066_.f_92118_.add(resourcePackInfo.m_10446_());
        }
    }

    private final File getResourcePackFile(PackResources resourcePack) {
        Intrinsics.checkNotNull((Object)resourcePack, (String)"null cannot be cast to non-null type dev.dediamondpro.resourcify.mixins.AbstractResourcePackAccessor");
        File file = ((AbstractResourcePackAccessor)resourcePack).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resourcePack as AbstractResourcePackAccessor).file");
        return file;
    }

    public final void saveSettings() {
        UMinecraft.getMinecraft().f_91066_.m_92169_();
    }
}

