/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client;

import immersive_melodies.Config;
import immersive_melodies.client.MelodyProgress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class MelodyProgressManager {
    public static final MelodyProgressManager INSTANCE = new MelodyProgressManager();
    Map<Entity, MelodyProgress> progress = new HashMap<Entity, MelodyProgress>();
    private long lastTime;

    public MelodyProgress getProgress(Entity entity) {
        return this.progress.computeIfAbsent(entity, a -> new MelodyProgress());
    }

    public void setLastIndex(Entity entity, int track, int index) {
        this.getProgress(entity).setLastIndex(track, index);
    }

    public void setLastNote(Entity entity, float volume, float pitch, long length) {
        MelodyProgress progress = this.getProgress(entity);
        progress.lastNoteLongTime = System.currentTimeMillis();
        progress.lastNoteTime = entity.f_19797_;
        progress.lastVolume = volume;
        progress.lastPitch = pitch;
        progress.lastLength = length;
        progress.decayTime = Math.max(4.0f, Math.min(30.0f, (float)length / 50.0f / 2.0f));
        progress.attackTime = Math.min(5.0f, progress.decayTime / 2.0f);
    }

    public boolean isClose(Vec3 pos, float distance) {
        for (Map.Entry<Entity, MelodyProgress> entry : this.progress.entrySet()) {
            if (!entry.getValue().isPlaying() || !(entry.getKey().m_20238_(pos) < (double)(distance * distance))) continue;
            return true;
        }
        return false;
    }

    public void sync(long time) {
        if (this.lastTime != time) {
            this.lastTime = time;
            this.progress.entrySet().removeIf(entry -> ((Entity)entry.getKey()).m_213877_());
            List<Entity> list = MelodyProgressManager.INSTANCE.progress.entrySet().stream().filter(m -> ((MelodyProgress)m.getValue()).isPlaying()).map(Map.Entry::getKey).sorted((a, b) -> {
                boolean b1 = a instanceof Player;
                boolean b2 = b instanceof Player;
                if (b1 && !b2) {
                    return 1;
                }
                if (!b1 && b2) {
                    return -1;
                }
                return this.getProgress((Entity)b).time - this.getProgress((Entity)a).time;
            }).toList();
            block0: for (int i0 = 0; i0 < list.size(); ++i0) {
                Entity entity0 = list.get(i0);
                for (int i1 = list.size() - 1; i1 > i0; --i1) {
                    Entity entity1 = list.get(i1);
                    if (!(entity0.m_20270_(entity1) < (float)Config.getInstance().maxAudibleDistance)) continue;
                    MelodyProgress progress0 = this.getProgress(entity0);
                    MelodyProgress progress1 = this.getProgress(entity1);
                    if (Math.abs(progress0.time - progress1.time) <= 100) continue block0;
                    progress0.overwrite(progress1.getCurrentlyPlaying());
                    progress0.time = progress1.time;
                    progress0.lastIndex.clear();
                    progress0.lastIndex.putAll(progress1.lastIndex);
                    continue block0;
                }
            }
        }
    }
}

