/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.resources;

import net.minecraft.network.FriendlyByteBuf;

public class Note {
    private final int note;
    private final int velocity;
    private final int time;
    private final int length;
    private final int sustain;

    public Note(int note, int velocity, int time, int length, int sustain) {
        this.note = note;
        this.velocity = velocity;
        this.time = time;
        this.length = length;
        this.sustain = sustain;
    }

    public Note(FriendlyByteBuf b) {
        this.note = b.readByte() & 0xFF;
        this.velocity = b.readByte() & 0xFF;
        this.time = b.readInt();
        this.length = b.readInt();
        this.sustain = b.readInt();
    }

    public int getNote() {
        return this.note;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public int getTime() {
        return this.time;
    }

    public int getLength() {
        return this.length;
    }

    public int getSustain() {
        return this.sustain;
    }

    public void encode(FriendlyByteBuf b) {
        b.writeByte(this.note);
        b.writeByte(this.velocity);
        b.writeInt(this.time);
        b.writeInt(this.length);
        b.writeInt(this.sustain);
    }

    public static class Builder {
        public final int note;
        public final int velocity;
        public final int time;
        public int sustain = 9999;
        public int length;

        public Builder(int note, int velocity, int time) {
            this.note = note;
            this.velocity = velocity;
            this.time = time;
        }

        public Note build() {
            return new Note(this.note, this.velocity, this.time, this.length, this.sustain);
        }
    }
}

