/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.config;

import com.copycatsplus.copycats.compat.CopycatsJEI;
import com.copycatsplus.copycats.compat.Mods;
import com.copycatsplus.copycats.config.CCConfigs;
import com.copycatsplus.copycats.config.CFeatureCategories;
import com.copycatsplus.copycats.config.CFeatures;
import com.copycatsplus.copycats.config.FeatureCategory;
import com.copycatsplus.copycats.mixin.feature_toggle.CreativeModeTabsAccessor;
import com.copycatsplus.copycats.multiloader.LogicalSidedProvider;
import com.copycatsplus.copycats.multiloader.Platform;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;

public class FeatureToggle {
    public static final Set<ResourceLocation> TOGGLEABLE_FEATURES = new HashSet<ResourceLocation>();
    public static final Map<ResourceLocation, ResourceLocation> DEPENDENT_FEATURES = new HashMap<ResourceLocation, ResourceLocation>();
    public static final Map<ResourceLocation, Set<FeatureCategory>> FEATURE_CATEGORIES = new HashMap<ResourceLocation, Set<FeatureCategory>>();

    public static void register(ResourceLocation key) {
        TOGGLEABLE_FEATURES.add(key);
    }

    public static void register(ResourceLocation key, FeatureCategory ... categories) {
        FeatureToggle.register(key);
        FEATURE_CATEGORIES.put(key, Set.of(categories));
    }

    public static void registerDependent(ResourceLocation key, ResourceLocation dependency) {
        DEPENDENT_FEATURES.put(key, dependency);
    }

    public static void registerDependent(ResourceLocation key, ResourceLocation dependency, FeatureCategory ... categories) {
        FeatureToggle.registerDependent(key, dependency);
        FEATURE_CATEGORIES.put(key, Set.of(categories));
    }

    public static <R, T extends R, P, S extends Builder<R, T, P, S>> NonNullUnaryOperator<S> register() {
        return b -> {
            FeatureToggle.register(new ResourceLocation(b.getOwner().getModid(), b.getName()));
            return b;
        };
    }

    public static <R, T extends R, P, S extends Builder<R, T, P, S>> NonNullUnaryOperator<S> register(FeatureCategory ... categories) {
        return b -> {
            FeatureToggle.register(new ResourceLocation(b.getOwner().getModid(), b.getName()), categories);
            return b;
        };
    }

    public static <R, T extends R, P, S extends Builder<R, T, P, S>> NonNullUnaryOperator<S> registerDependent(ResourceLocation dependency) {
        return b -> {
            FeatureToggle.registerDependent(new ResourceLocation(b.getOwner().getModid(), b.getName()), dependency);
            return b;
        };
    }

    public static <R, T extends R, P, S extends Builder<R, T, P, S>> NonNullUnaryOperator<S> registerDependent(ResourceLocation dependency, FeatureCategory ... categories) {
        return b -> {
            FeatureToggle.registerDependent(new ResourceLocation(b.getOwner().getModid(), b.getName()), dependency, categories);
            return b;
        };
    }

    public static <R, T extends R, P, S extends Builder<R, T, P, S>> NonNullUnaryOperator<S> registerDependent(BlockEntry<?> dependency) {
        return b -> {
            FeatureToggle.registerDependent(new ResourceLocation(b.getOwner().getModid(), b.getName()), dependency.getId());
            return b;
        };
    }

    public static <R, T extends R, P, S extends Builder<R, T, P, S>> NonNullUnaryOperator<S> registerDependent(BlockEntry<?> dependency, FeatureCategory ... categories) {
        return b -> {
            FeatureToggle.registerDependent(new ResourceLocation(b.getOwner().getModid(), b.getName()), dependency.getId(), categories);
            return b;
        };
    }

    private static CFeatures getToggles() {
        return CCConfigs.common().toggle;
    }

    private static CFeatureCategories getCategories() {
        return CCConfigs.common().categories;
    }

    public static boolean isEnabled(ResourceLocation key) {
        if (FEATURE_CATEGORIES.containsKey(key)) {
            Set<FeatureCategory> categories = FEATURE_CATEGORIES.get(key);
            for (FeatureCategory category : categories) {
                if (FeatureToggle.getCategories().isEnabled(category)) continue;
                return false;
            }
        }
        if (FeatureToggle.getToggles().hasToggle(key)) {
            return FeatureToggle.getToggles().isEnabled(key);
        }
        ResourceLocation dependency = DEPENDENT_FEATURES.get(key);
        if (dependency != null) {
            return FeatureToggle.isEnabled(dependency);
        }
        return true;
    }

    static void refreshItemVisibility() {
        Platform.Environment.CLIENT.runIfCurrent(() -> () -> LogicalSidedProvider.WORKQUEUE.get(Platform.Environment.CLIENT).m_18707_(() -> {
            CreativeModeTab.ItemDisplayParameters cachedParameters = CreativeModeTabsAccessor.getCACHED_PARAMETERS();
            if (cachedParameters != null) {
                CreativeModeTabsAccessor.callBuildAllTabContents(cachedParameters);
            }
            Mods.JEI.executeIfInstalled(() -> CopycatsJEI::refreshItemList);
        }));
    }
}

