/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.model.assembly.forge;

import com.copycatsplus.copycats.content.copycat.base.model.assembly.Assembler;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.GlobalTransform;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableAABB;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableCullFace;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableQuad;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableUV;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableVec3;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableVertex;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.quad.QuadTransform;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Position;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AssemblerImpl {
    public static void assemblePiece(Assembler.CopycatRenderContext<?, ?> ctx, GlobalTransform globalTransform, MutableVec3 offset, MutableAABB select, MutableCullFace cull) {
        CopycatRenderContextForge context = (CopycatRenderContextForge)ctx;
        globalTransform.apply(select);
        globalTransform.apply(offset);
        globalTransform.apply(cull);
        AABB aabb = select.toAABB();
        Vec3 vec3 = offset.toVec3().m_82492_(select.minX, select.minY, select.minZ);
        for (BakedQuad quad : (List)context.source()) {
            if (cull.isCulled(quad.m_111306_())) continue;
            AssemblerImpl.assembleQuad(quad, (List)context.destination(), aabb, vec3);
        }
    }

    public static void assemblePiece(Assembler.CopycatRenderContext<?, ?> ctx, GlobalTransform globalTransform, MutableVec3 offset, MutableAABB select, MutableCullFace cull, QuadTransform ... transforms) {
        CopycatRenderContextForge context = (CopycatRenderContextForge)ctx;
        globalTransform.apply(select);
        globalTransform.apply(offset);
        globalTransform.apply(cull);
        AABB aabb = select.toAABB();
        Vec3 vec3 = offset.toVec3().m_82492_(select.minX, select.minY, select.minZ);
        for (BakedQuad quad : (List)context.source()) {
            if (cull.isCulled(quad.m_111306_())) continue;
            AssemblerImpl.assembleQuad(quad, (List)context.destination(), aabb, vec3, globalTransform, transforms);
        }
    }

    public static void assembleQuad(Assembler.CopycatRenderContext<?, ?> ctx) {
        CopycatRenderContextForge context = (CopycatRenderContextForge)ctx;
        for (BakedQuad quad : (List)context.source()) {
            AssemblerImpl.assembleQuad(quad, (List)context.destination());
        }
    }

    public static <Source extends BakedQuad, Destination extends List<BakedQuad>> void assembleQuad(Source src, Destination dest) {
        dest.add((BakedQuad)BakedQuadHelper.clone(src));
    }

    public static void assembleQuad(Assembler.CopycatRenderContext<?, ?> ctx, AABB crop, Vec3 move) {
        CopycatRenderContextForge context = (CopycatRenderContextForge)ctx;
        for (BakedQuad quad : (List)context.source()) {
            AssemblerImpl.assembleQuad(quad, (List)context.destination(), crop, move);
        }
    }

    public static void assembleQuad(Assembler.CopycatRenderContext<?, ?> ctx, AABB crop, Vec3 move, QuadTransform ... transforms) {
        CopycatRenderContextForge context = (CopycatRenderContextForge)ctx;
        for (BakedQuad quad : (List)context.source()) {
            AssemblerImpl.assembleQuad(quad, (List)context.destination(), crop, move, GlobalTransform.IDENTITY, transforms);
        }
    }

    public static <Source extends BakedQuad, Destination extends List<BakedQuad>> void assembleQuad(Source src, Destination dest, AABB crop, Vec3 move) {
        dest.add((BakedQuad)BakedQuadHelper.cloneWithCustomGeometry(src, (int[])BakedModelHelper.cropAndMove((int[])src.m_111303_(), (TextureAtlasSprite)src.m_173410_(), (AABB)crop, (Vec3)move)));
    }

    public static <Source extends BakedQuad, Destination extends List<BakedQuad>> void assembleQuad(Source src, Destination dest, AABB crop, Vec3 move, GlobalTransform globalTransform, QuadTransform ... transforms) {
        int[] vertices = BakedModelHelper.cropAndMove((int[])src.m_111303_(), (TextureAtlasSprite)src.m_173410_(), (AABB)crop, (Vec3)move);
        MutableQuad mutableQuad = AssemblerImpl.getMutableQuad(new BakedQuad(vertices, src.m_111305_(), src.m_111306_(), src.m_173410_(), src.m_111307_()));
        globalTransform.apply(mutableQuad);
        mutableQuad.undoMutate();
        for (QuadTransform transform : transforms) {
            transform.transformVertices(mutableQuad, src.m_173410_());
        }
        mutableQuad.mutate();
        for (int i = 0; i < 4; ++i) {
            BakedQuadHelper.setXYZ((int[])vertices, (int)i, (Vec3)mutableQuad.vertices.get((int)i).xyz.toVec3());
            BakedQuadHelper.setU((int[])vertices, (int)i, (float)mutableQuad.vertices.get((int)i).uv.u);
            BakedQuadHelper.setV((int[])vertices, (int)i, (float)mutableQuad.vertices.get((int)i).uv.v);
        }
        dest.add((BakedQuad)new BakedQuad(vertices, src.m_111305_(), mutableQuad.direction, src.m_173410_(), src.m_111307_()));
    }

    public static <T> MutableQuad getMutableQuad(T data) {
        BakedQuad quad = (BakedQuad)data;
        int[] vertexData = quad.m_111303_();
        ArrayList<MutableVertex> vertices = new ArrayList<MutableVertex>(4);
        for (int i = 0; i < 4; ++i) {
            MutableVec3 xyz = new MutableVec3((Position)BakedQuadHelper.getXYZ((int[])vertexData, (int)i));
            MutableUV uv = new MutableUV(BakedQuadHelper.getU((int[])vertexData, (int)i), BakedQuadHelper.getV((int[])vertexData, (int)i));
            vertices.add(new MutableVertex(xyz, uv));
        }
        return new MutableQuad(vertices, quad.m_111306_());
    }

    public static class CopycatRenderContextForge
    extends Assembler.CopycatRenderContext<List<BakedQuad>, List<BakedQuad>> {
        public CopycatRenderContextForge(List<BakedQuad> source, List<BakedQuad> destination) {
            super(source, destination);
        }
    }
}

