/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.model.multistate.forge;

import com.copycatsplus.copycats.content.copycat.base.model.forge.CopycatModel;
import com.copycatsplus.copycats.content.copycat.base.model.multistate.forge.ScaledBlockAndTintGetterForge;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlock;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateTextureAtlasSprite;
import com.simibubi.create.foundation.model.BakedModelWrapperWithData;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public abstract class MultiStateCopycatModel
extends BakedModelWrapperWithData {
    public static final ModelProperty<Map<String, BlockState>> MATERIALS_PROPERTY = new ModelProperty();
    private static final ModelProperty<Map<String, CopycatModel.OcclusionData>> OCCLUSION_PROPERTY = new ModelProperty();
    private static final ModelProperty<Map<String, ModelData>> WRAPPED_DATA_PROPERTY = new ModelProperty();

    public MultiStateCopycatModel(BakedModel originalModel) {
        super(originalModel);
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        @NotNull Map<String, BlockState> material = MultiStateCopycatModel.getMaterials(blockEntityData);
        if (material.isEmpty()) {
            return builder;
        }
        builder.with(MATERIALS_PROPERTY, new HashMap<String, BlockState>(material));
        Block block = state.m_60734_();
        if (!(block instanceof MultiStateCopycatBlock)) {
            return builder;
        }
        MultiStateCopycatBlock copycatBlock = (MultiStateCopycatBlock)block;
        Map<String, CopycatModel.OcclusionData> occlusionMap = material.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, s -> {
            @NotNull CopycatModel.OcclusionData occlusionData = new CopycatModel.OcclusionData();
            this.gatherOcclusionData(world, pos, state, (BlockState)s.getValue(), occlusionData, copycatBlock);
            return occlusionData;
        }));
        builder.with(OCCLUSION_PROPERTY, occlusionMap);
        Map<String, ModelData> wrappedDataMap = material.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, s -> {
            Vec3i inner = copycatBlock.getVectorFromProperty(state, (String)s.getKey());
            @NotNull ScaledBlockAndTintGetterForge scaledWorld = new ScaledBlockAndTintGetterForge((String)s.getKey(), world, pos, inner, copycatBlock.vectorScale(state), p -> true);
            ScaledBlockAndTintGetterForge filteredWorld = new ScaledBlockAndTintGetterForge((String)s.getKey(), world, pos, inner, copycatBlock.vectorScale(state), targetPos -> {
                MultiStateCopycatBlockEntity mscbe;
                BlockEntity be = world.m_7702_(pos);
                if (be instanceof MultiStateCopycatBlockEntity && !(mscbe = (MultiStateCopycatBlockEntity)be).getMaterialItemStorage().getMaterialItem((String)s.getKey()).enableCT()) {
                    return false;
                }
                return copycatBlock.canConnectTexturesToward((String)s.getKey(), scaledWorld, pos, (BlockPos)targetPos, state);
            });
            return MultiStateCopycatModel.getModelOf((BlockState)s.getValue()).getModelData((BlockAndTintGetter)filteredWorld, pos, (BlockState)s.getValue(), ModelData.EMPTY);
        }));
        return builder.with(WRAPPED_DATA_PROPERTY, wrappedDataMap);
    }

    private void gatherOcclusionData(BlockAndTintGetter world, BlockPos pos, BlockState state, BlockState material, CopycatModel.OcclusionData occlusionData, MultiStateCopycatBlock copycatBlock) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction face : Iterate.directions) {
            BlockPos.MutableBlockPos neighbourPos = mutablePos.m_122159_((Vec3i)pos, face);
            BlockState neighbourState = world.m_8055_((BlockPos)neighbourPos);
            if (state.supportsExternalFaceHiding() && neighbourState.hidesNeighborFace((BlockGetter)world, (BlockPos)neighbourPos, state, face.m_122424_())) {
                occlusionData.occlude(face);
                continue;
            }
            if (!copycatBlock.canFaceBeOccluded(state, face) || Block.m_152444_((BlockState)material, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)neighbourPos)) continue;
            occlusionData.occlude(face);
        }
    }

    @NotNull
    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType renderType) {
        MultiStateCopycatBlock ccb;
        Block block;
        if (side != null && (block = state.m_60734_()) instanceof MultiStateCopycatBlock && (ccb = (MultiStateCopycatBlock)block).shouldFaceAlwaysRender(state, side)) {
            return Collections.emptyList();
        }
        @NotNull Map<String, BlockState> materials = MultiStateCopycatModel.getMaterials(data);
        if (materials.isEmpty()) {
            return super.getQuads(state, side, rand, data, renderType);
        }
        Map<String, CopycatModel.OcclusionData> occlusionData = MultiStateCopycatModel.getOcclusion(data);
        LinkedList<BakedQuad> croppedQuads = new LinkedList<BakedQuad>();
        Map<String, ModelData> wrappedData = MultiStateCopycatModel.getWrappedData(data);
        for (Map.Entry<String, BlockState> entry : materials.entrySet()) {
            Direction[] directionArray;
            CopycatModel.OcclusionData occlusion = occlusionData.get(entry.getKey());
            if (occlusion == null || occlusion.isOccluded(side)) continue;
            BlockState material = entry.getValue();
            ModelData dataForMaterial = wrappedData.get(entry.getKey());
            if (dataForMaterial == null) {
                dataForMaterial = ModelData.EMPTY;
            }
            if (renderType != null && !Minecraft.m_91087_().m_91289_().m_110910_(material).getRenderTypes(material, rand, dataForMaterial).contains(renderType)) continue;
            this.emitQuadsForProperty(croppedQuads, this.getCroppedQuads(entry.getKey(), state, side, rand, material, dataForMaterial, renderType), entry.getKey());
            if (side != null || !((directionArray = state.m_60734_()) instanceof MultiStateCopycatBlock)) continue;
            MultiStateCopycatBlock ccb2 = (MultiStateCopycatBlock)directionArray;
            directionArray = Iterate.directions;
            int n = directionArray.length;
            for (int i = 0; i < n; ++i) {
                Direction nonOcclusionSide = directionArray[i];
                if (!ccb2.shouldFaceAlwaysRender(state, nonOcclusionSide)) continue;
                this.emitQuadsForProperty(croppedQuads, this.getCroppedQuads(entry.getKey(), state, nonOcclusionSide, rand, material, dataForMaterial, renderType), entry.getKey());
            }
        }
        return croppedQuads;
    }

    protected abstract List<BakedQuad> getCroppedQuads(String var1, BlockState var2, Direction var3, RandomSource var4, BlockState var5, ModelData var6, RenderType var7);

    private void emitQuadsForProperty(List<BakedQuad> dest, Collection<BakedQuad> source, String property) {
        for (BakedQuad quad : source) {
            dest.add(new BakedQuad(quad.m_111303_(), quad.m_111305_(), quad.m_111306_(), (TextureAtlasSprite)new MultiStateTextureAtlasSprite(property, quad.m_173410_()), quad.m_111307_()));
        }
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        @NotNull Map<String, BlockState> material = MultiStateCopycatModel.getMaterials(data);
        if (material.isEmpty()) {
            return super.getParticleIcon(data);
        }
        Map.Entry key = (Map.Entry)material.entrySet().stream().findFirst().get();
        return MultiStateCopycatModel.getModelOf((BlockState)key.getValue()).getParticleIcon(MultiStateCopycatModel.getWrappedData(data).get(key.getKey()));
    }

    @NotNull
    public static Map<String, BlockState> getMaterials(ModelData data) {
        Map materials = data == null ? null : (Map)data.get(MATERIALS_PROPERTY);
        return materials == null ? Map.of() : materials;
    }

    @NotNull
    public static Map<String, CopycatModel.OcclusionData> getOcclusion(ModelData data) {
        Map occlusions = data == null ? null : (Map)data.get(OCCLUSION_PROPERTY);
        return occlusions == null ? Map.of() : occlusions;
    }

    @NotNull
    public static Map<String, ModelData> getWrappedData(ModelData data) {
        Map wrappedData = data == null ? null : (Map)data.get(WRAPPED_DATA_PROPERTY);
        return wrappedData == null ? Map.of() : wrappedData;
    }

    public static BakedModel getModelOf(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }
}

