/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.multistate;

import com.copycatsplus.copycats.CCBlockEntityTypes;
import com.copycatsplus.copycats.CCBlockStateProperties;
import com.copycatsplus.copycats.content.copycat.base.IStateType;
import com.copycatsplus.copycats.content.copycat.base.StateType;
import com.copycatsplus.copycats.content.copycat.base.functional.IFunctionalCopycatBlock;
import com.copycatsplus.copycats.content.copycat.base.multistate.BlockStateTransform;
import com.copycatsplus.copycats.content.copycat.base.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateRenderManager;
import com.copycatsplus.copycats.content.copycat.base.multistate.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.content.copycat.base.multistate.forge.MultiStateCopycatBlockImpl;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class MultiStateCopycatBlock
extends Block
implements IFunctionalCopycatBlock,
IBE<MultiStateCopycatBlockEntity>,
IWrenchable,
ISpecialBlockItemRequirement,
IStateType {
    public static final EnumProperty<BlockStateTransform> TRANSFORM = CCBlockStateProperties.TRANSFORM;

    public MultiStateCopycatBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(TRANSFORM, (Comparable)((Object)BlockStateTransform.ABCD)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{TRANSFORM}));
    }

    public abstract int maxMaterials();

    public abstract Vec3i vectorScale(BlockState var1);

    public abstract Set<String> storageProperties();

    public abstract boolean partExists(BlockState var1, String var2);

    public abstract String getPropertyFromInteraction(BlockState var1, BlockGetter var2, Vec3i var3, BlockPos var4, Direction var5, Vec3 var6);

    public String getPropertyFromRender(String renderingProperty, BlockState state, ScaledBlockAndTintGetter level, Vec3i vector, BlockPos blockPos, Direction side, BlockState queryState, BlockPos queryPos) {
        return this.getPropertyFromInteraction(state, (BlockGetter)level, vector, blockPos, side, Vec3.m_82512_((Vec3i)vector));
    }

    public abstract Vec3i getVectorFromProperty(BlockState var1, String var2);

    public String getProperty(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockHitResult hit, boolean targetingSolid) {
        Vec3 hitVec = hit.m_82450_();
        return this.getProperty(state, level, pos, hitVec, hit.m_82434_(), targetingSolid);
    }

    public String getProperty(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, Vec3 hitVec, Direction face, boolean targetingSolid) {
        hitVec = targetingSolid ? hitVec.m_82546_(Vec3.m_82528_((Vec3i)face.m_122436_()).m_82490_(0.05)) : hitVec.m_82549_(Vec3.m_82528_((Vec3i)face.m_122436_()).m_82490_(0.05));
        Vec3 unscaledHit = hitVec = hitVec.m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
        Vec3i scale = this.vectorScale(state);
        hitVec = hitVec.m_82542_((double)scale.m_123341_(), (double)scale.m_123342_(), (double)scale.m_123343_());
        BlockPos location = new BlockPos((int)hitVec.m_7096_(), (int)hitVec.m_7098_(), (int)hitVec.m_7094_());
        return this.getPropertyFromInteraction(state, level, (Vec3i)location, pos, face, unscaledHit);
    }

    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<S> p_153214_) {
        return null;
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        return IFunctionalCopycatBlock.super.onSneakWrenched(state, context);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return this.onBlockEntityUse((BlockGetter)context.m_43725_(), context.m_8083_(), ufte -> {
            String property = this.getProperty(state, (BlockGetter)context.m_43725_(), context.m_8083_(), context.m_43720_(), context.m_43719_(), true);
            if (!this.partExists(state, property)) {
                return InteractionResult.PASS;
            }
            MaterialItemStorage.MaterialItem material = ufte.getMaterialItemStorage().getMaterialItem(property);
            ItemStack consumedItem = material.consumedItem();
            if (!ufte.getMaterialItemStorage().hasCustomMaterial(property)) {
                return InteractionResult.PASS;
            }
            Player player = context.m_43723_();
            if (!player.m_7500_()) {
                player.m_150109_().m_150079_(consumedItem);
            }
            context.m_43725_().m_46796_(2001, context.m_8083_(), Block.m_49956_((BlockState)material.material()));
            ufte.setMaterial(property, AllBlocks.COPYCAT_BASE.getDefaultState());
            ufte.setConsumedItem(property, ItemStack.f_41583_);
            return InteractionResult.SUCCESS;
        });
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.m_6144_() && player.m_21120_(hand).equals(ItemStack.f_41583_)) {
            MultiStateCopycatBlockEntity be;
            String property = this.getProperty(state, (BlockGetter)level, pos, hit, true);
            be.setEnableCT(property, !(be = (MultiStateCopycatBlockEntity)this.getBlockEntity((BlockGetter)level, pos)).getMaterialItemStorage().getMaterialItem(property).enableCT());
            be.redraw();
            return InteractionResult.SUCCESS;
        }
        if (player == null || !player.m_36326_() && !player.m_5833_()) {
            return InteractionResult.PASS;
        }
        Direction face = hit.m_82434_();
        ItemStack itemInHand = player.m_21120_(hand);
        BlockState materialIn = this.getAcceptedBlockState(level, pos, itemInHand, face);
        if (materialIn != null) {
            materialIn = this.prepareMaterial(level, pos, state, player, hand, hit, materialIn);
        }
        if (materialIn == null) {
            return InteractionResult.PASS;
        }
        BlockState material = materialIn;
        return this.onBlockEntityUse((BlockGetter)level, pos, ufte -> {
            String property = this.getProperty(state, (BlockGetter)level, pos, hit, true);
            if (!this.partExists(state, property)) {
                return InteractionResult.PASS;
            }
            if (ufte.getMaterialItemStorage().getMaterialItem(property).material().m_60713_(material.m_60734_())) {
                if (!ufte.cycleMaterial(property)) {
                    return InteractionResult.PASS;
                }
                ufte.m_58904_().m_5594_(null, ufte.m_58899_(), SoundEvents.f_12013_, SoundSource.BLOCKS, 0.75f, 0.95f);
                return InteractionResult.SUCCESS;
            }
            if (ufte.getMaterialItemStorage().hasCustomMaterial(property)) {
                return InteractionResult.PASS;
            }
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            ufte.setMaterial(property, material);
            ufte.setConsumedItem(property, itemInHand);
            ufte.m_58904_().m_5594_(null, ufte.m_58899_(), material.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 0.75f);
            if (player.m_7500_()) {
                return InteractionResult.SUCCESS;
            }
            itemInHand.m_41774_(1);
            if (itemInHand.m_41619_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            return InteractionResult.SUCCESS;
        });
    }

    @Override
    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, LivingEntity pPlacer, @NotNull ItemStack pStack) {
        if (pPlacer == null) {
            return;
        }
        ItemStack offhandItem = pPlacer.m_21120_(InteractionHand.OFF_HAND);
        BlockState appliedState = this.getAcceptedBlockState(pLevel, pPos, offhandItem, Direction.m_122382_((Entity)pPlacer)[0]);
        if (appliedState == null) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, ufte -> {
            for (String property : this.storageProperties()) {
                Player player;
                if (!this.partExists(pState, property) || ufte.getMaterialItemStorage().hasCustomMaterial(property)) continue;
                ufte.setMaterial(property, appliedState);
                ufte.setConsumedItem(property, offhandItem);
                if (pPlacer instanceof Player && (player = (Player)pPlacer).m_7500_()) continue;
                offhandItem.m_41774_(1);
                if (!offhandItem.m_41619_()) continue;
                pPlacer.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                break;
            }
        });
    }

    @Override
    @Nullable
    public BlockState getAcceptedBlockState(Level pLevel, BlockPos pPos, ItemStack item, Direction face) {
        Item item2 = item.m_41720_();
        if (!(item2 instanceof BlockItem)) {
            return null;
        }
        BlockItem bi = (BlockItem)item2;
        Block block = bi.m_40614_();
        if (block instanceof IFunctionalCopycatBlock || block instanceof CopycatBlock) {
            return null;
        }
        BlockState appliedState = block.m_49966_();
        boolean hardCodedAllow = this.isAcceptedRegardless(appliedState);
        if (!AllTags.AllBlockTags.COPYCAT_ALLOW.matches(block) && !hardCodedAllow) {
            if (AllTags.AllBlockTags.COPYCAT_DENY.matches(block)) {
                return null;
            }
            if (block instanceof EntityBlock) {
                return null;
            }
            if (block instanceof StairBlock) {
                return null;
            }
            if (pLevel != null) {
                VoxelShape shape = appliedState.m_60808_((BlockGetter)pLevel, pPos);
                if (shape.m_83281_() || !shape.m_83215_().equals((Object)Shapes.m_83144_().m_83215_())) {
                    return null;
                }
                VoxelShape collisionShape = appliedState.m_60812_((BlockGetter)pLevel, pPos);
                if (collisionShape.m_83281_()) {
                    return null;
                }
            }
        }
        if (face != null) {
            Direction.Axis axis = face.m_122434_();
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)face);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61374_) && axis != Direction.Axis.Y) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61365_)) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61364_) && axis != Direction.Axis.Y) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)axis);
            }
        }
        return appliedState;
    }

    @Override
    public boolean isAcceptedRegardless(BlockState material) {
        return false;
    }

    @Override
    public BlockState prepareMaterial(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, BlockState material) {
        return material;
    }

    @Override
    public void m_6810_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_155947_() || pState.m_60734_() == pNewState.m_60734_()) {
            return;
        }
        if (!pIsMoving) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, ufte -> ufte.getMaterialItemStorage().getAllConsumedItems().forEach(stack -> Block.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)stack)));
        }
        pLevel.m_46747_(pPos);
    }

    @Override
    public void m_5707_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        if (pPlayer.m_7500_()) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, ufte -> ufte.getMaterialItemStorage().getAllProperties().forEach(key -> ufte.getMaterialItemStorage().getMaterialItem((String)key).setConsumedItem(ItemStack.f_41583_)));
        }
    }

    public Class<MultiStateCopycatBlockEntity> getBlockEntityClass() {
        return MultiStateCopycatBlockEntity.class;
    }

    public BlockEntityType<? extends MultiStateCopycatBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.MULTI_STATE_COPYCAT_BLOCK_ENTITY.get();
    }

    @Override
    public StateType stateType() {
        return StateType.MULTI;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockState multiPlatformGetAppearance(MultiStateCopycatBlock block, BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return MultiStateCopycatBlockImpl.multiPlatformGetAppearance(block, (BlockState)var1_1, (BlockAndTintGetter)var2_2, (BlockPos)var3_3, (Direction)var4_4, (BlockState)var5_5, (BlockPos)var6_6);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return MultiStateCopycatBlock.multiPlatformGetAppearance(this, state, level, pos, side, queryState, queryPos);
    }

    public boolean allowCTAppearance(MultiStateCopycatBlock block, BlockState state, BlockAndTintGetter level, Direction side, BlockState queryState, BlockPos queryPos) {
        String property;
        if (level instanceof ScaledBlockAndTintGetter) {
            ScaledBlockAndTintGetter scaledLevel = (ScaledBlockAndTintGetter)level;
            BlockPos truePos = scaledLevel.getTruePos(queryPos);
            Vec3i inner = scaledLevel.getInner(queryPos);
            property = block.getPropertyFromRender(scaledLevel.getRenderingProperty(), state, scaledLevel, inner, truePos, side, queryState, queryPos);
        } else {
            property = (String)block.storageProperties().stream().findFirst().get();
        }
        MultiStateCopycatBlockEntity be = (MultiStateCopycatBlockEntity)this.getBlockEntity((BlockGetter)level, queryPos);
        if (be == null) {
            return true;
        }
        return be.getMaterialItemStorage().getMaterialItem(property) == null || be.getMaterialItemStorage().getMaterialItem(property).enableCT();
    }

    public boolean isIgnoredConnectivitySide(String property, BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        BlockState toState = reader.m_8055_(toPos);
        Block block = toState.m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            return true;
        }
        return !toState.m_60713_(MultiStateCopycatBlock.getMaterial((BlockGetter)reader, fromPos).m_60734_());
    }

    public boolean canConnectTexturesToward(String property, BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        Object object = toState.m_60734_();
        if (object instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)object;
            if (mscb.partExists(toState, property)) {
                BlockState toMat = MultiStateCopycatBlock.getMaterial((BlockGetter)reader, toPos, property);
                return toMat.m_60713_(MultiStateCopycatBlock.getMaterial((BlockGetter)reader, fromPos, property).m_60734_());
            }
            object = mscb.storageProperties().iterator();
            if (object.hasNext()) {
                String prop = (String)object.next();
                return mscb.partExists(toState, prop) && MultiStateCopycatBlock.getMaterial((BlockGetter)reader, toPos, prop).m_60713_(MultiStateCopycatBlock.getMaterial((BlockGetter)reader, fromPos, property).m_60734_());
            }
            return false;
        }
        return toState.m_60713_(MultiStateCopycatBlock.getMaterial((BlockGetter)reader, fromPos, property).m_60734_());
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos) {
        BlockEntity blockEntity = reader.m_7702_(targetPos);
        if (blockEntity instanceof MultiStateCopycatBlockEntity) {
            MultiStateCopycatBlockEntity cbe = (MultiStateCopycatBlockEntity)blockEntity;
            return cbe.getMaterialItemStorage().getAllMaterials().stream().filter(s -> !s.m_60713_((Block)AllBlocks.COPYCAT_BASE.get())).findFirst().orElse(Blocks.f_50016_.m_49966_());
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos, String property) {
        MultiStateCopycatBlockEntity cbe;
        BlockEntity blockEntity = reader.m_7702_(targetPos);
        if (blockEntity instanceof MultiStateCopycatBlockEntity && (cbe = (MultiStateCopycatBlockEntity)blockEntity).getMaterialItemStorage().getMaterialItem(property) != null) {
            return cbe.getMaterialItemStorage().getMaterialItem(property).material();
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return false;
    }

    @Override
    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockState material;
        String string;
        if (target == null) {
            string = null;
        } else {
            Direction direction;
            Vec3 vec3 = target.m_82450_();
            if (target instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)target;
                direction = blockHit.m_82434_();
            } else {
                direction = Direction.UP;
            }
            string = this.getProperty(state, level, pos, vec3, direction, true);
        }
        String property = string;
        BlockState blockState = material = property == null ? MultiStateCopycatBlock.getMaterial(level, pos) : MultiStateCopycatBlock.getMaterial(level, pos, property);
        if (AllBlocks.COPYCAT_BASE.has(material) || player != null && player.m_20161_()) {
            return new ItemStack((ItemLike)this);
        }
        return material.m_60734_().m_7397_(level, pos, material);
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        Block block = state.m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock msb = (MultiStateCopycatBlock)block;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(msb.storageProperties().stream().filter(prop -> msb.partExists(state, (String)prop)).map(prop -> new ItemStack((ItemLike)state.m_60734_().m_5456_())).toList());
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, stacks);
        }
        return ItemRequirement.INVALID;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static VoxelShape multiPlatformGetShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        return MultiStateCopycatBlockImpl.multiPlatformGetShape(pState, (BlockGetter)var1_1, (BlockPos)var2_2, (CollisionContext)var3_3);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        level.m_186464_(pos, (Block)this, 0, TickPriority.EXTREMELY_HIGH);
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        this.withBlockEntityDo((BlockGetter)level, pos, MultiStateCopycatBlockEntity::updateTransform);
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)super.m_6843_(state, rotation).m_61124_(TRANSFORM, (Comparable)((Object)((BlockStateTransform)((Object)state.m_61143_(TRANSFORM))).getClockwise().getClockwise()));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)super.m_6843_(state, rotation).m_61124_(TRANSFORM, (Comparable)((Object)((BlockStateTransform)((Object)state.m_61143_(TRANSFORM))).getCounterClockwise()));
            case Rotation.CLOCKWISE_90 -> (BlockState)super.m_6843_(state, rotation).m_61124_(TRANSFORM, (Comparable)((Object)((BlockStateTransform)((Object)state.m_61143_(TRANSFORM))).getClockwise()));
            default -> super.m_6843_(state, rotation);
        };
    }

    public abstract void rotate(@NotNull BlockState var1, @NotNull MultiStateCopycatBlockEntity var2, Rotation var3);

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.FRONT_BACK -> (BlockState)super.m_6943_(state, mirror).m_61124_(TRANSFORM, (Comparable)((Object)((BlockStateTransform)((Object)state.m_61143_(TRANSFORM))).flipZ()));
            case Mirror.LEFT_RIGHT -> (BlockState)super.m_6943_(state, mirror).m_61124_(TRANSFORM, (Comparable)((Object)((BlockStateTransform)((Object)state.m_61143_(TRANSFORM))).flipX()));
            default -> super.m_6943_(state, mirror);
        };
    }

    public abstract void mirror(@NotNull BlockState var1, @NotNull MultiStateCopycatBlockEntity var2, Mirror var3);

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor wrappedColor() {
        return new WrappedBlockColor();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedBlockColor
    implements BlockColor {
        public int m_92566_(@NotNull BlockState pState, @Nullable BlockAndTintGetter pLevel, @Nullable BlockPos pPos, int pTintIndex) {
            if (pLevel == null || pPos == null) {
                return GrassColor.m_46415_((double)0.5, (double)1.0);
            }
            String renderingProperty = MultiStateRenderManager.getRenderingProperty();
            if (renderingProperty != null) {
                return Minecraft.m_91087_().m_91298_().m_92577_(MultiStateCopycatBlock.getMaterial((BlockGetter)pLevel, pPos, renderingProperty), pLevel, pPos, pTintIndex);
            }
            int tint = Minecraft.m_91087_().m_91298_().m_92577_(MultiStateCopycatBlock.getMaterial((BlockGetter)pLevel, pPos), pLevel, pPos, pTintIndex);
            BlockEntity be = pLevel.m_7702_(pPos);
            if (tint == -1 && be instanceof MultiStateCopycatBlockEntity) {
                MultiStateCopycatBlockEntity mscb = (MultiStateCopycatBlockEntity)be;
                for (String property : mscb.getMaterialItemStorage().getAllProperties()) {
                    int anyTint = Minecraft.m_91087_().m_91298_().m_92577_(MultiStateCopycatBlock.getMaterial((BlockGetter)pLevel, pPos, property), pLevel, pPos, pTintIndex);
                    if (anyTint == -1) continue;
                    return anyTint;
                }
            }
            return tint;
        }
    }
}

