/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.multistate;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.content.copycat.base.functional.IFunctionalCopycatBlockEntity;
import com.copycatsplus.copycats.content.copycat.base.multistate.BlockStateTransform;
import com.copycatsplus.copycats.content.copycat.base.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlock;
import com.copycatsplus.copycats.content.copycat.base.multistate.forge.MultiStateCopycatBlockEntityImpl;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockEntityItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.IPartialSafeNBT;
import com.simibubi.create.foundation.utility.Iterate;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class MultiStateCopycatBlockEntity
extends SmartBlockEntity
implements IFunctionalCopycatBlockEntity,
ISpecialBlockEntityItemRequirement,
ITransformableBlockEntity,
IPartialSafeNBT {
    private final MaterialItemStorage materialItemStorage;

    public MultiStateCopycatBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        Block block = this.m_58900_().m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            this.materialItemStorage = MaterialItemStorage.create(mscb.maxMaterials(), mscb.storageProperties());
        } else {
            this.materialItemStorage = MaterialItemStorage.create(1, Set.of("block"));
        }
    }

    @Override
    public CopycatBlockEntity getCopycatBlockEntity() {
        return null;
    }

    @Override
    public BlockState getMaterial() {
        return this.materialItemStorage.getAllMaterials().stream().filter(x -> !x.m_60713_((Block)AllBlocks.COPYCAT_BASE.get())).findFirst().orElse(AllBlocks.COPYCAT_BASE.getDefaultState());
    }

    @Override
    public void m_142339_(@NotNull Level level) {
        super.m_142339_(level);
    }

    public void updateTransform() {
        BlockStateTransform transform = (BlockStateTransform)((Object)this.m_58900_().m_61143_(MultiStateCopycatBlock.TRANSFORM));
        if (transform != BlockStateTransform.ABCD) {
            MultiStateCopycatBlock block = (MultiStateCopycatBlock)this.m_58900_().m_60734_();
            transform.undoTransform(r -> block.rotate(this.m_58900_(), this, (Rotation)r), m -> block.mirror(this.m_58900_(), this, (Mirror)m));
        }
        this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(MultiStateCopycatBlock.TRANSFORM, (Comparable)((Object)BlockStateTransform.ABCD)), 54);
    }

    public boolean cycleMaterial(String property) {
        BlockState material = this.getMaterialItemStorage().getMaterialItem(property).material();
        if (material.m_61138_((Property)TrapDoorBlock.f_57515_) && material.m_61145_((Property)TrapDoorBlock.f_57514_).orElse(false).booleanValue()) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)TrapDoorBlock.f_57515_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61372_)) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)BlockStateProperties.f_61372_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61374_)) {
            this.setMaterial(property, (BlockState)material.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)material.m_61143_((Property)BlockStateProperties.f_61374_)).m_122427_()));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61365_)) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)BlockStateProperties.f_61365_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61364_)) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)BlockStateProperties.f_61364_));
        } else if (material.m_61138_((Property)BlockStateProperties.f_61443_)) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)BlockStateProperties.f_61443_));
        } else if (material.m_61138_((Property)RoseQuartzLampBlock.POWERING)) {
            this.setMaterial(property, (BlockState)material.m_61122_((Property)RoseQuartzLampBlock.POWERING));
        } else {
            return false;
        }
        return true;
    }

    public MaterialItemStorage getMaterialItemStorage() {
        return this.materialItemStorage;
    }

    public void setMaterial(String property, BlockState blockState) {
        BlockState wrapperState = this.m_58900_();
        BlockState finalMaterial = blockState;
        if (!this.getMaterialItemStorage().getMaterialItem(property).material().m_60713_(finalMaterial.m_60734_())) {
            for (Direction side : Iterate.directions) {
                MultiStateCopycatBlockEntity cbe;
                BlockState otherMaterial;
                BlockEntity blockEntity;
                BlockPos neighbour = this.f_58858_.m_121945_(side);
                BlockState neighbourState = this.f_58857_.m_8055_(neighbour);
                if (neighbourState != wrapperState || !((blockEntity = this.f_58857_.m_7702_(neighbour)) instanceof MultiStateCopycatBlockEntity) || !(otherMaterial = (cbe = (MultiStateCopycatBlockEntity)blockEntity).getMaterialItemStorage().getMaterialItem(property).material()).m_60713_(blockState.m_60734_())) continue;
                blockState = otherMaterial;
                break;
            }
        }
        MaterialItemStorage.MaterialItem materialItem = this.getMaterialItemStorage().getMaterialItem(property);
        materialItem.setMaterial(blockState);
        this.getMaterialItemStorage().storeMaterialItem(property, materialItem);
        if (!this.f_58857_.m_5776_()) {
            this.notifyUpdate();
            return;
        }
        this.redraw();
    }

    public void setConsumedItem(String property, ItemStack itemStack) {
        this.getMaterialItemStorage().getMaterialItem(property).setConsumedItem(itemStack);
        this.m_6596_();
    }

    public void setEnableCT(String property, boolean value) {
        this.getMaterialItemStorage().getMaterialItem(property).setEnableCT(value);
        this.notifyUpdate();
    }

    public void redraw() {
        if (!this.isVirtual()) {
            this.requestModelUpdate();
        }
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            this.f_58857_.m_7726_().m_7827_().m_7174_(this.m_58899_());
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state) {
        List<ItemStack> stacks = this.getMaterialItemStorage().getAllConsumedItems();
        if (stacks.isEmpty()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, stacks);
    }

    @Override
    public void transform(StructureTransform transform) {
        for (String key : this.getMaterialItemStorage().getAllProperties()) {
            this.getMaterialItemStorage().getMaterialItem(key).setMaterial(transform.apply(this.getMaterialItemStorage().getMaterialItem(key).material()));
        }
        this.notifyUpdate();
    }

    public abstract void requestModelUpdate();

    @Override
    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        tag.m_128365_("material_data", (Tag)this.materialItemStorage.serializeSafe());
    }

    @Override
    public void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("material_data", (Tag)this.materialItemStorage.serialize());
    }

    @Override
    public void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        Block block = this.m_58900_().m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            boolean anyUpdated = this.materialItemStorage.deserialize(tag.m_128469_("material_data"));
            if (clientPacket && anyUpdated) {
                this.redraw();
            }
        }
    }

    public void migrateData(CopycatBlockEntity copycatBlockEntity) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            ResourceLocation blockId = copycatBlockEntity.m_58900_().m_60734_().m_204297_().m_205785_().m_135782_();
            Copycats.LOGGER.debug("Converting block({}) at @{} to a multistate copycat", (Object)blockId.toString(), (Object)copycatBlockEntity.m_58899_().m_123344_());
            MaterialItemStorage.MaterialItem materialItem = this.materialItemStorage.getMaterialItem(this.getMaterialItemStorage().getAllProperties().stream().filter(prop -> mscb.partExists(this.m_58900_(), (String)prop)).findFirst().get());
            materialItem.setMaterial(copycatBlockEntity.getMaterial());
            materialItem.setConsumedItem(copycatBlockEntity.getConsumedItem());
            for (String property : mscb.storageProperties()) {
                if (!mscb.partExists(this.m_58900_(), property) || this.getMaterialItemStorage().hasCustomMaterial(property)) continue;
                MaterialItemStorage.MaterialItem store = this.materialItemStorage.getMaterialItem(property);
                store.setMaterial(copycatBlockEntity.getMaterial());
                store.setConsumedItem(ItemStack.f_41583_);
            }
            this.redraw();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static MultiStateCopycatBlockEntity create(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        void var2_2;
        void var1_1;
        return MultiStateCopycatBlockEntityImpl.create(type, (BlockPos)var1_1, (BlockState)var2_2);
    }
}

