/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.half_layer;

import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.content.copycat.base.multistate.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.content.copycat.base.multistate.WaterloggedMultiStateCopycatBlock;
import com.google.common.collect.ImmutableMap;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatHalfLayerBlock
extends WaterloggedMultiStateCopycatBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final IntegerProperty POSITIVE_LAYERS = IntegerProperty.m_61631_((String)"positive_layers", (int)0, (int)8);
    public static final IntegerProperty NEGATIVE_LAYERS = IntegerProperty.m_61631_((String)"negative_layers", (int)0, (int)8);
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;
    private static final VoxelShaper[] TOP_BY_LAYER = new VoxelShaper[]{CCShapes.EMPTY, CCShapes.HALF_LAYER_TOP_2PX, CCShapes.HALF_LAYER_TOP_4PX, CCShapes.HALF_LAYER_TOP_6PX, CCShapes.HALF_LAYER_TOP_8PX, CCShapes.HALF_LAYER_TOP_10PX, CCShapes.HALF_LAYER_TOP_12PX, CCShapes.HALF_LAYER_TOP_14PX, CCShapes.HALF_LAYER_TOP_16PX};
    private static final VoxelShaper[] BOTTOM_BY_LAYER = new VoxelShaper[]{CCShapes.EMPTY, CCShapes.HALF_LAYER_BOTTOM_2PX, CCShapes.HALF_LAYER_BOTTOM_4PX, CCShapes.HALF_LAYER_BOTTOM_6PX, CCShapes.HALF_LAYER_BOTTOM_8PX, CCShapes.HALF_LAYER_BOTTOM_10PX, CCShapes.HALF_LAYER_BOTTOM_12PX, CCShapes.HALF_LAYER_BOTTOM_14PX, CCShapes.HALF_LAYER_BOTTOM_16PX};

    public CopycatHalfLayerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)POSITIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)Integer.valueOf(0)));
        this.shapesCache = this.m_152458_(CopycatHalfLayerBlock::calculateMultiFaceShape);
    }

    @Override
    public int maxMaterials() {
        return 2;
    }

    @Override
    public Vec3i vectorScale(BlockState state) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3i(2, 1, 1);
            case Direction.Axis.Y -> new Vec3i(1, 2, 1);
            case Direction.Axis.Z -> new Vec3i(1, 1, 2);
        };
    }

    @Override
    public boolean partExists(BlockState state, String property) {
        if (property.equals(POSITIVE_LAYERS.m_61708_())) {
            return (Integer)state.m_61143_((Property)POSITIVE_LAYERS) > 0;
        }
        if (property.equals(NEGATIVE_LAYERS.m_61708_())) {
            return (Integer)state.m_61143_((Property)NEGATIVE_LAYERS) > 0;
        }
        return false;
    }

    @Override
    public Set<String> storageProperties() {
        return Set.of(POSITIVE_LAYERS.m_61708_(), NEGATIVE_LAYERS.m_61708_());
    }

    @Override
    public String getPropertyFromInteraction(BlockState state, BlockGetter level, Vec3i hitLocation, BlockPos blockPos, Direction facing, Vec3 unscaledHit) {
        if (hitLocation.m_123304_((Direction.Axis)state.m_61143_(AXIS)) > 0) {
            return POSITIVE_LAYERS.m_61708_();
        }
        return NEGATIVE_LAYERS.m_61708_();
    }

    @Override
    public Vec3i getVectorFromProperty(BlockState state, String property) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (property.equals(POSITIVE_LAYERS.m_61708_())) {
                    yield new Vec3i(1, 0, 0);
                }
                yield new Vec3i(0, 0, 0);
            }
            case Direction.Axis.Y -> {
                if (property.equals(POSITIVE_LAYERS.m_61708_())) {
                    yield new Vec3i(0, 1, 0);
                }
                yield new Vec3i(0, 0, 0);
            }
            case Direction.Axis.Z -> property.equals(POSITIVE_LAYERS.m_61708_()) ? new Vec3i(0, 0, 1) : new Vec3i(0, 0, 0);
        };
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            Vec3 clickPosition = context.m_43720_().m_82549_(Vec3.m_82528_((Vec3i)context.m_43719_().m_122436_()).m_82490_(0.0625)).m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_()));
            IntegerProperty targetProp = ((Direction.Axis)state.m_61143_(AXIS)).m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) < 0.5 ? NEGATIVE_LAYERS : POSITIVE_LAYERS;
            if ((Integer)state.m_61143_((Property)targetProp) < 8) {
                return (BlockState)state.m_61122_((Property)targetProp);
            }
            Copycats.LOGGER.warn("Can't figure out where to place a step layer! Please file an issue if you see this.");
            return state;
        }
        Direction.Axis axis = context.m_8125_().m_122434_();
        Vec3 clickPosition = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_()));
        return (BlockState)((BlockState)((BlockState)stateForPlacement.m_61124_(AXIS, (Comparable)axis)).m_61124_(HALF, (Comparable)(clickPosition.f_82480_ > 0.5 ? Half.TOP : Half.BOTTOM))).m_61124_((Property)(axis.m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) > 0.5 ? POSITIVE_LAYERS : NEGATIVE_LAYERS), (Comparable)Integer.valueOf(1));
    }

    public boolean m_6864_(@NotNull BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        Direction clickFace = pUseContext.m_43719_();
        if (clickFace.m_122434_().m_122478_() && pState.m_61143_(HALF) == Half.TOP == (clickFace == Direction.UP)) {
            return false;
        }
        Vec3 clickPosition = pUseContext.m_43720_().m_82549_(Vec3.m_82528_((Vec3i)pUseContext.m_43719_().m_122436_()).m_82490_(0.0625)).m_82546_(Vec3.m_82528_((Vec3i)pUseContext.m_8083_()));
        IntegerProperty targetProp = ((Direction.Axis)pState.m_61143_(AXIS)).m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) < 0.5 ? NEGATIVE_LAYERS : POSITIVE_LAYERS;
        return (Integer)pState.m_61143_((Property)targetProp) != 8;
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if ((Integer)state.m_61143_((Property)POSITIVE_LAYERS) + (Integer)state.m_61143_((Property)NEGATIVE_LAYERS) <= 1) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Vec3 clickPosition = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_43719_().m_122436_()).m_82490_(0.0625)).m_82546_(Vec3.m_82528_((Vec3i)pos));
        IntegerProperty targetProp = ((Direction.Axis)state.m_61143_(AXIS)).m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) < 0.5 ? NEGATIVE_LAYERS : POSITIVE_LAYERS;
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (player != null) {
                List drops = Block.m_49874_((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)POSITIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)targetProp, (Comparable)Integer.valueOf(1))), (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                if ((Integer)state.m_61143_((Property)targetProp) == 1) {
                    this.withBlockEntityDo((BlockGetter)world, pos, ufte -> {
                        String property = targetProp.m_61708_();
                        drops.add(ufte.getMaterialItemStorage().getMaterialItem(property).consumedItem());
                        ufte.setMaterial(property, AllBlocks.COPYCAT_BASE.getDefaultState());
                        ufte.setConsumedItem(property, ItemStack.f_41583_);
                    });
                }
                if (!player.m_7500_()) {
                    for (ItemStack drop : drops) {
                        player.m_150109_().m_150079_(drop);
                    }
                }
            }
            BlockPos up = pos.m_121945_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_((Property)targetProp, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)targetProp) - 1))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            this.playRemoveSound(world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean isIgnoredConnectivitySide(String property, BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        BlockState toState = reader.m_8055_(toPos);
        return !toState.m_60713_((Block)this);
    }

    @Override
    public boolean canConnectTexturesToward(String property, BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (reader instanceof ScaledBlockAndTintGetter) {
            ScaledBlockAndTintGetter scaledReader = (ScaledBlockAndTintGetter)reader;
            if (toState.m_60713_((Block)this)) {
                BlockPos toTruePos = scaledReader.getTruePos(toPos);
                Vec3i toInner = scaledReader.getInner(toPos);
                String toProperty = this.getPropertyFromInteraction(toState, (BlockGetter)reader, toInner, toTruePos, Direction.UP, Vec3.m_82512_((Vec3i)toInner));
                int fromLayers = (Integer)state.m_61143_((Property)(property.equals(POSITIVE_LAYERS.m_61708_()) ? POSITIVE_LAYERS : NEGATIVE_LAYERS));
                int toLayers = (Integer)toState.m_61143_((Property)(toProperty.equals(POSITIVE_LAYERS.m_61708_()) ? POSITIVE_LAYERS : NEGATIVE_LAYERS));
                return fromLayers == toLayers;
            }
        }
        return toState.m_60713_((Block)this);
    }

    @Override
    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        state = super.m_6843_(state, rot);
        Function<Direction.Axis, Direction.Axis> swap = axis -> axis == Direction.Axis.Z ? Direction.Axis.X : Direction.Axis.Z;
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> state;
            case Rotation.CLOCKWISE_90 -> {
                Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
                if (axis == Direction.Axis.X) {
                    yield (BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis));
                }
                yield (BlockState)((BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis))).m_61124_((Property)POSITIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)NEGATIVE_LAYERS)))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)POSITIVE_LAYERS)));
            }
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)state.m_61124_((Property)POSITIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)NEGATIVE_LAYERS)))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)POSITIVE_LAYERS)));
            case Rotation.COUNTERCLOCKWISE_90 -> {
                Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
                if (axis == Direction.Axis.Z) {
                    yield (BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis));
                }
                yield (BlockState)((BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis))).m_61124_((Property)POSITIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)NEGATIVE_LAYERS)))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)POSITIVE_LAYERS)));
            }
        };
    }

    @Override
    public void rotate(@NotNull BlockState state, @NotNull MultiStateCopycatBlockEntity be, Rotation rotation) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (rotation == Rotation.CLOCKWISE_90 && axis == Direction.Axis.X || rotation == Rotation.CLOCKWISE_180 || rotation == Rotation.COUNTERCLOCKWISE_90 && axis == Direction.Axis.Z) {
            be.getMaterialItemStorage().remapStorage(s -> s.equals(POSITIVE_LAYERS.m_61708_()) ? NEGATIVE_LAYERS.m_61708_() : POSITIVE_LAYERS.m_61708_());
        }
    }

    @Override
    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirrorIn) {
        state = super.m_6943_(state, mirrorIn);
        return state.m_60717_(mirrorIn.m_54846_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)))));
    }

    @Override
    public void mirror(@NotNull BlockState state, @NotNull MultiStateCopycatBlockEntity be, Mirror mirror) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (mirror == Mirror.FRONT_BACK && axis == Direction.Axis.Z || mirror == Mirror.LEFT_RIGHT && axis == Direction.Axis.X) {
            be.getMaterialItemStorage().remapStorage(s -> s.equals(POSITIVE_LAYERS.m_61708_()) ? NEGATIVE_LAYERS.m_61708_() : POSITIVE_LAYERS.m_61708_());
        }
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{AXIS, HALF, POSITIVE_LAYERS, NEGATIVE_LAYERS}));
    }

    private static VoxelShape calculateMultiFaceShape(BlockState pState) {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)(pState.m_61143_(HALF) == Half.TOP ? TOP_BY_LAYER : BOTTOM_BY_LAYER)[(Integer)pState.m_61143_((Property)POSITIVE_LAYERS)].get(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)pState.m_61143_(AXIS)))));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)(pState.m_61143_(HALF) == Half.TOP ? TOP_BY_LAYER : BOTTOM_BY_LAYER)[(Integer)pState.m_61143_((Property)NEGATIVE_LAYERS)].get(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)((Direction.Axis)pState.m_61143_(AXIS)))));
        return shape;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        VoxelShape shapeOverride = CopycatHalfLayerBlock.multiPlatformGetShape(pState, pLevel, pPos, pContext);
        if (shapeOverride != null) {
            return shapeOverride;
        }
        return Objects.requireNonNull((VoxelShape)this.shapesCache.get((Object)pState));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        if (face.m_122434_().m_122478_() && state.m_61143_(HALF) == Half.TOP == (face == Direction.DOWN)) {
            return (Integer)state.m_61143_((Property)POSITIVE_LAYERS) < 8 || (Integer)state.m_61143_((Property)NEGATIVE_LAYERS) < 8;
        }
        if (face.m_122434_() == state.m_61143_(AXIS)) {
            int negativeLayers = (Integer)state.m_61143_((Property)NEGATIVE_LAYERS);
            int positiveLayers = (Integer)state.m_61143_((Property)POSITIVE_LAYERS);
            if (face.m_122421_() == Direction.AxisDirection.NEGATIVE && negativeLayers < positiveLayers) {
                return true;
            }
            if (face.m_122421_() == Direction.AxisDirection.POSITIVE && positiveLayers < negativeLayers) {
                return true;
            }
        }
        return super.shouldFaceAlwaysRender(state, face);
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return false;
    }
}

