/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.slope_layer;

import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.content.copycat.base.CTWaterloggedCopycatBlock;
import com.copycatsplus.copycats.content.copycat.base.IStateType;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatSlopeLayerBlock
extends CTWaterloggedCopycatBlock
implements ISpecialBlockItemRequirement,
IStateType {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    private static final VoxelShaper[] BOTTOM_SHAPE_BY_LAYER = new VoxelShaper[]{CCShapes.EMPTY, CCShapes.SLOPE_LAYER_BOTTOM_1, CCShapes.SLOPE_LAYER_BOTTOM_2, CCShapes.SLOPE_LAYER_BOTTOM_3, CCShapes.SLOPE_LAYER_BOTTOM_4, CCShapes.SLOPE_LAYER_BOTTOM_5, CCShapes.SLOPE_LAYER_BOTTOM_6, CCShapes.SLOPE_LAYER_BOTTOM_7, CCShapes.LAYER_16PX};
    private static final VoxelShaper[] TOP_SHAPE_BY_LAYER = new VoxelShaper[]{CCShapes.EMPTY, CCShapes.SLOPE_LAYER_TOP_1, CCShapes.SLOPE_LAYER_TOP_2, CCShapes.SLOPE_LAYER_TOP_3, CCShapes.SLOPE_LAYER_TOP_4, CCShapes.SLOPE_LAYER_TOP_5, CCShapes.SLOPE_LAYER_TOP_6, CCShapes.SLOPE_LAYER_TOP_7, CCShapes.LAYER_16PX};

    public CopycatSlopeLayerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{FACING, HALF, LAYERS}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            if ((Integer)state.m_61143_((Property)LAYERS) < 8) {
                return (BlockState)state.m_61122_((Property)LAYERS);
            }
            Copycats.LOGGER.warn("Can't figure out where to place a slope layer! Please file an issue if you see this.");
            return state;
        }
        Half half = context.m_43719_() == Direction.DOWN ? Half.TOP : (context.m_43719_() == Direction.UP ? Half.BOTTOM : (context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5 ? Half.TOP : Half.BOTTOM));
        return (BlockState)((BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)half);
    }

    public boolean m_6864_(@NotNull BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        if ((Integer)pState.m_61143_((Property)LAYERS) == 8) {
            return false;
        }
        Half half = (Half)pState.m_61143_(HALF);
        if (half == Half.TOP && pUseContext.m_43719_() == Direction.DOWN) {
            return true;
        }
        return half == Half.BOTTOM && pUseContext.m_43719_() == Direction.UP;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if ((Integer)state.m_61143_((Property)LAYERS) <= 1) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (player != null && !player.m_7500_()) {
                List drops = Block.m_49874_((BlockState)((BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))), (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                for (ItemStack drop : drops) {
                    player.m_150109_().m_150079_(drop);
                }
            }
            BlockPos up = pos.m_121945_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LAYERS) - 1))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            this.playRemoveSound(world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, new ItemStack((ItemLike)this.m_5456_(), ((Integer)state.m_61143_((Property)LAYERS)).intValue()));
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState toState = reader.m_8055_(toPos);
        return !toState.m_60713_((Block)this);
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (toPos.equals((Object)fromPos.m_121945_(facing))) {
            return false;
        }
        BlockPos diff = fromPos.m_121996_((Vec3i)toPos);
        int coord = facing.m_122434_().m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (!toState.m_60713_((Block)this)) {
            return coord != -facing.m_122421_().m_122540_();
        }
        if (CopycatSlopeLayerBlock.isOccluded(state, toState, facing)) {
            return true;
        }
        return toState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) == state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) && coord == 0;
    }

    private static boolean isOccluded(BlockState state, BlockState other, Direction pDirection) {
        state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        other = (BlockState)other.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing.m_122424_() == other.m_61143_((Property)FACING) && pDirection == facing) {
            return true;
        }
        if (other.m_61143_((Property)FACING) != facing) {
            return false;
        }
        return pDirection.m_122434_() != facing.m_122434_();
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return switch (pType) {
            case PathComputationType.LAND -> {
                if ((Integer)pState.m_61143_((Property)LAYERS) < 5 && ((Direction)pState.m_61143_((Property)FACING)).equals((Object)Direction.UP)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return pState.m_61143_(HALF) == Half.TOP ? TOP_SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)].get((Direction)pState.m_61143_((Property)FACING)) : BOTTOM_SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)].get((Direction)pState.m_61143_((Property)FACING));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Half half = (Half)state.m_61143_(HALF);
        int layers = (Integer)state.m_61143_((Property)LAYERS);
        if (state.m_60713_((Block)this) == neighborState.m_60713_((Block)this)) {
            Direction neighborFacing = (Direction)neighborState.m_61143_((Property)FACING);
            Half neighborHalf = (Half)neighborState.m_61143_(HALF);
            int neighborLayers = (Integer)neighborState.m_61143_((Property)LAYERS);
            if (CopycatSlopeLayerBlock.getMaterial((BlockGetter)level, (BlockPos)pos).m_60719_(CopycatSlopeLayerBlock.getMaterial((BlockGetter)level, (BlockPos)pos.m_121945_(dir)), dir.m_122424_())) {
                return neighborFacing == facing && neighborHalf == half && neighborLayers == layers || (neighborFacing == facing.m_122424_() || neighborLayers == 8) && facing == dir.m_122424_() || (neighborFacing == facing.m_122424_() || layers == 8) && neighborFacing == dir || layers == 8 && neighborLayers == 8;
            }
        }
        return false;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LAYERS) == 8 ? 0.2f : 1.0f;
    }
}

