/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.forge.mixin.copycat.base.multistate;

import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlock;
import com.simibubi.create.AllBlocks;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;

@Mixin(value={MultiStateCopycatBlock.class})
@Pseudo
public abstract class MultiStateCopycatBlockCombinerMixin
extends Block
implements IForgeBlock {
    public MultiStateCopycatBlockCombinerMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return state.m_60827_();
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        Block block = state.m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            AtomicReference<Float> bonus = new AtomicReference<Float>(Float.valueOf(0.0f));
            AtomicInteger count = new AtomicInteger(0);
            mscb.withBlockEntityDo((BlockGetter)level, pos, mscbe -> mscbe.getMaterialItemStorage().getAllMaterials().forEach(mat -> {
                count.getAndIncrement();
                bonus.accumulateAndGet(Float.valueOf(mat.m_60713_(Blocks.f_50016_) ? state.getFriction(level, pos, entity) : mat.getFriction(level, pos, entity)), Float::sum);
            }));
            return bonus.get().floatValue() / (float)count.get();
        }
        return state.m_60734_().m_49958_();
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        Block block = state.m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            AtomicInteger light = new AtomicInteger(0);
            mscb.withBlockEntityDo(level, pos, mscbe -> mscbe.getMaterialItemStorage().getAllMaterials().forEach(bs -> light.accumulateAndGet(bs.m_60791_(), Math::max)));
            return light.get();
        }
        return 0;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        Block block = state.m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            AtomicReference<Float> explosionResistance = new AtomicReference<Float>(Float.valueOf(state.m_60734_().m_7325_()));
            mscb.withBlockEntityDo(level, pos, mscbe -> mscbe.getMaterialItemStorage().getAllMaterials().forEach(bs -> explosionResistance.accumulateAndGet(Float.valueOf(bs.m_60734_().m_7325_()), Math::max)));
            return explosionResistance.get().floatValue();
        }
        return state.m_60734_().getExplosionResistance(state, level, pos, explosion);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        Block block = state1.m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            BlockHitResult hitResult = level.m_45547_(new ClipContext(entity.m_20182_(), entity.m_20182_().m_82520_(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)entity));
            String property = mscb.getProperty(state1, (BlockGetter)level, pos, hitResult, true);
            AtomicReference<BlockState> mat = new AtomicReference<BlockState>(AllBlocks.COPYCAT_BASE.getDefaultState());
            mscb.withBlockEntityDo((BlockGetter)level, pos, mscbe -> mat.set(mscbe.getMaterialItemStorage().getMaterialItem(property).material()));
            return mat.get().addLandingEffects(level, pos, mat.get(), entity, numberOfParticles);
        }
        return false;
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        Block block = state.m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            BlockHitResult hitResult = level.m_45547_(new ClipContext(entity.m_20182_(), entity.m_20182_().m_82520_(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, entity));
            String property = mscb.getProperty(state, (BlockGetter)level, pos, hitResult, true);
            AtomicReference<BlockState> mat = new AtomicReference<BlockState>(AllBlocks.COPYCAT_BASE.getDefaultState());
            mscb.withBlockEntityDo((BlockGetter)level, pos, mscbe -> mat.set(mscbe.getMaterialItemStorage().getMaterialItem(property).material()));
            return mat.get().addRunningEffects(level, pos, entity);
        }
        return false;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        Block block = state.m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            AtomicReference<Float> bonus = new AtomicReference<Float>(Float.valueOf(0.0f));
            mscb.withBlockEntityDo((BlockGetter)level, pos, mscbe -> mscbe.getMaterialItemStorage().getAllMaterials().forEach(mat -> bonus.set(Float.valueOf(((Float)bonus.get()).floatValue() + mat.getEnchantPowerBonus(level, pos)))));
            return bonus.get().floatValue();
        }
        return 0.0f;
    }

    public void m_142072_(@NotNull Level pLevel, @NotNull BlockState state, @NotNull BlockPos pPos, @NotNull Entity pEntity, float p_152430_) {
        Block block = state.m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            BlockHitResult hitResult = pLevel.m_45547_(new ClipContext(pEntity.m_20182_(), pEntity.m_20182_().m_82520_(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, pEntity));
            String property = mscb.getProperty(state, (BlockGetter)pLevel, pPos, hitResult, true);
            AtomicReference<BlockState> material = new AtomicReference<BlockState>(AllBlocks.COPYCAT_BASE.getDefaultState());
            mscb.withBlockEntityDo((BlockGetter)pLevel, pPos, mscbe -> material.set(mscbe.getMaterialItemStorage().getMaterialItem(property).material()));
            material.get().m_60734_().m_142072_(pLevel, material.get(), pPos, pEntity, p_152430_);
        }
    }

    public float m_5880_(@NotNull BlockState pState, @NotNull Player pPlayer, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        Block block = pState.m_60734_();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            String property = mscb.getProperty(pState, pLevel, pPos, new BlockHitResult(Vec3.m_82512_((Vec3i)pPos), Direction.UP, pPos, true), true);
            AtomicReference<BlockState> material = new AtomicReference<BlockState>(AllBlocks.COPYCAT_BASE.getDefaultState());
            mscb.withBlockEntityDo(pLevel, pPos, mscbe -> material.set(mscbe.getMaterialItemStorage().getMaterialItem(property).material()));
            return material.get().m_60625_(pPlayer, pLevel, pPos);
        }
        return pState.m_60625_(pPlayer, pLevel, pPos);
    }
}

